--
-- BaleRunner16K
-- Specialization for automatic bales trailer.
-- @uthor : Bayn - www.tsforum3.com
-- D@te : 12.05.2010
--
-- This script has been made under "OpenSource rules". 
-- That means you can use it without asking authorization, but also without forgetting to quote the author's name.

BaleRunner16K = {};

function BaleRunner16K.prerequisitesPresent(specializations)
    return true;
end;

function BaleRunner16K:load(xmlFile)
	
	local AttachJointXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.AttachJoint#index"));
    if AttachJointXNode ~= nil then
        self.AttachJoint = {};
        self.AttachJoint.node = AttachJointXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.AttachJoint#minRot"));
        self.AttachJoint.minRot = {};
        self.AttachJoint.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.AttachJoint.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.AttachJoint.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.AttachJoint#maxRot"));
        self.AttachJoint.maxRot = {};
        self.AttachJoint.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.AttachJoint.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.AttachJoint.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.AttachJoint.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.AttachJoint#rotTime"), 2)*1000;
        self.AttachJoint.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.AttachJoint#touchRotLimit"), 10));
    end;	
	
	local LoaderXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Loader#index"));
    if LoaderXNode ~= nil then
        self.Loader = {};
        self.Loader.node = LoaderXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Loader#minRot"));
        self.Loader.minRot = {};
        self.Loader.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Loader.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Loader.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Loader#maxRot"));
        self.Loader.maxRot = {};
        self.Loader.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Loader.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Loader.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Loader.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Loader#rotTime"), 2)*1000;
        self.Loader.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Loader#touchRotLimit"), 10));
    end;

	local MainRotationXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MainRotation#index"));
    if MainRotationXNode ~= nil then
        self.MainRotation = {};
        self.MainRotation.node = MainRotationXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MainRotation#minRot"));
        self.MainRotation.minRot = {};
        self.MainRotation.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MainRotation.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MainRotation.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MainRotation#maxRot"));
        self.MainRotation.maxRot = {};
        self.MainRotation.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MainRotation.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MainRotation.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.MainRotation.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.MainRotation#rotTime"), 2)*1000;
        self.MainRotation.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.MainRotation#touchRotLimit"), 10));
    end;

	local PressBar1XNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PressBar1#index"));
    if PressBar1XNode ~= nil then
        self.PressBar1 = {};
        self.PressBar1.node = PressBar1XNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PressBar1#minRot"));
        self.PressBar1.minRot = {};
        self.PressBar1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.PressBar1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.PressBar1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PressBar1#maxRot"));
        self.PressBar1.maxRot = {};
        self.PressBar1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.PressBar1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.PressBar1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.PressBar1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.PressBar1#rotTime"), 2)*250;
        self.PressBar1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.PressBar1#touchRotLimit"), 10));
    end;
	
	local PressBar2XNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PressBar2#index"));
    if PressBar2XNode ~= nil then
        self.PressBar2 = {};
        self.PressBar2.node = PressBar2XNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PressBar2#minRot"));
        self.PressBar2.minRot = {};
        self.PressBar2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.PressBar2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.PressBar2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PressBar2#maxRot"));
        self.PressBar2.maxRot = {};
        self.PressBar2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.PressBar2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.PressBar2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.PressBar2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.PressBar2#rotTime"), 2)*250;
        self.PressBar2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.PressBar2#touchRotLimit"), 10));
    end;
	
	local TranslationAttacher34Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TranslationAttacher34#index"));
    if TranslationAttacher34Node ~= nil then
        self.TranslationAttacher34 = {};
        self.TranslationAttacher34.node = TranslationAttacher34Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.TranslationAttacher34#minTrans"));
        self.TranslationAttacher34.minTrans = {};
        self.TranslationAttacher34.minTrans[1] = Utils.getNoNil(x, 0);
        self.TranslationAttacher34.minTrans[2] = Utils.getNoNil(y, 0);
        self.TranslationAttacher34.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.TranslationAttacher34#maxTrans"));
        self.TranslationAttacher34.maxTrans = {};
        self.TranslationAttacher34.maxTrans[1] = Utils.getNoNil(x, 0);
        self.TranslationAttacher34.maxTrans[2] = Utils.getNoNil(y, 0);
        self.TranslationAttacher34.maxTrans[3] = Utils.getNoNil(z, 0);

        self.TranslationAttacher34.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TranslationAttacher34#transTime"), 2)*1000;
        self.TranslationAttacher34.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TranslationAttacher34#touchTransLimit"), 10);
    end;	
	local TranslationAttacher56Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TranslationAttacher56#index"));
    if TranslationAttacher56Node ~= nil then
        self.TranslationAttacher56 = {};
        self.TranslationAttacher56.node = TranslationAttacher56Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.TranslationAttacher56#minTrans"));
        self.TranslationAttacher56.minTrans = {};
        self.TranslationAttacher56.minTrans[1] = Utils.getNoNil(x, 0);
        self.TranslationAttacher56.minTrans[2] = Utils.getNoNil(y, 0);
        self.TranslationAttacher56.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.TranslationAttacher56#maxTrans"));
        self.TranslationAttacher56.maxTrans = {};
        self.TranslationAttacher56.maxTrans[1] = Utils.getNoNil(x, 0);
        self.TranslationAttacher56.maxTrans[2] = Utils.getNoNil(y, 0);
        self.TranslationAttacher56.maxTrans[3] = Utils.getNoNil(z, 0);

        self.TranslationAttacher56.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TranslationAttacher56#transTime"), 2)*1000;
        self.TranslationAttacher56.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TranslationAttacher56#touchTransLimit"), 10);
    end;	
	local TranslationAttacher78Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TranslationAttacher78#index"));
    if TranslationAttacher78Node ~= nil then
        self.TranslationAttacher78 = {};
        self.TranslationAttacher78.node = TranslationAttacher78Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.TranslationAttacher78#minTrans"));
        self.TranslationAttacher78.minTrans = {};
        self.TranslationAttacher78.minTrans[1] = Utils.getNoNil(x, 0);
        self.TranslationAttacher78.minTrans[2] = Utils.getNoNil(y, 0);
        self.TranslationAttacher78.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.TranslationAttacher78#maxTrans"));
        self.TranslationAttacher78.maxTrans = {};
        self.TranslationAttacher78.maxTrans[1] = Utils.getNoNil(x, 0);
        self.TranslationAttacher78.maxTrans[2] = Utils.getNoNil(y, 0);
        self.TranslationAttacher78.maxTrans[3] = Utils.getNoNil(z, 0);

        self.TranslationAttacher78.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TranslationAttacher78#transTime"), 2)*1000;
        self.TranslationAttacher78.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TranslationAttacher78#touchTransLimit"), 10);
    end;
	
	self.numAttachers = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers#count"), 0);
	self.Attacher = {};
	
	for i=1, self.numAttachers do
	 self.Attacher[i] = {};
	 local partnamei = string.format("vehicle.Attachers.objectAttacher".."%d",i);
	 self.Attacher[i].object = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
	 setRigidBodyType(self.Attacher[i].coll,"none")
	 self.Attacher[i].attachedObject = nil;
	 self.Attacher[i].objectInRange = nil;
	end;		

    self.loadingParticleSystems = {};
    local psName = "vehicle.loadingParticleSystems";
	local psNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.loadingParticleSystems#index"));	
    Utils.loadParticleSystem(xmlFile, self.loadingParticleSystems, psName, psNode, false, nil, self.baseDirectory)
    self.loadingParticleSystemActive = false;
	
    self.UnloadingParticleSystems = {};
    local psName = "vehicle.UnloadingParticleSystems";
	local psNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.UnloadingParticleSystems#index"));	
    Utils.loadParticleSystem(xmlFile, self.UnloadingParticleSystems, psName, psNode, false, nil, self.baseDirectory)
    self.UnloadingParticleSystemActive = false;

	self.Timer = 500;
	self.WorkMode= false;
	self.ReadyMode = true;
	self.GoParticle = false;
	self.LoaderisOkForPS = false;
	
	self.translation34Min = true;
	self.translation34Max = false;
	self.translation56Min = true;
	self.translation56Max = false;
	self.translation78Min = true;
	self.translation78Max = false;
	self.PressBar1Max = true;
	self.PressBar2Max = true;	
	self.PressBar1Min = false;
	self.PressBar2Min = false;	
	self.GoParticle = true;
	self.Timer = 500;
	
end;

function BaleRunner16K:getSaveAttributesAndNodes(nodeIdent)
    for i=1, self.numAttachers do
        ObjectDetachBaleRunner16K(self,i)
    end;
   return nil, nil;
end;

function BaleRunner16K:delete()
	for i=1, self.numAttachers do
		ObjectDetachBaleRunner16K(self,i)
	end;
    Utils.deleteParticleSystem(self.loadingParticleSystems);
    Utils.deleteParticleSystem(self.UnloadingParticleSystems);
end;

function BaleRunner16K:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BaleRunner16K:keyEvent(unicode, sym, modifier, isDown)
end;

function BaleRunner16K:update(dt)
	
    if self:getIsActiveForInput() then
		if self.isActive then
		
	-- Transport or Work mode --
		
			if InputBinding.hasEvent(InputBinding.BR16KWORKMODE) and not self.ReadyMode  then
				self.AttachJointMax = not self.AttachJointMax;
			else
				local x, y, z = getRotation(self.Loader.node);
				local maxRot = self.Loader.maxRot;
				local minRot = self.Loader.minRot;
				local eps = self.Loader.touchRotLimit;
				if  (math.abs(x-minRot[1]) < eps) then
					self.AttachJointMin = not self.AttachJointMin;
				end;
			end;
			
			if self.AttachJointMax then 
				self.WorkMode = true;
			else
				self.WorkMode = false;
			end;
			
			local doRotate = self.AttachJointMax or self.AttachJointMin 
			if self.AttachJoint ~= nil and doRotate then
				local x, y, z = getRotation(self.componentJoints[1].jointNode);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.AttachJoint.maxRot, self.AttachJoint.minRot, 3, self.AttachJoint.rotTime, dt, not self.AttachJointMax);
				setRotation(self.componentJoints[1].jointNode,unpack(newRot));
			end;
			setJointFrame(self.componentJoints[1].jointIndex, 1,self.componentJoints[1].jointNode);
			
	-- 	Ready to work Mode -- 	
	
			if InputBinding.hasEvent(InputBinding.BR16KREADYMODE) and self.WorkMode then
				self.LoaderMax = not self.LoaderMax;
			end;		
			
			if self.LoaderMax then 
				self.ReadyMode = true;
			else
				self.ReadyMode = false;
			end;
		
			if self.Loader ~= nil then
			local x, y, z = getRotation(self.Loader.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.Loader.maxRot, self.Loader.minRot, 3, self.Loader.rotTime, dt, not self.LoaderMax);
			setRotation(self.Loader.node, unpack(newRot));
			end;
			setJointFrame(self.componentJoints[3].jointIndex, 1,self.componentJoints[3].jointNode);

	
	-- 	Attaching bales on the loader. PressBars react. -- 	
	

			if InputBinding.hasEvent(InputBinding.BR16KATTACH) then
			
				self.PressBar1Min = true;
				self.PressBar2Min = true;	
				self.PressBar1Max = false;
				self.PressBar2Max = false;	
				
			if self.ReadyMode then
               -- bale 1 detect
                  nearest, index = ObjectInRangeBaleRunner16K(self,1);
              -- bale 1 attach
                  self.Attacher[1].objectInRange = nearest;
                  ObjectAttachBaleRunner16K(self,1)
               -- bale2 if bale 1 attached
                  if self.Attacher[1].attachedObject ~= nil then
                     -- bale 2 detect
                     nearest, index = ObjectInRangeBaleRunner16K(self,2);
                     -- bale 2 attach
                     self.Attacher[2].objectInRange = nearest;
                     ObjectAttachBaleRunner16K(self,2)
                  end;
             end;
			
			end;	

			if InputBinding.hasEvent(InputBinding.BR16KDETACH) then
			
				self.PressBar1Max = true;
				self.PressBar2Max = true;	
				self.PressBar1Min = false;
				self.PressBar2Min = false;		
				
				if self.ReadyMode then
					-- detach bales
					for i=1, 2 do
						ObjectDetachBaleRunner16K(self,i)
					end;
				end;				
			end;
				
			local doRotate = self.PressBar2Max or self.PressBar2Min 
			if self.PressBar2 ~= nil and doRotate then
			local x, y, z = getRotation(self.PressBar2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.PressBar2.maxRot, self.PressBar2.minRot, 3, self.PressBar2.rotTime, dt, not self.PressBar2Max);
			setRotation(self.PressBar2.node, unpack(newRot));
			end;
			
			local doRotate = self.PressBar1Max or self.PressBar1Min 
			if self.PressBar1 ~= nil and doRotate then
			local x, y, z = getRotation(self.PressBar1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.PressBar1.maxRot, self.PressBar1.minRot, 3, self.PressBar1.rotTime, dt, not self.PressBar1Max);
			setRotation(self.PressBar1.node, unpack(newRot));
			end;
			
	-- When loader is full and at rotation Max, detach the bales to transfer them to the main part --
		if self.Attacher[7].attachedObject == nil or self.Attacher[8].attachedObject == nil  then
		if self.Attacher[1].attachedObject ~= nil or self.Attacher[2].attachedObject ~= nil  then
			local x, y, z = getRotation(self.Loader.node);
			local maxRot = self.Loader.maxRot;
			local minRot = self.Loader.minRot;
			local eps = self.Loader.touchRotLimit;
			if  (math.abs(x-minRot[1]) < eps) then
				self.LoaderisAtMin = true;
				-- detach bales
				for i=1, 2 do
				ObjectDetachBaleRunner16K(self,i)
				end;
				self.PressBar1Max = true;
				self.PressBar2Max = true;	
				self.PressBar1Min = false;
				self.PressBar2Min = false;
			else
				self.LoaderisAtMin = false;
			end;	
		end;
		end;
		
	-- Detect loaded and detached bales to attach them on the main Attachers --
		local x, y, z = getRotation(self.MainRotation.node);
		local maxRot = self.MainRotation.maxRot;
		local minRot = self.MainRotation.minRot;
		local eps = self.MainRotation.touchRotLimit;
		if  (math.abs(x-minRot[1]) < eps) then
			if self.LoaderisAtMin  then
			-- dtection ballot
				for i=3, self.numAttachers  do
					nearest, index = ObjectInRangeBaleRunner16K(self,i);
					self.Attacher[i].objectInRange = nearest;
			-- accrochage
					ObjectAttachBaleRunner16K(self,i)
				end;	
			end;
		end;
		
	-- Moving main active attachers along the main part --
	
		if self.Attacher[3].attachedObject ~= nil or self.Attacher[4].attachedObject ~= nil then
			self.translation34Max = true;
			--print("self.translation34Max")
		end;	
		if self.Attacher[5].attachedObject ~= nil or self.Attacher[6].attachedObject ~= nil then
			self.translation56Max = true;
			--print("self.translation56Max")
		end;	
		if self.Attacher[7].attachedObject ~= nil or self.Attacher[8].attachedObject ~= nil then
			self.translation78Max = true;
			--print("self.translation78Max")
		end;

	
		local doTranslate = self.translation34Max or self.translation34Min
		if self.TranslationAttacher34 ~= nil and doTranslate then	
			local x, y, z = getTranslation(self.TranslationAttacher34.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.TranslationAttacher34.maxTrans, self.TranslationAttacher34.minTrans, 3, self.TranslationAttacher34.transTime, dt, not self.translation34Max);
			setTranslation(self.TranslationAttacher34.node, unpack(newTrans));
		end;	
		local doTranslate = self.translation56Max or self.translation56Min
		if self.TranslationAttacher56 ~= nil and doTranslate then	
			local x, y, z = getTranslation(self.TranslationAttacher56.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.TranslationAttacher56.maxTrans, self.TranslationAttacher56.minTrans, 3, self.TranslationAttacher56.transTime, dt, not self.translation56Max);
			setTranslation(self.TranslationAttacher56.node, unpack(newTrans));
		end;	
		local doTranslate = self.translation78Max or self.translation78Min
		if self.TranslationAttacher78 ~= nil and doTranslate then	
			local x, y, z = getTranslation(self.TranslationAttacher78.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.TranslationAttacher78.maxTrans, self.TranslationAttacher78.minTrans, 3, self.TranslationAttacher78.transTime, dt, not self.translation78Max);
			setTranslation(self.TranslationAttacher78.node, unpack(newTrans));
		end;
		
	-- Main rotation to unload bales --
	
			if InputBinding.hasEvent(InputBinding.BR16KMainUP) then
				self.MainRotationMax = true;
				self.MainRotationMin = false;
			else
				--self.MainRotationMax = false;
			end;
			if InputBinding.hasEvent(InputBinding.BR16KMainDOWN) then
				self.MainRotationMin = true;
				self.MainRotationMax = false;
			else
				--self.MainRotationMin = false;
			end;
	
			local doRotate = self.MainRotationMax or self.MainRotationMin 
			if self.MainRotation ~= nil and doRotate then
			local x, y, z = getRotation(self.MainRotation.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.MainRotation.maxRot, self.MainRotation.minRot, 3, self.MainRotation.rotTime, dt, not self.MainRotationMax);
			setRotation(self.MainRotation.node, unpack(newRot));
			end;	
			
	-- Unloading all bales and move main attachers to their start position --
			local x, y, z = getRotation(self.MainRotation.node);
			local maxRot = self.MainRotation.maxRot;
			local minRot = self.MainRotation.minRot;
			local eps = self.MainRotation.touchRotLimit;
			if  (math.abs(x-maxRot[1]) < eps) then
				if InputBinding.hasEvent(InputBinding.BR16KRELEASEALL) then
					for i=1, self.numAttachers do
					ObjectDetachBaleRunner16K(self,i)
					self.Attacher[i].attachedObject = nil;
					end;
					self.translation34Min = true;
					self.translation34Max = false;
					self.translation56Min = true;
					self.translation56Max = false;
					self.translation78Min = true;
					self.translation78Max = false;
					self.PressBar1Max = true;
					self.PressBar2Max = true;	
					self.PressBar1Min = false;
					self.PressBar2Min = false;	
					self.GoParticle = true;
					self.Timer = 500;
				end;
			end;
			
			-- Particle Systems --
			
			-- 1. Loading --
			local x, y, z = getRotation(self.Loader.node);
			local maxRot = self.Loader.maxRot;
			local minRot = self.Loader.minRot;
			local eps = self.Loader.touchRotLimit;
			if  (math.abs(x-minRot[1]) < eps) then
				self.LoaderisOkForPS = true;
			else
				self.LoaderisOkForPS = false;
			end;
				
			if self.lastSpeed*3600 > 3 and not self.loadingParticleSystemActive and not self.LoaderisOkForPS then
				if self.Attacher[1].attachedObject ~= nil or self.Attacher[2].attachedObject ~= nil then
					self.loadingParticleSystemActive = true;
					Utils.setEmittingState(self.loadingParticleSystems, true);
				end;
            end;

            if self.lastSpeed*3600 < 3 and self.loadingParticleSystemActive or self.Attacher[1].attachedObject == nil and self.Attacher[2].attachedObject == nil or self.LoaderisOkForPS then
				self.loadingParticleSystemActive = false;
				Utils.setEmittingState(self.loadingParticleSystems, false);
            end;
			-- 2. Main unloading -- 
				if self.GoParticle then
					if self.Timer>0 then
						self.Timer = self.Timer - dt;
						self.UnloadingParticleSystemActive = true;
						Utils.setEmittingState(self.UnloadingParticleSystems, true);				
					else
						if self.Timer<=0 then
							self.UnloadingParticleSystemActive = false;
							Utils.setEmittingState(self.UnloadingParticleSystems, false);			
						end;
					end;
				end;
		end;
	end;
end;

function BaleRunner16K:draw()  

end;

function ObjectInRangeBaleRunner16K(self,k)
	local nearestObject
	local itemNode
	local index 
	local nearestDistance = 1.0;
	local objectCopy = self.Attacher[k].object;	
	local px, py, pz = getWorldTranslation(objectCopy);
	--for i=1, table.getn(g_currentMission.itemsToSave) do
	    --itemNode = g_currentMission.itemsToSave[i].node;
	for i,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then
			itemNode = item.item.nodeId
			if getParent(itemNode) == getRootNode() then
			--if getUserAttribute(itemNode, "isStrawbale") or getUserAttribute(itemNode, "isHaybale") then
				local vx, vy, vz = getWorldTranslation(itemNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					index = i
					nearestObject = itemNode
					nearestDistance = distance
					
				end;
			end;
		end;
	end;
	return nearestObject, index
end;

function ObjectAttachBaleRunner16K(self,k)
	if self.Attacher[k].objectInRange ~= nil then
		if self.Attacher[k].attachedObject == nil then
			--setRigidBodyType(self.Attacher[k].objectInRange,"none");
			local x,y,z = getWorldRotation(self.Attacher[k].objectInRange);		
			link(self.Attacher[k].object,self.Attacher[k].objectInRange);
			setRotation(self.Attacher[k].objectInRange, 0,0,0);
			setTranslation(self.Attacher[k].objectInRange, 0,0,0)
			self.Attacher[k].attachedObject = self.Attacher[k].objectInRange;
			self.Attacher[k].objectInRange = nil;
		end;
	end;
end;

function ObjectDetachBaleRunner16K(self,k)
	if self.Attacher[k].attachedObject ~= nil then			
		local x,y,z = getWorldTranslation(self.Attacher[k].attachedObject)
		local rx,ry,rz = getWorldRotation(self.Attacher[k].attachedObject)
		local root = getRootNode()
		setTranslation(self.Attacher[k].attachedObject,x,y,z)
		setRotation(self.Attacher[k].attachedObject,rx,ry,rz)
		link(root,self.Attacher[k].attachedObject)
		--setRigidBodyType(self.Attacher[k].attachedObject,"Dynamic")
		self.Attacher[k].attachedObject = nil;
	end;
end;


