--|----------------------------------------------------------------|--
--|                                                                |--
--|                           SafePlow                             |--
--|         This specialization adds Safe-Mode to Ploughs          |--
--|                                                                |--
--|                  By: SndGrdn July 2, 2012                      |--
--|                                                                |--
--|----------------------------------------------------------------|--
--|                       Version BETA                             |--
--|----------------------------------------------------------------|--
SafePlow = {};

function SafePlow.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function SafePlow:load(xmlFile)

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.3);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
 
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;

	 self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
   self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;
   self.ploughLimitToField = true;
	 self.AIon = false;
	 self.onlyActiveWhenLowered = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.onlyActiveWhenLowered#value"), true);	
	 
end;

function SafePlow:delete()
end;

function SafePlow:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SafePlow:keyEvent(unicode, sym, modifier, isDown)
end;

function SafePlow:update(dt)

		if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
						self.ploughLimitToField = not self.ploughLimitToField;
				end;
		end;

		if self.attacherVehicle then
		
			if self.attacherVehicle.isAITractorActivated ~= nil then
					self.AIon = self.attacherVehicle.isAITractorActivated;	
			end;

		if not self.onlyActiveWhenLowered or self:isLowered(false) then
				local x,y,z = getWorldTranslation(self.groundReferenceNode);
				local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				if terrainHeight+self.groundReferenceThreshold >= y then 
					self.go=false;
					if table.getn(self.cuttingAreas) > 0 then
						local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
						local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
						local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
						Utils.updatePloughArea(x, z, x1, z1, x2, z2, false);
					end;
				end;
		end;
	end;

end;

function SafePlow:draw()

	if self.ploughLimitToField then
		g_currentMission:addHelpButtonText("Switch to Normal Mode", InputBinding.IMPLEMENT_EXTRA2);
	else
		g_currentMission:addHelpButtonText("Switch to Safe Mode", InputBinding.IMPLEMENT_EXTRA2);
	end;

end;

function SafePlow:onAttach(attacherVehicle)
end;

function SafePlow:onDetach()	
end;
 
function SafePlow:onEnter()
end;

function SafePlow:onLeave()
end;
 
function SafePlow:onActivate()
end;

function SafePlow:onDeactivate()
end;

function SafePlow:aiTurnOn()
   self.ploughLimitToField = true;
end;

function SafePlow:aiTurnOff()
   self.ploughLimitToField = true;
end;

function SafePlow:aiLower()
end; 

function SafePlow:aiRaise()
end;
