--
-- Godetgrain
-- This is the specialization for Godetgrain
--
-- M@D Author  Headshot XXL
-- M@D date 01.07.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

Godetgrain = {};

function Godetgrain.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Godetgrain:load(xmlFile)
     
        self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
	self.fallOut = false;
	self.fallOut2 = false;
	self.implementFallOut = true;
	self.isShovel = true;
          self.groundCheck = {};
   self.groundCheck = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundCheck#index"));

end;


function Godetgrain:delete()
end;

function Godetgrain:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Godetgrain:keyEvent(unicode, sym, modifier, isDown)
end;

function Godetgrain:update(dt)
 self.fallOut2 = false;
local x,y,z = getWorldTranslation(self.groundCheck);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gC = y-terrainHeight; 
		
if (math.min(gC) < 0.5) then
  self.fallOut = false;
  self.fallOut2 = false;
  if self.implementFallOut then
 local totalArea =0;
 local usedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;

    for k, cuttingArea in pairs(self.cuttingAreas) do
                        if self:getIsAreaActive(cuttingArea) then

				 local x,y,z = getWorldTranslation(cuttingArea.start);
                                 local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                                 local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                            
                            for fillType,v in pairs(self.fillTypes) do
                               local fruitType = FruitUtil.fillTypeToFruitType[fillType];                             
                                     
                              if fruitType ~= nil and fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN and self.fillLevel < self.capacity then
                                self.fallOut2 = false;
                               local desc = FruitUtil.fruitIndexToDesc[fruitType];
                               local fruitTypeToCut = fruitType;                                     
                                 local area = Utils.updateFruitWindrowArea(fruitTypeToCut, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;                                 
                                       if area > 0 then
                                              totalArea = totalArea+area; 
                                              usedFruitType = fruitType;
                                               if usedFruitType == FruitUtil.FRUITTYPE_PAILLAGE then
                                                  self.fillScale = 0.1;
                                               elseif usedFruitType == FruitUtil.FRUITTYPE_MANURE then
                                                  self.fillscale = 10;
                                               elseif usedFruitType == FruitUtil.FRUITTYPE_MAIZE then
                                                     fruitType = FruitUtil.FRUITTYPE_CHAFF;
                                                     usedFruitType = FruitUtil.FRUITTYPE_CHAFF;
                                                  self.fillscale = 1;
                                               end;                                                                                           
                                       end;

                              end;
                            end;
                                                                                        			                          
		       end;
    end;


     if totalArea > 0 then
                    local literPerPixel = g_currentMission:getFruitPixelsToSqm()*g_strawLitersPerSqm;  --8000/1200 / 6 / (2*2) *12/4 / 4;
                       self.fallOut = false;
                        self.fallOut2 = false;                                     
                      
                       local deltaLevel = totalArea * literPerPixel * self.fillScale;
                       local usedFillType = FruitUtil.fruitTypeToFillType[usedFruitType];
                       local oldFillLevel = self.fillLevel;
                       self:setFillLevel(self.fillLevel+deltaLevel, usedFillType);
     end;
  end;
end;
	if self.attacherVehicle ~= nil then
		self.fallOut2 = false;
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 1, 0));
		if z > 0 then
			self.fallOut = true;
		else
			self.fallOut = false;                        
		end;
		self.kippWinkel = z;
	end;
 if self.isClient then	
	if self.fallOut and self.implementFallOut then
            if self.fillLevel == 0 then
		self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	     end;
		
		
		
		local nearestDistance = 5.0;
		local px, py, pz = getWorldTranslation(self.tipReferencePoint);
		for i=1, table.getn(g_currentMission.attachables) do
			local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

			if distance < nearestDistance then
				local attachable = g_currentMission.attachables[i];		
				if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
					if self.currentFillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
						if attachable.fillLevel < attachable.capacity  and self.fillLevel > 1 then							
							local deltaLevel = (self.kippWinkel*self.kippWinkel)*(self.capacity/200)*dt							
							local fillDelta = math.min(deltaLevel, self.fillLevel)
							self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
							attachable:setFillLevel(attachable.fillLevel + fillDelta, self.currentFillType);
							self.fallOut2 = self.fillLevel>0 and fillDelta>0;
                                                        
	                                          						
						end; 
					end;
				end;
			end;
		
              end;
         end; 
	Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.fallOut2);
end;

end;

function Godetgrain:draw()
end;

function Godetgrain:onDetach()
    if self.deactivateOnDetach then
        Godetgrain.onDeactivate(self);
    end;
end;

function Godetgrain:onDeactivate()
    self.fallOut = false;
end;

