--
-- Royal Bank of LS Kredit 2.5Mil v1.2
-- 
--
-- @author  Neelson
-- @date  	29/10/2011
--
print("royalbankoflskredit2_5m v1.2 loaded");
royalbankoflskredit2_5m = {};
royalbankoflskredit2_5m.kredithoehe = 2500000;
royalbankoflskredit2_5m.zinssatzLeicht = 8;
royalbankoflskredit2_5m.zinssatzNormal = 16;
royalbankoflskredit2_5m.zinssatzSchwer = 24;

function royalbankoflskredit2_5m.prerequisitesPresent(specializations)
    return true;
end;

function royalbankoflskredit2_5m:load(xmlFile)
	self.zinsbetrag = royalbankoflskredit2_5m:getCurrentZinsbetrag();
	
	if royalbankoflsdisplay.royalbankoflsdisplay.isDisplayModLoaded then
		self.isDisplayModLoaded = true;
	else
		self.isDisplayModLoaded = false;		
	end;
		
	if self.isDisplayModLoaded then
		royalbankoflsdisplay.royalbankoflsdisplay:addCreditSum(royalbankoflskredit2_5m.kredithoehe);
		royalbankoflsdisplay.royalbankoflsdisplay:addZinsSum(self.zinsbetrag)
	end;	
	
	self.kreditabloese = royalbankoflskredit2_5m.kredithoehe * ((g_currentMission.missionStats.difficulty * 0.01) + 1);
	g_currentMission:addSharedMoney(royalbankoflskredit2_5m.kredithoehe);
	
	self.firstRun = false;
	self.lastday = g_currentMission.environment.currentDay;	
end;

function royalbankoflskredit2_5m:delete()
	if self.isDisplayModLoaded then
		royalbankoflsdisplay.royalbankoflsdisplay:subCreditSum(royalbankoflskredit2_5m.kredithoehe);
		self.zinsbetrag = royalbankoflskredit2_5m:getCurrentZinsbetrag();
		royalbankoflsdisplay.royalbankoflsdisplay:subZinsSum(self.zinsbetrag);
	end;
	g_currentMission:addSharedMoney(-self.kreditabloese);
end;

function royalbankoflskredit2_5m:mouseEvent(posX, posY, isDown, isUp, button)
end;

function royalbankoflskredit2_5m:keyEvent(unicode, sym, modifier, isDown)
end;

function royalbankoflskredit2_5m:update(dt)
	if g_currentMission.environment.currentDay ~= self.lastday then
		self.zinsbetrag = royalbankoflskredit2_5m:getCurrentZinsbetrag();
		g_currentMission:addSharedMoney(-self.zinsbetrag);
		self.lastday = g_currentMission.environment.currentDay;
		if self.firstRun then
			if self.lastMoney ~= g_currentMission.missionStats.money then
				g_currentMission.missionStats.money = self.lastMoney;
			end;
			self.firstRun = false;
		end;
	end;	
end;

function royalbankoflskredit2_5m:draw()
	
end;

function royalbankoflskredit2_5m:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	g_currentMission:addSharedMoney(-royalbankoflskredit2_5m.kredithoehe);
	self.lastMoney = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#lastMoney"), g_currentMission.missionStats.money);
	self.firstRun = true;
		
	return BaseMission.VEHICLE_LOAD_OK;
end;

function royalbankoflskredit2_5m:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'lastMoney="' .. tostring(g_currentMission.missionStats.money) ..'"';	
	
	return attributes, nil;
end;

function royalbankoflskredit2_5m:getTimeScaleFaktor()
	local uhrzeit = (g_currentMission.environment.dayTime/60/60/1000);
	local timeScaleFaktor = 60;
	
	if (uhrzeit > 20) then
		timeScaleFaktor = 240;
	end;

	if (uhrzeit < 6) then
		timeScaleFaktor = 240;
	end;
	
	return timeScaleFaktor;
end;

function royalbankoflskredit2_5m:isDay()
	local uhrzeit = (g_currentMission.environment.dayTime/60/60/1000);
	local isDay = true;
	
	if (uhrzeit > 20) then
		isDay = false;
	end;

	if (uhrzeit < 6) then
		isDay = false;
	end;
	
	return isDay;
end;

function royalbankoflskredit2_5m:getCurrentZinsbetrag()
	local zinsatz = 1.0;
	if g_currentMission.missionStats.difficulty == 1 then
		zinsatz = (royalbankoflskredit2_5m.zinssatzLeicht * 0.01) + 1;
	else
		if g_currentMission.missionStats.difficulty == 2 then
			zinsatz = (royalbankoflskredit2_5m.zinssatzNormal * 0.01) + 1;
		else
			zinsatz = (royalbankoflskredit2_5m.zinssatzSchwer * 0.01) + 1;
		end;
	end;
		
	if royalbankoflskredit2_5m:isDay() then
		timescale = g_currentMission.environment.timeScale;
	else
		timescale = g_currentMission.environment.timeScale / 4;
	end;
	
	local zinsbetrag = (((royalbankoflskredit2_5m.kredithoehe * zinsatz) - royalbankoflskredit2_5m.kredithoehe) / timescale);
	
	return math.ceil(zinsbetrag);
end;