--
-- @title	Bale Destroy Prices
-- @desc	Allows adjustment of Wrapped/Round/Square bale prices.
-- 
-- @author	TwistedGA
-- @date	06/12/2011
--
-- You may edit the values of prices and release for Multiplayer. 
-- You may not edit the values found nested within the function without permission.
-- Please contact me with any questions or concerns. Thanks
--
bdp = {};
-- These values will be multiplied by the current difficulty level to determine the sale price.
-- Easy = 4 | Normal = 2 | Hard = 1
wrapped_bale = 1000;
round_bale = 750;
square_bale = 500;
----
function bdp:triggerCallbackTarget(triggerId, otherId, onEnter, onLeave, onStay)
	local object = g_currentMission:getNodeObject(otherId);	
	local i3dFilename = object.i3dFilename;	
	local round = string.find(i3dFilename, "round");
	local wrapped = string.find(i3dFilename, "wrapped");
	if object ~= nil and object:isa(Bale) then
		if wrapped ~= nil then
			object.baleValue = wrapped_bale;
		elseif round ~= nil then
			object.baleValue = round_bale;
		else
			object.baleValue = square_bale;
		end;
	end;
end;
BarnMoverTrigger.triggerCallbackTarget = Utils.appendedFunction(bdp.triggerCallbackTarget, BarnMoverTrigger.triggerCallbackTarget);