--
-- Royal Bank of LS Display v1.1.1
-- 
--
-- @author  Neelson
-- @date  	01/11/2011
--

print("royalbankoflsdisplay v1.1.1 loaded");

royalbankoflsdisplay = {};
royalbankoflsdisplay.kreditsumme = 0;
royalbankoflsdisplay.zinssumme = 0;

function royalbankoflsdisplay:loadMap(name)
	self.isDisplayModLoaded = true;
	self.displayOn = false;
end;

function royalbankoflsdisplay:deleteMap()
end;


function royalbankoflsdisplay:delete()
end;

function royalbankoflsdisplay:mouseEvent(posX, posY, isDown, isUp, button)
end;

function royalbankoflsdisplay:keyEvent(unicode, sym, modifier, isDown)
end;

function royalbankoflsdisplay:update(dt)		
	if (InputBinding.hasEvent(InputBinding.RBoLS_ONOFFKEY) and Input.isKeyPressed(Input.KEY_lalt)) then
		if self.displayOn then
			self.displayOn = false;
		else
			self.displayOn = true;
		end;	
	end;
end;

function royalbankoflsdisplay:draw()
	if g_currentMission.showHelpText then
		g_currentMission:addHelpButtonText(g_i18n:getText("RBoLS_ONOFFKEY"), InputBinding.RBoLS_ONOFFKEY);
	end;
	
	if self.displayOn then
		g_currentMission:addWarning('- ROYAL BANK OF LS -' .. "\n\n" .. g_i18n:getText("RBoLS_KREDITSUMMETEXT") .. ': ' .. string.format(royalbankoflsdisplay.kreditsumme) .. ' EUR' .. "\n" ..  g_i18n:getText("RBoLS_ZINSSUMMETEXT") .. ': ' .. string.format(royalbankoflsdisplay.zinssumme) .. ' EUR', 0.05, 0.025+0.007);
	end;	
end;

function royalbankoflsdisplay:addCreditSum(wert)
	royalbankoflsdisplay.kreditsumme = royalbankoflsdisplay.kreditsumme + wert;
end;

function royalbankoflsdisplay:getCreditSum()
	return royalbankoflsdisplay.kreditsumme;
end;

function royalbankoflsdisplay:subCreditSum(wert)
	royalbankoflsdisplay.kreditsumme = royalbankoflsdisplay.kreditsumme - wert;
end;

function royalbankoflsdisplay:addZinsSum(wert)
	royalbankoflsdisplay.zinssumme = royalbankoflsdisplay.zinssumme + wert;
end;

function royalbankoflsdisplay:getZinsSum()
	return royalbankoflsdisplay.zinssumme;
end;

function royalbankoflsdisplay:subZinsSum(wert)
	royalbankoflsdisplay.zinssumme = royalbankoflsdisplay.zinssumme - wert;
end;


addModEventListener(royalbankoflsdisplay);