--
-- Royal Bank of LS Kredit 500k v1.2
-- 
--
-- @author  Neelson
-- @date  	29/10/2011
--
print("royalbankoflskredit500k v1.2 loaded");
royalbankoflskredit500k = {};
royalbankoflskredit500k.kredithoehe = 500000;
royalbankoflskredit500k.zinssatzLeicht = 8;
royalbankoflskredit500k.zinssatzNormal = 16;
royalbankoflskredit500k.zinssatzSchwer = 24;

function royalbankoflskredit500k.prerequisitesPresent(specializations)
    return true;
end;

function royalbankoflskredit500k:load(xmlFile)
	self.zinsbetrag = royalbankoflskredit500k:getCurrentZinsbetrag();
	
	if royalbankoflsdisplay.royalbankoflsdisplay.isDisplayModLoaded then
		self.isDisplayModLoaded = true;
	else
		self.isDisplayModLoaded = false;		
	end;
		
	if self.isDisplayModLoaded then
		royalbankoflsdisplay.royalbankoflsdisplay:addCreditSum(royalbankoflskredit500k.kredithoehe);
		royalbankoflsdisplay.royalbankoflsdisplay:addZinsSum(self.zinsbetrag)
	end;	
	
	self.kreditabloese = royalbankoflskredit500k.kredithoehe * ((g_currentMission.missionStats.difficulty * 0.01) + 1);
	g_currentMission:addSharedMoney(royalbankoflskredit500k.kredithoehe);
	
	self.firstRun = false;
	self.lastday = g_currentMission.environment.currentDay;	
end;

function royalbankoflskredit500k:delete()
	if self.isDisplayModLoaded then
		royalbankoflsdisplay.royalbankoflsdisplay:subCreditSum(royalbankoflskredit500k.kredithoehe);
		self.zinsbetrag = royalbankoflskredit500k:getCurrentZinsbetrag();
		royalbankoflsdisplay.royalbankoflsdisplay:subZinsSum(self.zinsbetrag);
	end;
	g_currentMission:addSharedMoney(-self.kreditabloese);
end;

function royalbankoflskredit500k:mouseEvent(posX, posY, isDown, isUp, button)
end;

function royalbankoflskredit500k:keyEvent(unicode, sym, modifier, isDown)
end;

function royalbankoflskredit500k:update(dt)
	if g_currentMission.environment.currentDay ~= self.lastday then
		self.zinsbetrag = royalbankoflskredit500k:getCurrentZinsbetrag();
		g_currentMission:addSharedMoney(-self.zinsbetrag);
		self.lastday = g_currentMission.environment.currentDay;
		if self.firstRun then
			if self.lastMoney ~= g_currentMission.missionStats.money then
				g_currentMission.missionStats.money = self.lastMoney;
			end;
			self.firstRun = false;
		end;
	end;	
end;

function royalbankoflskredit500k:draw()
	
end;

function royalbankoflskredit500k:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	g_currentMission:addSharedMoney(-royalbankoflskredit500k.kredithoehe);
	self.lastMoney = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#lastMoney"), g_currentMission.missionStats.money);
	self.firstRun = true;
		
	return BaseMission.VEHICLE_LOAD_OK;
end;

function royalbankoflskredit500k:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'lastMoney="' .. tostring(g_currentMission.missionStats.money) ..'"';	
	
	return attributes, nil;
end;

function royalbankoflskredit500k:getTimeScaleFaktor()
	local uhrzeit = (g_currentMission.environment.dayTime/60/60/1000);
	local timeScaleFaktor = 60;
	
	if (uhrzeit > 20) then
		timeScaleFaktor = 240;
	end;

	if (uhrzeit < 6) then
		timeScaleFaktor = 240;
	end;
	
	return timeScaleFaktor;
end;

function royalbankoflskredit500k:isDay()
	local uhrzeit = (g_currentMission.environment.dayTime/60/60/1000);
	local isDay = true;
	
	if (uhrzeit > 20) then
		isDay = false;
	end;

	if (uhrzeit < 6) then
		isDay = false;
	end;
	
	return isDay;
end;

function royalbankoflskredit500k:getCurrentZinsbetrag()
	local zinsatz = 1.0;
	if g_currentMission.missionStats.difficulty == 1 then
		zinsatz = (royalbankoflskredit500k.zinssatzLeicht * 0.01) + 1;
	else
		if g_currentMission.missionStats.difficulty == 2 then
			zinsatz = (royalbankoflskredit500k.zinssatzNormal * 0.01) + 1;
		else
			zinsatz = (royalbankoflskredit500k.zinssatzSchwer * 0.01) + 1;
		end;
	end;
		
	if royalbankoflskredit500k:isDay() then
		timescale = g_currentMission.environment.timeScale;
	else
		timescale = g_currentMission.environment.timeScale / 4;
	end;
	
	local zinsbetrag = (((royalbankoflskredit500k.kredithoehe * zinsatz) - royalbankoflskredit500k.kredithoehe) / timescale);
	
	return math.ceil(zinsbetrag);
end;