-- Original Script Fendtmanfelix
-- @modified Mev01
-- @date  13/04/09

Baletransporter = {};

function Baletransporter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Baletransporter:load(xmlFile)


    local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;

    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;

    local rotationPartNodeKipp = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKipp#index"));
    if rotationPartNodeKipp ~= nil then
        self.rotationPartKipp = {};
        self.rotationPartKipp.node = rotationPartNodeKipp;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKipp#minRot"));
        self.rotationPartKipp.minRot = {};
        self.rotationPartKipp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKipp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKipp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKipp#maxRot"));
        self.rotationPartKipp.maxRot = {};
        self.rotationPartKipp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKipp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKipp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKipp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKipp#rotTime"), 2)*1000;
        self.rotationPartKipp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKipp#touchRotLimit"), 10));
    end;



    self.isExpandedRight = false;
    self.isExpandedLeft = false;
	self.isExpandedKipp = false;
    self.rotationMaxRight = true;
    self.rotationMaxLeft = true;
	self.rotationMaxKipp = true;


end;

function Baletransporter:delete()
end;

function Baletransporter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Baletransporter:keyEvent(unicode, sym, modifier, isDown)

	 if isDown and sym == Input.KEY_j then
		self.rotationMaxRight = not self.rotationMaxRight;

		end;

        if isDown and sym == Input.KEY_n then
            self.rotationMaxLeft = not self.rotationMaxLeft;

		end;

		if isDown and sym == Input.KEY_k then
            self.rotationMaxKipp = not self.rotationMaxKipp;
            self.rotationMaxRight = not self.rotationMaxRight;
		end;

        if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
end;

function Baletransporter:update(dt)

    if self.isAttached then
        self.isExpandedRight = false;
        if self.rotationPartRight ~= nil then
            local x, y, z = getRotation(self.rotationPartRight.node);
            local minRot = self.rotationPartRight.minRot;
            local eps = self.rotationPartRight.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.isExpandedRight = true;
            end;
        end;

        self.isExpandedLeft = false;
        if self.rotationPartLeft ~= nil then
            local x, y, z = getRotation(self.rotationPartLeft.node);
            local minRot = self.rotationPartLeft.minRot;
            local eps = self.rotationPartLeft.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.isExpandedLeft = true;
            end;
        end;

		self.isExpandedKipp = false;
        if self.rotationPartKipp ~= nil then
            local x, y, z = getRotation(self.rotationPartKipp.node);
            local minRot = self.rotationPartKipp.minRot;
            local eps = self.rotationPartKipp.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.isExpandedKipp = true;
            end;
        end;

    end;


    if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;

    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;

	if self.rotationPartKipp ~= nil then
        local x, y, z = getRotation(self.rotationPartKipp.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKipp.maxRot, self.rotationPartKipp.minRot, 3, self.rotationPartKipp.rotTime, dt, not self.rotationMaxKipp);
        setRotation(self.rotationPartKipp.node, unpack(newRot));
    end;



end;

function Baletransporter:draw()

     if self.attacherVehicle then
		if not self.helpPanel then
			renderText(0.8335, 0.17, 0.02, "Taste 0: Info");

		else
			renderText(0.8335, 0.17, 0.02, "Taste 0: Info Abschalten");

		end;
		if self.helpPanel then
			renderText(0.7635, 0.40, 0.025, "- Ballentransporter Info -");
			renderText(0.7635, 0.375, 0.02, "Tasten j Klappe rechts");
            renderText(0.7635, 0.36, 0.02, "Taste n Klappe lings");
            renderText(0.7635, 0.345, 0.02, "Taste k Trailer kippen");
		end;
	end;

end;

function Baletransporter:onAttach()
end;

function Baletransporter:onDetach()

end;
