--
-- SipmaZ224
-- Specialization for New Holland BB 980 from Strawmod
--
-- @author  	  		Benjamin Biot (J&B Modding)
-- @version 	  		v1.0
-- @date  		  		21/11/10
-- @Sipma Z224 edit 	Burner

SipmaZ224 = {};

function SipmaZ224.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function SipmaZ224:load(xmlFile)
	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, SipmaZ224.getIsAreaActive);	
	self.setTransport= SpecializationUtil.callSpecializationsFunction("setTransport");	
	self.setPickup= SpecializationUtil.callSpecializationsFunction("setPickup");	
	-- Animations --
	self.PickupAnimation = getXMLString(xmlFile, "vehicle.Pickup#animationName");
	self.TransportAnimation = getXMLString(xmlFile, "vehicle.Transport#animationName");
	self.Transport = true;
	self.Pickup = false;
	-- Animated objects --
	self.slimak = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak#index"));
	self.slimak2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak2#index"));	
	self.walek = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek#index"));
	self.walek2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek2#index"));	
	-- Particles --
	self.PickUpParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.PickUpParticleSystems.PickUpParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.PickUpParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;

	self.charId = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.anim1#index"));
	self.clipIndex = getXMLString(xmlFile, "vehicle.anim1#animationClip");

	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.walek2#detachedPosition"));
    self.walek2DetachedPosition = {};
    self.walek2DetachedPosition.x = Utils.getNoNil(x, 0);
	self.walek2DetachedPosition.y = Utils.getNoNil(y, 0);
    self.walek2DetachedPosition.z = Utils.getNoNil(z, 0);
	
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.walek2#attachedPosition"));
    self.walek2AttachedPosition = {};
    self.walek2AttachedPosition.x = Utils.getNoNil(x, 0);
	self.walek2AttachedPosition.y = Utils.getNoNil(y, 0);
    self.walek2AttachedPosition.z = Utils.getNoNil(z, 0);

	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.walek2#detachedRotation"));
    self.walek2DetachedRotation = {};
    self.walek2DetachedRotation.x = Utils.degToRad(Utils.getNoNil(x, 0));
    self.walek2DetachedRotation.y = Utils.degToRad(Utils.getNoNil(y, 0));
    self.walek2DetachedRotation.z = Utils.degToRad(Utils.getNoNil(z, 0));

	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.walek2#attachedRotation"));
    self.walek2AttachedRotation = {};
    self.walek2AttachedRotation.x = Utils.degToRad(Utils.getNoNil(x, 0));
    self.walek2AttachedRotation.y = Utils.degToRad(Utils.getNoNil(y, 0));
    self.walek2AttachedRotation.z = Utils.degToRad(Utils.getNoNil(z, 0));	
end;

function SipmaZ224:delete()
	Utils.deleteParticleSystem(self.PickUpParticleSystems);
end;

function SipmaZ224:readStream(streamId, connection)
    self:setPickup(streamReadBool(streamId), true);
    self:setTransport(streamReadBool(streamId), true);
end;

function SipmaZ224:writeStream(streamId, connection)
    streamWriteBool(streamId, self.Pickup);
    streamWriteBool(streamId, self.Transport);
end;

function SipmaZ224:readUpdateStream(streamId, timestamp, connection)
end;

function SipmaZ224:writeUpdateStream(streamId, connection, dirtyMask)
end;

function SipmaZ224:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SipmaZ224:keyEvent(unicode, sym, modifier, isDown)
end;

function SipmaZ224:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self:setPickup(not self.Pickup);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setTransport(not self.Transport);
		end;
    end;
end;

function SipmaZ224:updateTick(dt)
	if self.attacherVehicle then
		setTranslation(self.walek2,self.walek2AttachedPosition.x,self.walek2AttachedPosition.y,self.walek2AttachedPosition.z);
		if not self.isTurnedOn then
			setRotation(self.walek2,self.walek2AttachedRotation.x,self.walek2AttachedRotation.y,self.walek2AttachedRotation.z);
		end;
	else
		setTranslation(self.walek2,self.walek2DetachedPosition.x,self.walek2DetachedPosition.y,self.walek2DetachedPosition.z);
		setRotation(self.walek2,self.walek2DetachedRotation.x,self.walek2DetachedRotation.y,self.walek2DetachedRotation.z);
	end;
	if self:getIsActive() then	
		if self.isTurnedOn --and not self.Transport then
			then
			-- slimak i podbierak --
			rotate(self.slimak, 0.4, 0, 0);
			rotate(self.slimak2, -0.4, 0, 0);
			
			-- WOM --
			rotate(self.walek, 0, 0, 1);
			rotate(self.walek2, 0, 0, 1);
			
			-- mlot anim --
			local charId = getAnimCharacterSet(self.charId);
			local clipIndex = getAnimClipIndex(charId, self.clipIndex);
			assignAnimTrackClip(charId, 0, clipIndex);
			setAnimTrackLoopState(charId, 0, false);
			setAnimTrackSpeedScale(charId, 0, 1.3);
			enableAnimTrack(charId, 0);

			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) then
				setAnimTrackTime(charId, 0, 0, true);
			end;
		else
			-- turn off mlot anim --
			disableAnimTrack(charId, 0);
		end;
		
		-- Activate particles --
		if self.isTurnedOn and not self.Transport and self.movingDirection ~= 0 and self.PickupDown then
			Utils.setEmittingState(self.PickUpParticleSystems, true);
		else
			Utils.setEmittingState(self.PickUpParticleSystems, false);
		end;
	end;	
end;

function SipmaZ224:draw()
	if self.Transport then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORT_OFF"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
    else
		if self.PickupDown then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LIFT"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORT_ON"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LOWER"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		end;
    end;	
end;

function SipmaZ224:setTransport(isTransport,noEventSend)
	SetTransportEvent.sendEvent(self, isTransport, noEventSend);
	-- Play transport animation --
	if isTransport then
		if self.TransportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransportAnimation, -1, nil, true);
			self.Transport = true;
		end;
	else
		if self.TransportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransportAnimation, 1, nil, true);
			self.Transport = false;
		end;
	end;
end;

function SipmaZ224:setPickup(isPickupState,noEventSend)
	SetPickupEvent.sendEvent(self, isPickupState, noEventSend);
	-- Play pickup animation --
	self.PickupDown = isPickupState;
	if self.PickupDown then
		if self.PickupAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PickupAnimation, -1, nil, true);
			self.Pickup = true;
		end;
	else
		if self.PickupAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PickupAnimation, 1, nil, true);
			self.Pickup = false;
		end;
	end;	
end;

function SipmaZ224:onDetach()
	if self.PickUpParticleSystems ~= nil then
		Utils.setEmittingState(self.PickUpParticleSystems, false);
	end;
end;

function SipmaZ224:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
			return superFunc(self, area) and self.PickupDown;
    end;
	return self.PickupDown;	
end;