--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
   local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/careerSavegame.xml";
        self.saveXMLFile1 = dir .. "/barley_growthState.xml";
        self.saveXMLFile2 = dir .. "/grass_growthState.xml";
        self.saveXMLFile3 = dir .. "/maize_growthState.xml";
        self.saveXMLFile4 = dir .. "/manure_growthState.xml";
        self.saveXMLFile5 = dir .. "/paillage_growthState.xml";
        self.saveXMLFile6 = dir .. "/rape_growthState.xml";
        self.saveXMLFile7 = dir .. "/sugarbeet_growthState.xml";
        self.saveXMLFile8 = dir .. "/vehicles.xml";
        self.saveXMLFile9 = dir .. "/wheat_growthState.xml";

	if g_currentMission.missionStats.playTime == 0 then
		os.remove(self.saveXMLFile);
                os.remove(self.saveXMLFile1);
                os.remove(self.saveXMLFile2);
                os.remove(self.saveXMLFile3);
                os.remove(self.saveXMLFile4);
                os.remove(self.saveXMLFile5);
                os.remove(self.saveXMLFile6);
                os.remove(self.saveXMLFile7);
                os.remove(self.saveXMLFile8);
                os.remove(self.saveXMLFile9);
        end;


    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
    
     AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
  
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();   
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;

