SetTraceurArriereEvent = {};
SetTraceurArriereEvent_mt = Class(SetTraceurArriereEvent, Event);

InitEventClass(SetTraceurArriereEvent, "SetTraceurArriereEvent");

function SetTraceurArriereEvent:emptyNew()
    local self = Event:new(SetTraceurArriereEvent_mt);
    self.className="SetTraceurArriereEvent";
    return self;
end;

function SetTraceurArriereEvent:new(vehicle, traceurArriere)
    local self = SetTraceurArriereEvent:emptyNew()
    self.vehicle = vehicle;
	self.traceurArriere = traceurArriere;
    return self;
end;

function SetTraceurArriereEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.traceurArriere = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTraceurArriereEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.traceurArriere);
end;

function SetTraceurArriereEvent:run(connection)   
	self.vehicle:setTraceurArriere(self.traceurArriere, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTraceurArriereEvent:new(vehicle, self.traceurArriere), nil, connection, self.vehicle);
    end;
end;

function SetTraceurArriereEvent.sendEvent(vehicle, traceurArriere, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTraceurArriereEvent:new(vehicle, traceurArriere), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTraceurArriereEvent:new(vehicle, traceurArriere));
		end;
	end;
end;