--
-- Name: F_35
-- Description: Specialization for F_35
-- Version: 1.0
-- Author: Fendt413
-- Date: 12/06/2011
--
-- 

F_35 = {}

source("dataS/scripts/vehicles/specializations/CultivatorAreaEvent.lua");
source("dataS/scripts/vehicles/specializations/PloughAreaEvent.lua");

function F_35.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function F_35:load(xmlFile)
	self.setTraceurDroit = SpecializationUtil.callSpecializationsFunction("setTraceurDroit");		
	self.setTraceurGauche = SpecializationUtil.callSpecializationsFunction("setTraceurGauche");		
	self.setTraceurArriere = SpecializationUtil.callSpecializationsFunction("setTraceurArriere");		

	self.TraceurDroitAnimation = getXMLString(xmlFile, "vehicle.TraceurDroit#animationName");
	self.TraceurGaucheAnimation = getXMLString(xmlFile, "vehicle.TraceurGauche#animationName");
	self.TraceurArriereAnimation = getXMLString(xmlFile, "vehicle.TraceurArriere#animationName");
	self.traceurDroit = false;
	self.traceurGauche = false;
	self.traceurArriere = false;
	
	-- Cutting areas --
	local numTraceurCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.traceurCuttingAreas#count"), 0);
	self.traceurCuttingAreas = {}
	for i=1, numTraceurCuttingAreas do
		self.traceurCuttingAreas[i] = {};
		local areanamei = string.format("vehicle.traceurCuttingAreas.traceurCuttingArea%d", i);
		self.traceurCuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.traceurCuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.traceurCuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
 	local numTraceurCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.traceurCuttingAreas#count"), 0);
	for i=1, numTraceurCuttingAreas do
		local areanamei = string.format("vehicle.traceurCuttingAreas.traceurCuttingArea%d", i);
		self.traceurCuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.traceurCuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	end;

	local numTraceurGCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.traceurGCuttingAreas#count"), 0);
	self.traceurGCuttingAreas = {}
	for i=1, numTraceurGCuttingAreas do
		self.traceurGCuttingAreas[i] = {};
		local areanamei = string.format("vehicle.traceurGCuttingAreas.traceurGCuttingArea%d", i);
		self.traceurGCuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.traceurGCuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.traceurGCuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
 	local numTraceurGCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.traceurGCuttingAreas#count"), 0);
	for i=1, numTraceurGCuttingAreas do
		local areanamei = string.format("vehicle.traceurGCuttingAreas.traceurGCuttingArea%d", i);
		self.traceurGCuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.traceurGCuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	end;

	local numTraceurDCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.traceurDCuttingAreas#count"), 0);
	self.traceurDCuttingAreas = {}
	for i=1, numTraceurDCuttingAreas do
		self.traceurDCuttingAreas[i] = {};
		local areanamei = string.format("vehicle.traceurDCuttingAreas.traceurDCuttingArea%d", i);
		self.traceurDCuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.traceurDCuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.traceurDCuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
 	local numTraceurDCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.traceurDCuttingAreas#count"), 0);
	for i=1, numTraceurDCuttingAreas do
		local areanamei = string.format("vehicle.traceurDCuttingAreas.traceurDCuttingArea%d", i);
		self.traceurDCuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.traceurDCuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	end;
end;

function F_35:delete()
end;

function F_35:readStream(streamId, connection)
   self:setTraceurDroit(streamReadBool(streamId), true);
   self:setTraceurGauche(streamReadBool(streamId), true);
   self:setTraceurArriere(streamReadBool(streamId), true);
end;

function F_35:writeStream(streamId, connection)
	streamWriteBool(streamId, self.traceurDroit);
	streamWriteBool(streamId, self.traceurGauche);
	streamWriteBool(streamId, self.traceurArriere);
end;

function F_35:readUpdateStream(streamId, timestamp, connection)
end;
function F_35:writeUpdateStream(streamId, connection, dirtyMask)
end;
function F_35:mouseEvent(posX, posY, isDown, isUp, button)
end;
function F_35:keyEvent(unicode, sym, modifier, isDown)
end;

function F_35:update(dt)
	if self:getIsActiveForInput() then
		if self.foldMoveDirection < 0.1 or (self.foldMoveDirection ~= 0 and self.foldAnimTime < 0.1) then
			if InputBinding.hasEvent(InputBinding.TRACEUR_DROIT) then
				self:setTraceurDroit(not self.traceurDroit);
			end;	
			if InputBinding.hasEvent(InputBinding.TRACEUR_GAUCHE) then
				self:setTraceurGauche(not self.traceurGauche);
			end;
			if InputBinding.hasEvent(InputBinding.TRACEUR_ARRIERE) then
				self:setTraceurArriere(not self.traceurArriere);
			end;
			if self.traceurGauche ~= self.traceurDroit then
				if InputBinding.hasEvent(InputBinding.CHANGE) then		
					self:setTraceurDroit(not self.traceurDroit);			
					self:setTraceurGauche(not self.traceurGauche);				
				end;
			end;
		else
			self:setTraceurDroit(false);
			self:setTraceurGauche(false);
			self:setTraceurArriere(false);
		end;
	end;
end;

function F_35:updateTick(dt)
	if self:getIsActive() then
		if self.isServer then
			-- Cutting areas --
			if self.traceurArriere and self:isLowered(false) then
				local cuttingAreasSend = {};
				
				for k, traceurCuttingArea in pairs(self.traceurCuttingAreas) do
					if self:getIsAreaActive(traceurCuttingArea) then
						local x,y,z = getWorldTranslation(traceurCuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(traceurCuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(traceurCuttingArea.height);
						local cultivator = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x, z, x1, z1, x2, z2);
						table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
					end;
				end;
				
				if table.getn(cuttingAreasSend) > 0 then
					local limitToField = true;
					if cultivator ~= 0 then
						PloughAreaEvent.runLocally(cuttingAreasSend, limitToField);
						g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField));
					else
						CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
						g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField));
					end;
				end;					
			end;
			if self.traceurGauche and self:isLowered(false) then
				local cuttingAreasSend = {};
				
				for k, traceurGCuttingArea in pairs(self.traceurGCuttingAreas) do
					if self:getIsAreaActive(traceurGCuttingArea) then
						local x,y,z = getWorldTranslation(traceurGCuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(traceurGCuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(traceurGCuttingArea.height);
						local cultivator = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x, z, x1, z1, x2, z2);
						table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
					end;
				end;
				
				if table.getn(cuttingAreasSend) > 0 then
					local limitToField = true;
					if cultivator ~= 0 then
						PloughAreaEvent.runLocally(cuttingAreasSend, limitToField);
						g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField));
					else
						CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
						g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField));
					end;
				end;					
			end;	
			if self.traceurDroit and self:isLowered(false) then
				local cuttingAreasSend = {};
				
				for k, traceurDCuttingArea in pairs(self.traceurDCuttingAreas) do
					if self:getIsAreaActive(traceurDCuttingArea) then
						local x,y,z = getWorldTranslation(traceurDCuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(traceurDCuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(traceurDCuttingArea.height);
						local cultivator = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x, z, x1, z1, x2, z2);
						table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
					end;
				end;
				
				if table.getn(cuttingAreasSend) > 0 then
					local limitToField = true;
					if cultivator ~= 0 then
						PloughAreaEvent.runLocally(cuttingAreasSend, limitToField);
						g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField));
					else
						CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
						g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField));
					end;
				end;					
			end;
		end;
	end;
end;

function F_35:draw()
	if self.traceurDroit then 
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_DROIT_DOWN"), self.typeDesc), InputBinding.TRACEUR_DROIT);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_DROIT_UP"), self.typeDesc), InputBinding.TRACEUR_DROIT);
	end;
	if self.traceurGauche then 
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_GAUCHE_DOWN"), self.typeDesc), InputBinding.TRACEUR_GAUCHE);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_GAUCHE_UP"), self.typeDesc), InputBinding.TRACEUR_GAUCHE);
	end;
	if self.traceurGauche then 
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_ARRIERE_DOWN"), self.typeDesc), InputBinding.TRACEUR_ARRIERE);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_ARRIERE_UP"), self.typeDesc), InputBinding.TRACEUR_ARRIERE);
	end;

end;
function F_35:setTraceurDroit(traceurDroit,noEventSend)
	SetTraceurDroitEvent.sendEvent(self, traceurDroit, noEventSend);
	if not traceurDroit then
		if self.TraceurDroitAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurDroitAnimation, -1, nil, true);
			self.traceurDroit = false;
		end;
	else
		if self.TraceurDroitAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurDroitAnimation, 1, nil, true);
			self.traceurDroit = true;
		end;
	end;
end;

function F_35:setTraceurGauche(traceurGauche,noEventSend)
	SetTraceurGaucheEvent.sendEvent(self, traceurGauche, noEventSend);
	if not traceurGauche then
		if self.TraceurGaucheAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurGaucheAnimation, -1, nil, true);
			self.traceurGauche = false;
		end;
	else
		if self.TraceurGaucheAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurGaucheAnimation, 1, nil, true);
			self.traceurGauche = true;
		end;
	end;
end;

function F_35:setTraceurArriere(traceurArriere,noEventSend)
	SetTraceurArriereEvent.sendEvent(self, traceurArriere, noEventSend);
	if not traceurArriere then
		if self.TraceurArriereAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurArriereAnimation, -1, nil, true);
			self.traceurArriere = false;
		end;
	else
		if self.TraceurArriereAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurArriereAnimation, 1, nil, true);
			self.traceurArriere = true;
		end;
	end;
end;