--
-- LockSteeringaxles
-- Rotate seperatlyRolls
--
-- @Author  FIAT80-90DT
-- @date  29.08.2011
--
-- VISIT Modding-Stage -- www.modding-stage.com -- 

LockSteeringaxles = {};

function LockSteeringaxles.prerequisitesPresent(specializations)
    return true;
end;

function LockSteeringaxles:load(xmlFile)
   for i=1, table.getn(self.wheels) do 
		self.wheels[i].backupScale = self.wheels[i].steeringAxleScale
		self.wheels[i].backupMax = self.wheels[i].steeringAxleRotMax
		self.wheels[i].backupMin = self.wheels[i].steeringAxleRotMin
    end;	
end;

function LockSteeringaxles:delete()
end;

function LockSteeringaxles:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LockSteeringaxles:keyEvent(unicode, sym, modifier, isDown)
end;

function LockSteeringaxles:update(dt)
	if InputBinding.hasEvent(InputBinding.LOCKSTEERING_FUCHS) then
		self.lock = not self.lock
		LockSteeringaxlesEvent.sendEvent(self, self.lock);
	end;
end;

function LockSteeringaxles:updateTick(dt)
	for i=1, table.getn(self.wheels) do 
		local wheel = self.wheels[i];
		if self.lock then 
			wheel.steeringAxleScale = 0;
			wheel.steeringAxleRotMax = 0;
			wheel.steeringAxleRotMin = 0;
		else
			wheel.steeringAxleScale = wheel.backupScale;
			wheel.steeringAxleRotMax = wheel.backupMax;
			wheel.steeringAxleRotMin = wheel.backupMin;
		end;
	end;	
end;

function LockSteeringaxles:draw()
	if self.lock then
		g_currentMission:addHelpButtonText("Lenkachse entsperren", InputBinding.LOCKSTEERING_FUCHS);
	else
		g_currentMission:addHelpButtonText("Lenkachse sperren", InputBinding.LOCKSTEERING_FUCHS);
	end;
end;

											--####EVENT####-- 
											
--@author	-	FIAT80-90DT																
--@date		-	28.08.11											

LockSteeringaxlesEvent = {};
LockSteeringaxlesEvent_mt = Class(LockSteeringaxlesEvent, Event);

InitEventClass(LockSteeringaxlesEvent, "LockSteeringaxlesEvent");

function LockSteeringaxlesEvent:emptyNew()
    local self = Event:new(LockSteeringaxlesEvent_mt);
    self.className="LockSteeringaxlesEvent";
    return self;
end;

function LockSteeringaxlesEvent:new(object, lock)
    local self = LockSteeringaxlesEvent:emptyNew()
    self.object = object;
	self.lock = lock;
    return self;
end;

function LockSteeringaxlesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	
	self.lock = streamReadBool(streamId);
	self.object.lock = self.lock;
	if not connection:getIsServer() then
        g_server:broadcastEvent(LockSteeringaxlesEvent:new(self.object, self.lock), nil, connection, self.object);
    end;
end;

function LockSteeringaxlesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.lock);
end;


function LockSteeringaxlesEvent.sendEvent(vehicle, lock)
	if g_server ~= nil then
		g_server:broadcastEvent(LockSteeringaxlesEvent:new(vehicle, lock), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(LockSteeringaxlesEvent:new(vehicle, lock));
	end;
end;