﻿-- ##########################################
-- #	MapSoundTrigger						#
-- #	version: 1.0						#
-- #	Date: 28.05.2012					#
-- #	author: Webby (FieldStar-Modding)	#
-- # 	Keine Veränderung ohne				# 
-- # 	meine Erlaubnis!					#
-- # 	No modification without				# 
-- # 	my permission!						#
-- #										#
-- #	THX 2:								#
-- #										#
-- #	modelleicher						#
-- #	Bluebaby210							#
-- #										#
-- #	4 helping me out 					#
-- #	with this Script					#
-- #										#
-- ########################################## 	

MapSoundTrigger = {};

local MapSoundTrigger_mt = Class(MapSoundTrigger, Object);

function onCreate(self, id)
    local instance = MapSoundTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(id);
    instance:register(true);
	print("MapSoundTrigger v1.0 by Webby loaded!")
end;

function MapSoundTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, MapSoundTrigger_mt);
    self.className = "MapSoundTrigger";
    return self;
end;

function MapSoundTrigger:load(name)
    
    self.triggerId = name;
	addTrigger(name, "triggerCallback", self);
	
	local mapSoundTrigger = Utils.getNoNil(getUserAttribute(name, "SoundFile"), "MapSoundTrigger/MapSoundTrigger_bing.wav");
		if mapSoundTrigger ~= nil and string.len(mapSoundTrigger) >= 1 then
			self.soundFile = g_modsDirectory.."/"..mapSoundTrigger;
			self.soundVolume = Utils.getNoNil(getUserAttribute(name, "SoundVolume"), 1.0);
			self.mapSound = createSample("MSTrigger");
			loadSample(self.mapSound, self.soundFile, false);
			--print("Sound geladen");
			self.playing = false;
		end;	
end;

function MapSoundTrigger:delete()
    removeTrigger(self.triggerId);
end;

function MapSoundTrigger:update(dt)	

end;

function MapSoundTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) or (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
			if self.playing == false then
			playSample(self.mapSound,1,self.soundVolume,0);
			--print("Sound gespielt");
			self.playing = true;
			end;
		end;
	end;
	if onLeave then
		if self.playing == true then
			self.playing = false;
		end;
	end;
end;