--
-- Sipma Z224
-- LS2011: Burner
--

Sipma = {};

function Sipma.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Sipma:load(xmlFile)
    self.isTurned = false;
	
	local rotationPartNodezaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zaczep#index"));
    if rotationPartNodezaczep ~= nil then
        self.rotationPartzaczep = {};
        self.rotationPartzaczep.node = rotationPartNodezaczep;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartzaczep#minRot"));
        self.rotationPartzaczep.minRot = {};
        self.rotationPartzaczep.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartzaczep.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartzaczep.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.zaczep#maxRot"));
        self.rotationPartzaczep.maxRot = {};
        self.rotationPartzaczep.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartzaczep.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartzaczep.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartzaczep.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.zaczep#rotTime"), 2)*1000;
        self.rotationPartzaczep.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.zaczep#touchRotLimit"), 10));
    end;	
	
	local rotationPartNodeklapa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa#index"));
    if rotationPartNodeklapa ~= nil then
        self.rotationPartklapa = {};
        self.rotationPartklapa.node = rotationPartNodeklapa;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklapa#minRot"));
        self.rotationPartklapa.minRot = {};
        self.rotationPartklapa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klapa#maxRot"));
        self.rotationPartklapa.maxRot = {};
        self.rotationPartklapa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklapa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa#rotTime"), 2)*1000;
        self.rotationPartklapa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa#touchRotLimit"), 10));
    end;
	
	local rotationPartNodepodbierak = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.podbierak#index"));
    if rotationPartNodepodbierak ~= nil then
        self.rotationPartpodbierak = {};
        self.rotationPartpodbierak.node = rotationPartNodepodbierak;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartpodbierak#minRot"));
        self.rotationPartpodbierak.minRot = {};
        self.rotationPartpodbierak.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpodbierak.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpodbierak.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.podbierak#maxRot"));
        self.rotationPartpodbierak.maxRot = {};
        self.rotationPartpodbierak.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpodbierak.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpodbierak.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpodbierak.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.podbierak#rotTime"), 2)*1000;
        self.rotationPartpodbierak.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.podbierak#touchRotLimit"), 10));
    end;
	
	local rotationPartNodemlot = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mlot#index"));
    if rotationPartNodemlot ~= nil then
        self.rotationPartmlot = {};
        self.rotationPartmlot.node = rotationPartNodemlot;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartmlot#minRot"));
        self.rotationPartmlot.minRot = {};
        self.rotationPartmlot.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmlot.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmlot.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.mlot#maxRot"));
        self.rotationPartmlot.maxRot = {};
        self.rotationPartmlot.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmlot.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmlot.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmlot.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.mlot#rotTime"), 2)*1000;
        self.rotationPartmlot.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.mlot#touchRotLimit"), 10));
    end;
 
	local rotationPartNodemlot2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mlot2#index"));
    if rotationPartNodemlot2 ~= nil then
        self.rotationPartmlot2 = {};
        self.rotationPartmlot2.node = rotationPartNodemlot2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartmlot2#minRot"));
        self.rotationPartmlot2.minRot = {};
        self.rotationPartmlot2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmlot2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmlot2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.mlot2#maxRot"));
        self.rotationPartmlot2.maxRot = {};
        self.rotationPartmlot2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmlot2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmlot2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmlot2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.mlot2#rotTime"), 2)*1000;
        self.rotationPartmlot2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.mlot2#touchRotLimit"), 10));
    end;

	self.slimak = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak#index"));
	self.slimak2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak2#index"));	
	
	self.walek = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek#index"));
	self.walek2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek2#index"));	

	self.mlot = false;
	self.test = 300;	
end;

function Sipma:delete()
end;

function Sipma:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Sipma:keyEvent(unicode, sym, modifier, isDown)
end;

function Sipma:update(dt)
	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self.isTurned = not self.isTurned;
			self.mlot = not self.mlot;
			self.rotationMaxpodbierak = not self.rotationMaxpodbierak;
		end;
	
		if self.isTurned then
			rotate(self.slimak, 0.4, 0, 0);
			rotate(self.slimak2, -0.4, 0, 0);
			rotate(self.walek, 0, 0, 0.8);
			rotate(self.walek2, 0, 0, 0.8);
		end;
	end;		
	
	if self.rotationPartzaczep ~= nil then
		local x, y, z = getRotation(self.rotationPartzaczep.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartzaczep.maxRot, self.rotationPartzaczep.minRot, 3, self.rotationPartzaczep.rotTime, dt, not self.rotationMaxzaczep);
		setRotation(self.rotationPartzaczep.node, unpack(newRot));
	end;
	
	if self.rotationPartpodbierak ~= nil then
		local x, y, z = getRotation(self.rotationPartpodbierak.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpodbierak.maxRot, self.rotationPartpodbierak.minRot, 3, self.rotationPartpodbierak.rotTime, dt, not self.rotationMaxpodbierak);
		setRotation(self.rotationPartpodbierak.node, unpack(newRot));
	end	
	
	if self.mlot == true then
		self.test = self.test - dt;
		if self.test < 0 then
			self.rotationMaxmlot = not self.rotationMaxmlot;
			self.rotationMaxmlot2 = not self.rotationMaxmlot2;
			self.test = 300;
		end;
	end;
	
	if self.rotationPartmlot ~= nil then
		local x, y, z = getRotation(self.rotationPartmlot.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmlot.maxRot, self.rotationPartmlot.minRot, 3, self.rotationPartmlot.rotTime, dt, not self.rotationMaxmlot);
		setRotation(self.rotationPartmlot.node, unpack(newRot));
	end;
	if self.rotationPartmlot2 ~= nil then
		local x, y, z = getRotation(self.rotationPartmlot2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmlot2.maxRot, self.rotationPartmlot2.minRot, 3, self.rotationPartmlot2.rotTime, dt, not self.rotationMaxmlot2);
		setRotation(self.rotationPartmlot2.node, unpack(newRot));
	end;
end;

function Sipma:draw()
end;

function Sipma:onDetach()
    self.isTurned = false;
	self.mlot = false;
	self.rotationMaxpodbierak = false;
end;

function Sipma:onLeave()
    self.isTurned = false;
	self.mlot = false;
	self.rotationMaxpodbierak = false;
end;

function Sipma:onDeactivate()
    self.isTurned = false;
	self.mlot = false;
	self.rotationMaxpodbierak = false;
end;