

Schiebetuer = {};

function Schiebetuer.prerequisitesPresent(specializations)
     return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Schiebetuer:load(xmlFile)

    	local translationA2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationA2#index"));
    if translationA2Node ~= nil then
        self.translationA2 = {};
        self.translationA2.node = translationA2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationA2#minTrans"));
        self.translationA2.minTrans = {};
        self.translationA2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationA2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationA2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationA2#maxTrans"));
        self.translationA2.maxTrans = {};
        self.translationA2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationA2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationA2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationA2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationA2#transTime"), 2)*1000;
        self.translationA2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationA2#touchTransLimit"), 10);
    end;

end;	
      
function Schiebetuer:delete()
end;

function Schiebetuer:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Schiebetuer:keyEvent(unicode, sym, modifier, isDown)
	if self.isMotorStarted then
	
	if sym == Input.KEY_KP_7 then
		self.translationA2Max = isDown;
	end;
	if sym == Input.KEY_KP_8 then
		self.translationA2Min = isDown;
	end;
      end;
end;

function Schiebetuer:update(dt)
				
if self.inrange then
	if InputBinding.hasEvent (InputBinding.DOOR) then
		self.translationA2Max = not self.translationA2Max;
		else
		self.translationA2Min = not self.translationA2Min;
	end;
end;

	if self.inrange then
		if self.translationA2Max then
			g_currentMission:addHelpButtonText(g_i18n:getText("Schiebetuer_6"), InputBinding.DOOR);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Schiebetuer_7"), InputBinding.DOOR);
		end;
	end;	

	local doTranslate = self.translationA2Max or self.translationA2Min 
	if self.translationA2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationA2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationA2.maxTrans, self.translationA2.minTrans, 3, self.translationA2.transTime, dt, not self.translationA2Max); 
		setTranslation(self.translationA2.node, unpack(newTrans));
	end; 		

end;

function Schiebetuer:updateTick(dt)

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;

end;

function Schiebetuer:draw()

     if self.isMotorStarted then
        g_currentMission:addExtraPrintText("NUM 7/8 Schiebetuer");
	g_currentMission:addExtraPrintText("");
	end;

end;

function Schiebetuer:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

