--
-- BuyableCountyWeightsAttacher
-- Specialization for BuyableCountyWeightsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
--

BuyableCountyWeightsAttacher = {};

function BuyableCountyWeightsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableCountyWeightsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableCountyWeights = {};
	self.buyableCountyWeights.checkCountyString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableCountyWeights.countyWeights = nil;
	self.buyableCountyWeights.countyWeightsInRange = nil;	
end;

function BuyableCountyWeightsAttacher:delete()
	if self.buyableCountyWeights.countyWeights ~= nil then
		self.buyableCountyWeights.countyWeights:disassembleCountyWheights(true);
	end;
end;

function BuyableCountyWeightsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableCountyWeightsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableCountyWeightsAttacher:update(dt)

	if self:getIsActive() then
		if self.movingDirection == 0 then
			local DOEweights = self.buyableCountyWeights;
			if DOEweights.countyWeightsInRange ~= nil then
				if self:getIsActiveForInput() then
					if InputBinding.hasEvent(InputBinding.FORDSON_EXTRA_ATTACH) then
						if DOEweights.countyWeights == nil then
							DOEweights.countyWeightsInRange:assembleCountyWheights(self);
						else
							if DOEweights.countyWeightsInRange.countyWeightsUser == self then
								DOEweights.countyWeightsInRange:disassembleCountyWheights();
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableCountyWeightsAttacher:draw()
	local DOEweights = self.buyableCountyWeights;
	if DOEweights.countyWeightsInRange ~= nil then
		if self.movingDirection == 0 then
			if DOEweights.countyWeights ~= nil then
				if DOEweights.countyWeightsInRange.countyWeightsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("Disassemble_Extra"), InputBinding.FORDSON_EXTRA_ATTACH);
				end;
			else
				if DOEweights.countyWeightsInRange.countyWeightsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("Assemble_Extra"), InputBinding.FORDSON_EXTRA_ATTACH);
				end;
			end;
		end;
	end;
end;

function BuyableCountyWeightsAttacher:onAssembling(buyableCountyWeights)
	self.buyableCountyWeights.countyWeights = buyableCountyWeights;
end;

function BuyableCountyWeightsAttacher:onDisassembling()
	self.buyableCountyWeights.countyWeights = nil;
end;
