--
-- BuyableDoeWeightsAttacher
-- Specialization for BuyableDoeWeightsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
--

BuyableDoeWeightsAttacher = {};

function BuyableDoeWeightsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableDoeWeightsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableDoeWeights = {};
	self.buyableDoeWeights.checkDoeString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableDoeWeights.doeWeights = nil;
	self.buyableDoeWeights.doeWeightsInRange = nil;	
end;

function BuyableDoeWeightsAttacher:delete()
	if self.buyableDoeWeights.doeWeights ~= nil then
		self.buyableDoeWeights.doeWeights:disassembleDoeWheights(true);
	end;
end;

function BuyableDoeWeightsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableDoeWeightsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableDoeWeightsAttacher:update(dt)

	if self:getIsActive() then
		if self.movingDirection == 0 then
			local DOEweights = self.buyableDoeWeights;
			if DOEweights.doeWeightsInRange ~= nil then
				if self:getIsActiveForInput() then
					if InputBinding.hasEvent(InputBinding.FORDSON_EXTRA_ATTACH) then
						if DOEweights.doeWeights == nil then
							DOEweights.doeWeightsInRange:assembleDoeWheights(self);
						else
							if DOEweights.doeWeightsInRange.doeWeightsUser == self then
								DOEweights.doeWeightsInRange:disassembleDoeWheights();
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableDoeWeightsAttacher:draw()
	local DOEweights = self.buyableDoeWeights;
	if DOEweights.doeWeightsInRange ~= nil then
		if self.movingDirection == 0 then
			if DOEweights.doeWeights ~= nil then
				if DOEweights.doeWeightsInRange.doeWeightsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("Disassemble_Extra"), InputBinding.FORDSON_EXTRA_ATTACH);
				end;
			else
				if DOEweights.doeWeightsInRange.doeWeightsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("Assemble_Extra"), InputBinding.FORDSON_EXTRA_ATTACH);
				end;
			end;
		end;
	end;
end;

function BuyableDoeWeightsAttacher:onAssembling(buyableDoeWeights)
	self.buyableDoeWeights.doeWeights = buyableDoeWeights;
end;

function BuyableDoeWeightsAttacher:onDisassembling()
	self.buyableDoeWeights.doeWeights = nil;
end;
