--
-- BuyableFordsonWeightsAttacher
-- Specialization for BuyableFordsonWeightsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
--

BuyableFordsonWeightsAttacher = {};

function BuyableFordsonWeightsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableFordsonWeightsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableFordsonWeights = {};
	self.buyableFordsonWeights.checkFordsonString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableFordsonWeights.fordsonWeights = nil;
	self.buyableFordsonWeights.fordsonWeightsInRange = nil;	
end;

function BuyableFordsonWeightsAttacher:delete()
	if self.buyableFordsonWeights.fordsonWeights ~= nil then
		self.buyableFordsonWeights.fordsonWeights:disassembleFordsonWheights(true);
	end;
end;

function BuyableFordsonWeightsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableFordsonWeightsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableFordsonWeightsAttacher:update(dt)

	if self:getIsActive() then
		if self.movingDirection == 0 then
			local DOEweights = self.buyableFordsonWeights;
			if DOEweights.fordsonWeightsInRange ~= nil then
				if self:getIsActiveForInput() then
					if InputBinding.hasEvent(InputBinding.FORDSON_EXTRA_ATTACH) then
						if DOEweights.fordsonWeights == nil then
							DOEweights.fordsonWeightsInRange:assembleFordsonWheights(self);
						else
							if DOEweights.fordsonWeightsInRange.fordsonWeightsUser == self then
								DOEweights.fordsonWeightsInRange:disassembleFordsonWheights();
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableFordsonWeightsAttacher:draw()
	local DOEweights = self.buyableFordsonWeights;
	if DOEweights.fordsonWeightsInRange ~= nil then
		if self.movingDirection == 0 then
			if DOEweights.fordsonWeights ~= nil then
				if DOEweights.fordsonWeightsInRange.fordsonWeightsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("Disassemble_Extra"), InputBinding.FORDSON_EXTRA_ATTACH);
				end;
			else
				if DOEweights.fordsonWeightsInRange.fordsonWeightsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("Assemble_Extra"), InputBinding.FORDSON_EXTRA_ATTACH);
				end;
			end;
		end;
	end;
end;

function BuyableFordsonWeightsAttacher:onAssembling(buyableFordsonWeights)
	self.buyableFordsonWeights.fordsonWeights = buyableFordsonWeights;
end;

function BuyableFordsonWeightsAttacher:onDisassembling()
	self.buyableFordsonWeights.fordsonWeights = nil;
end;
