SetVidroTraRotationEvent = {};
SetVidroTraRotationEvent_mt = Class(SetVidroTraRotationEvent, Event);
  
InitEventClass(SetVidroTraRotationEvent, "SetVidroTraRotationEvent");
  
function SetVidroTraRotationEvent:emptyNew()
      local self = Event:new(SetVidroTraRotationEvent_mt);
      self.className="SetVidroTraRotationEvent";
      return self;
 end;

function SetVidroTraRotationEvent:new(object, rotationMaxPortaDta)
      local self = SetVidroTraRotationEvent:emptyNew()
      self.object = object;
      self.rotationMaxVidroTra = rotationMaxVidroTra;
      return self;
end;
 
function SetVidroTraRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMaxVidroTra = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetVidroTraRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMaxVidroTra);
end;
 
function SetVidroTraRotationEvent:run(connection)
      self.object:setRotationMaxVidroTra(self.rotationMaxVidroTra, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetVidroTraRotationEvent:new(self.object, self.rotationMaxVidroTra), nil, connection, self.object);
      end;
end;