--
-- 
-- Specialization for workLights.
--
--

BackhoeWLights = {};

function BackhoeWLights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BackhoeWLights:load(xmlFile)
	local numwLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wLights#count"), 0);
    self.wLights = {};
    for i=1, numwLights do
        local worklightnamei = string.format("vehicle.wLights.workLight%d", i);
        self.wLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.wLights[i], false);
    end;
	self.wLightsActive = false;
end;

function BackhoeWLights:delete()
	for k, worklight in pairs(self.wLights) do
		setVisibility(worklight, false);
	end;
	self.wLightsActive = false;
end;

function BackhoeWLights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BackhoeWLights:keyEvent(unicode, sym, modifier, isDown)
end;

function BackhoeWLights:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.Backhoe_WORKLIGHTS) then
			self.wLightsActive = not self.wLightsActive;
		end;
	
		for k, worklight in pairs(self.wLights) do
			setVisibility(worklight, self.wLightsActive);
		end;
	end;
end;

function BackhoeWLights:onLeave()
	for k, worklight in pairs(self.wLights) do
		setVisibility(worklight, false);
	end;
	self.wLightsActive = false;
end;

function BackhoeWLights:draw()
         if self.isEntered and self.showHUDInfo then
            g_currentMission:addExtraPrintText(string.format("Lights: %s,Key_F,Key_Home", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_WORKLIGHTS)));
         end;
end;

