SetWeightEvent = {};
SetWeightEvent_mt = Class(SetWeightEvent, Event);

InitEventClass(SetWeightEvent, "SetWeightEvent");

function SetWeightEvent:emptyNew()
      local self = Event:new(SetWeightEvent_mt);
      self.className="SetWeightEvent";
      return self;
end;

function SetWeightEvent:new(object, active)
      local self = SetWeightEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;

function SetWeightEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
 end;

function SetWeightEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;

function SetWeightEvent:run(connection)
      self.object:setWeightVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetWeightEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;