-- MapFruitChangeOutputTrigger by raffnix
-- @date: 19.12.2011
-- @author: rafftnix
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!
-- history: 
--  		v1.0 (April 2012)

-- Output Trigger
function onCreateOutputTrigger(self, id)
	local trigger = MapFruitChangeOutputTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
	table.insert(MFCT_HelpClass.MapFruitChangeOutputTriggers, trigger);
end;

MapFruitChangeOutputTrigger = {}
local MapFruitChangeOutputTrigger_mt = Class(MapFruitChangeOutputTrigger, Object);
	
function MapFruitChangeOutputTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, MapFruitChangeOutputTrigger_mt);
    self.className = "MapFruitChangeOutputTrigger";
    return self;
end;

function MapFruitChangeOutputTrigger:load(id)
	self.outputs = {}
	self.trailers = {}
	self.planes = {}
	self.objectOutputTrigger = {}

	local parent = getParent(id);
	self.outputSelection = 1;
	self.triggerId = id;
	self.inputIndex = getUserAttribute(id, "inputTriggerNumber"); 
	assert(self.inputIndex, "There is a MapFruitChangeOutputTrigger without a inputTriggerNumber");
	self.fillSpeed = Utils.getNoNil(getUserAttribute(id, "fillSpeed"), 25);
	self.needsActivation = Utils.getNoNil(getUserAttribute(id, "needsActivation"), false);
	
	self.objectOutput = false;
	self.firstRun = true;
	
	if g_server ~= nil then
		-- object output
		local objectFile = getUserAttribute(id, "3DObjectFile");
		local litersForObject = getUserAttribute(id, "litersFor3DObject");
		local objectOutputFruit = getUserAttribute(id, "3DObjektOutputFruit");
		if objectFile ~= nil and litersForObject ~= nil and Fillable.fillTypeNameToInt[objectOutputFruit] ~= nil then
			self.objectOutput = true;
			local parentnode = getParent(id);
			self.objectFile = getUserProfileAppPath().."mods/"..objectFile;
			self.litersForObject = litersForObject;
			self.objectOutputFruit = Fillable.fillTypeNameToInt[objectOutputFruit];
				
		end;
		-- object output trigger
		local num = 0;
		while true do
			num = num + 1;
			local str = "objectOutputTrigger"..tostring(num);
			local triggerIndex = getUserAttribute(id, str);
			if triggerIndex == nil then
				break;
			else
				local trigger = Utils.indexToObject(parent, triggerIndex);
				self.objectOutputTrigger[trigger] = {}
				addTrigger(trigger, "objectOutputTriggerCallback", self);
			end;
		end;
	end;
	
	-- fruit output
	local num = 0;
	while true do
		num = num + 1;
		local attr = "outputFruit"..tostring(num);
		local output = getUserAttribute(id, attr);
		local planeindex = getUserAttribute(id, "planeIndex"..tostring(num));
		local planeMinY = getUserAttribute(id, "planeMinY"..tostring(num));
		local planeMaxY = getUserAttribute(id, "planeMaxY"..tostring(num));
		local planeMultiplicator = getUserAttribute(id, "planeMultiplicator"..tostring(num));
		if Fillable.fillTypeNameToInt[output] == nil then
			break;
		end;
		if planeindex ~= nil and planeMinY ~= nil and planeMaxY ~= nil and planeMultiplicator ~= nil then
			local plane = {}
			local parentnode = getParent(id);
			local planeId = getChildAt(parentnode, planeindex);
			plane.id = planeId;
			plane.MinY = planeMinY;
			plane.MaxY = planeMaxY;
			plane.multiplicator = planeMultiplicator;
			self.planes[Fillable.fillTypeNameToInt[output]] = plane;
		end;
		table.insert(self.outputs, Fillable.fillTypeNameToInt[output]);	
	end;

	if self.outputs[2] ~= nil and not self.needsActivation then
		self.needsActivation = true;
	end;
	if not self.needsActivation then
		self.outputActivated = true;
	end;
	
	addTrigger(id, "outputTriggerCallback", self);
end;

function MapFruitChangeOutputTrigger:delete()
	if self.particleSystemRoot ~= nil then
		delete(self.particleSystemRoot);
	end;
	removeTrigger(self.triggerId);
	delete(self.triggerId);
	for k, v in pairs(self.objectOutputTrigger) do
		removeTrigger(k);
	end;
end;

function MapFruitChangeOutputTrigger:outputTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local trailer = g_currentMission.objectToTrailer[otherShapeId];
	if trailer ~= nil and trailer.allowFillType ~= nil then
		if onEnter then
			table.insert(self.trailers, trailer);
		end;
		if onLeave then
			for a=1, table.getn(self.trailers) do
				if self.trailers[a] == trailer then
					table.remove(self.trailers, a);
				end;
			end;
		end;
	end;
end;

function MapFruitChangeOutputTrigger:update(dt)
	-- first Run settings
	if self.firstRun then
		-- get inputTrigger
		for a=1, table.getn(MFCT_HelpClass.MapFruitChangeTriggers) do
			if MFCT_HelpClass.MapFruitChangeTriggers[a].myMapIndex == self.inputIndex then
				self.inputTrigger = MFCT_HelpClass.MapFruitChangeTriggers[a];
				break;
			end;
		end;
		assert(self.inputTrigger, "There is a MapFruitChangeOutputTrigger without a valid InputIndex. InputIndex: "..tostring(self.inputIndex));
		
		-- load the PS
		local psFile = getUserAttribute(self.triggerId, "particleSystemFile");
		local psIndex = getUserAttribute(self.triggerId, "particleSystemNodeIndex");
		if psFile ~= nil and psIndex ~= nil then
			local path = MFCT_HelpClass.currentMapPath..psFile;
			self.particleSystemRoot = loadI3DFile(path);
			local parent = getParent(self.triggerId);
			local node = Utils.indexToObject(parent, psIndex);
			link(node, self.particleSystemRoot);
			for a=0, getNumOfChildren(self.particleSystemRoot)-1 do
				local child = getChildAt(self.particleSystemRoot, a);
				if getClassName(child) == "Shape" then
					local geometry = getGeometry(child);
					if geometry ~= 0 then
						if getClassName(geometry) == "ParticleSystem" then
							self.particleSystem = geometry;
							setEmittingState(self.particleSystem, false);
							break;
						end;
					end;
				end;
			end;
		end;
		self.firstRun = false;
	end;
	
	if self.needsActivation then
	
		-- Activate Output
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			for a=1, table.getn(self.trailers) do
				local trailer = self.trailers[a];
				if self:getIsInputAllowed(trailer) and trailer:allowFillType(self.outputs[self.outputSelection]) then
					self:setOutputActivated(not self.outputActivated);
					break;
				end;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.MFCT_NEXTFRUIT) or InputBinding.hasEvent(InputBinding.MFCT_LASTFRUIT) then
			for a=1, table.getn(self.trailers) do
				if self:getIsInputAllowed(self.trailers[a]) then
					-- Select Fruit
					if InputBinding.hasEvent(InputBinding.MFCT_NEXTFRUIT) and self.outputs[self.outputSelection + 1] ~= nil then
						self:selectOutputFruitType(self.outputSelection + 1);
					end;
					if InputBinding.hasEvent(InputBinding.MFCT_LASTFRUIT) and self.outputs[self.outputSelection - 1] ~= nil then
						self:selectOutputFruitType(self.outputSelection - 1);
					end;
				end;
			end;
		end;
	end;
end;

function MapFruitChangeOutputTrigger:selectOutputFruitType(num, noEventSend)
	if self.outputs[num] ~= nil then
		self.outputSelection = num;
		if not noEventSend then
			MFCOT_FruitSelectEvent.sendEvent(self, num, noEventSend);
		end;
	end;
end;

function MapFruitChangeOutputTrigger:updateTick(dt)
	if g_server ~= nil then
		local fullTrailers = 0;
		if self.outputActivated then
			for a=1, table.getn(self.trailers) do
				local trailer = self.trailers[a];
				local allowFilling = true;
				if trailer.kippWinkel ~= nil then
					if trailer.kippWinkel > 0 then
						allowFilling = false;
					end;
				end;
				if allowFilling and trailer:allowFillType(self.outputs[self.outputSelection]) then 
					if self.inputTrigger.outputlevels[self.outputs[self.outputSelection]] > 0 then
						local outputbackup = self.inputTrigger.outputlevels[self.outputs[self.outputSelection]];
						-- Get amount
						local amount = math.min(self.fillSpeed, outputbackup);
						if (amount + trailer.fillLevel) > trailer.capacity then
							amount = trailer.capacity - trailer.fillLevel;
						end;
						if amount > 0 then
							-- transfer amount
							local trailerFillLevel = self.trailers[a].fillLevel + amount;
							key = self.outputs[self.outputSelection];
							level = self.inputTrigger.outputlevels[key] - amount;
							self.inputTrigger:changeOutput(key, level);
							trailer:setFillLevel(trailerFillLevel, self.outputs[self.outputSelection], true);
						else
							fullTrailers = fullTrailers + 1;
						end;
					end;
				end;
			end;
		end;
		if fullTrailers == table.getn(self.trailers) and self.needsActivation then
			self:setOutputActivated(false);
		end;
		--3D Object Output
		if self.objectOutput and self.inputTrigger.outputlevels[self.objectOutputFruit] ~= nil then
			if self.inputTrigger.outputlevels[self.objectOutputFruit] > self.litersForObject then
				self:getIsAllowedToPlace3DObject();
			end;
		end;
		if self.needsActivation then
			if self.trailers[1] == nil then
				self:setOutputActivated(false);
			end;
			if self.outputActivated and self.inputTrigger.outputlevels[self.outputs[self.outputSelection]] == 0 then
				self:setOutputActivated(false);
			end;
		end;
	end;
	-- update planes
	for k, v in pairs(self.planes) do
		local plane = v;
		local x, y, z = getTranslation(plane.id);
		local calculatedY = plane.MinY + (plane.multiplicator * self.inputTrigger.outputlevels[k]);
		local newY = math.min(plane.MaxY, calculatedY);
		setTranslation(plane.id, x, newY, z);
	end;
	-- particle system
	if self.particleSystem ~= nil then
		local psActive = false;
		if self.trailers[1] ~= nil and self.outputActivated and self.inputTrigger.outputlevels[self.outputs[self.outputSelection]] > 0 then
			psActive = true;
		end;
		setEmittingState(self.particleSystem, psActive);
	end;
end;

function MapFruitChangeOutputTrigger:draw()
	if self.needsActivation then
		for a=1, table.getn(self.trailers) do
			local trailer = self.trailers[a];
			if self:getIsInputAllowed(trailer) then
				-- active/deactivate text
				if trailer:allowFillType(self.outputs[self.outputSelection]) then
					if not self.outputActivated then
						local fruitText = self:getHasText(Fillable.fillTypeIntToName[self.outputs[self.outputSelection]]);
						g_currentMission:addHelpButtonText(" "..g_i18n:getText("MFCT_start_fill").." ("..fruitText..")", InputBinding.ACTIVATE_OBJECT); 
					else
						g_currentMission:addHelpButtonText(" "..g_i18n:getText("MFCT_stop_fill"), InputBinding.ACTIVATE_OBJECT); 
					end;
				end;
				-- show empty warning
				if self.inputTrigger.outputlevels[self.outputs[self.outputSelection]] ~= nil then
					if self.inputTrigger.outputlevels[self.outputs[self.outputSelection]] <= 0 then
						local fruitText = g_i18n:getText(Fillable.fillTypeIntToName[self.outputs[self.outputSelection]])
						g_currentMission:addExtraPrintText(g_i18n:getText("MFCT_no").." "..fruitText.." "..g_i18n:getText("MFCT_at").." "..self:getHasText(self.inputTrigger.outputSiloName)); 
					end;
				end;
				-- fruit select
				if self.outputs[(self.outputSelection + 1)] ~= nil then
					local fruitText = self:getHasText(Fillable.fillTypeIntToName[self.outputs[self.outputSelection + 1]]);
					g_currentMission:addHelpButtonText(g_i18n:getText("MFCT_next_fruit")..fruitText, InputBinding.MFCT_NEXTFRUIT); 
				end;
				if self.outputs[(self.outputSelection - 1)] ~= nil then
					local fruitText = self:getHasText(Fillable.fillTypeIntToName[self.outputs[self.outputSelection - 1]]);
					g_currentMission:addHelpButtonText(g_i18n:getText("MFCT_last_fruit")..fruitText, InputBinding.MFCT_LASTFRUIT); 
				end;
				break;
			end;
		end;
	end;
end;

function MapFruitChangeOutputTrigger:getIsInputAllowed(trailer)
		if g_gui.currentGui ~= nil then
			return false;
		end;
		if g_currentMission.controlledVehicle == nil then
			return false;
		end;
		if g_currentMission.controlledVehicle == trailer then
			return true;		
		end;
		if g_currentMission.controlledVehicle == trailer.attacherVehicle then
			return true;
		end;
		if trailer:getIsActiveForInput() then
			return true;
		end;
		return false;
end;

function MapFruitChangeOutputTrigger:getHasText(name)
	local text = g_i18n:getText(name);
	if text ~= "Missing "..name.." in l10n_de.xml" then
		return text;
	else
		return name;
	end;
end;

function MapFruitChangeOutputTrigger:objectOutputTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	local trigger = self.objectOutputTrigger[triggerId];
	if onEnter then
		table.insert(trigger, otherId);
	end;
	if onLeave then
		for a=1, table.getn(trigger) do
			if trigger[a] == otherId then
				table.remove(trigger, a);
			end;
		end;
	end;
end;

function MapFruitChangeOutputTrigger:getIsAllowedToPlace3DObject()
	for k, v in pairs(self.objectOutputTrigger) do
		if table.getn(v) == 0 then
			local x, y, z = getWorldTranslation(k);
			self:createNew3DObject(x, y, z);
			break;
		end;		
	end;
end;

function MapFruitChangeOutputTrigger:createNew3DObject(x, y, z)
	g_currentMission:loadVehicle(self.objectFile, x, 1, z, 0, true);
	local newLevel = self.inputTrigger.outputlevels[self.objectOutputFruit] - self.litersForObject;
	self.inputTrigger:changeOutput(self.objectOutputFruit, newLevel);
end;

function MapFruitChangeOutputTrigger:setOutputActivated(state, noEventSend)
	self.outputActivated = state;
	if not noEventSend then
		MFCOT_ActivateOutput.sendEvent(self, state, noEventSend);
	end;
end;