--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
	bgapic = Utils.getFilename("pdasymbols/BGA.png", self.baseDirectory);
		eifokpic = Utils.getFilename("pdasymbols/EIFOK.png", self.baseDirectory);
		raiffeisenpic = Utils.getFilename("pdasymbols/Raiffeisen.png", self.baseDirectory);
		brauereipic = Utils.getFilename("pdasymbols/Brauerei.png", self.baseDirectory);
		haendlerpic = Utils.getFilename("pdasymbols/haendler.png", self.baseDirectory);
		milchpic = Utils.getFilename("pdasymbols/milch.png", self.baseDirectory);
		
		-- create Map Hotspots
		self.missionPDA:createMapHotspot("bga", bgapic, 1154, 764, 0.036, 0.036, false, false, 0);
		
		-- create Map Hotspots
		self.missionPDA:createMapHotspot("eifok", eifokpic, 753, 406, 0.025, 0.050, false, false, 0);
		
		-- create Map Hotspots
		self.missionPDA:createMapHotspot("raiffeisen", raiffeisenpic, 883, 982, 0.036, 0.054, false, false, 0);
		
		-- create Map Hotspots
		self.missionPDA:createMapHotspot("brauerei", brauereipic, 1622, 283, 0.018, 0.027, false, false, 0);
		
		-- create Map Hotspots
		self.missionPDA:createMapHotspot("haendler", haendlerpic, 1158, 1064, 0.036, 0.036, false, false, 0);
		
		-- create Map Hotspots
		self.missionPDA:createMapHotspot("milch", milchpic, 1893, 1062, 0.025, 0.050, false, false, 0);
		
    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
