--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.30, 0.02, "Taste Numpad 0: Info Einschalten");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.30, 0.02, "Taste Numpad 0: Info Abschalten");
		renderText(0.72, 0.75, 0.02, "- DLK 23/12 Info -");
		renderText(0.72, 0.73, 0.02, "Taste R: Blaulicht");
		renderText(0.72, 0.71, 0.02, "Taste H: Starktonhorn");
		renderText(0.72, 0.69, 0.02, "Taste Space: Presslufthorn");
		--renderText(0.72, 0.67, 0.02, "Taste H: Starktonhorn");
		renderText(0.72, 0.65, 0.02, "Taste Numpad 1: Blinker links");
		renderText(0.72, 0.63, 0.02, "Taste Numpad 2: Warnblinker");
		renderText(0.72, 0.61, 0.02, "Taste Numpad 3: Blinker rechts");
		--renderText(0.72, 0.59, 0.02, "Taste H: Starktonhorn");
		renderText(0.72, 0.57, 0.02, "Taste Z: Stuetzen links ein-/ausfahren");
        	renderText(0.72, 0.55, 0.02, "Taste U: Stuetzen rechts ein-/ausfahren");
        	renderText(0.72, 0.53, 0.02, "Taste J: Stuetzen links senken/heben");
		renderText(0.72, 0.51, 0.02, "Taste K: Stuetzen rechts senken/heben");
		--renderText(0.72, 0.49, 0.02, "Taste H: Starktonhorn");
		renderText(0.72, 0.47, 0.02, "Taste Numpad 4/6: Leiter drehen");
		renderText(0.72, 0.45, 0.02, "Taste Numpad 7/9: Leiter heben/senken");
		renderText(0.72, 0.43, 0.02, "Taste 6/7: Leiter aus-/einfahren");
		renderText(0.72, 0.41, 0.02, "Taste Numpad 5/8: Korb neigen");
		renderText(0.72, 0.39, 0.02, "Taste B: Stuetzenwarnlichter an/aus");
		renderText(0.72, 0.37, 0.02, "Taste N: Feuerwehrmann an der Leiter ein-/ausblenden");
        	renderText(0.72, 0.35, 0.02, "Taste M: Feuerwehrmann im Korb ein-/ausblenden");      
	end;
end;  

function ShowHelp:onLeave()
	self.showHelp = false;
end;




