
Weights = {};

function Weights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Weights:load(xmlFile)

	self.extrawheelWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extrawheelWeights#count"), 0);
    self.weights = {};
    for i=1, self.extrawheelWeights do
        local weightnamei = string.format("vehicle.extrawheelWeights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	self.singleWeight = 0;
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 100);
end;

function Weights:delete()
end;

function Weights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Weights:keyEvent(unicode, sym, modifier, isDown)
end;

function Weights:update(dt)
	
	if self.isEntered then
	    self.singleWeight = (self.maxWeight / self.extrawheelWeights);
	
		if InputBinding.hasEvent(InputBinding.WEIGHT_ADD) then
			if self.currentWeight >= self.maxWeight then
				self.currentWeight = 0;
			else
				self.currentWeight = self.currentWeight + self.singleWeight;
			end;
		end;
		
		if self.weights ~= nil then
		    if self.currentWeight ~= self.controlWeight then
		        self.controlWeight = self.currentWeight;
			
			    if self.currentWeight > 0 then
		            for i = 1, self.extrawheelWeights do
				        if i * self.singleWeight <= self.currentWeight then
					        setVisibility(self.weights[i], true);
					    end;
				    end;
				else
				    for i = 1, self.extrawheelWeights do
					    setVisibility(self.weights[i], false);
					end;
			    end;
		    end;
		end;
	end;
end;

function Weights:onLeave()
	self.weightActive = false;
end;

function Weights:draw()
	g_currentMission:addHelpButtonText("Add Weights: " ..string.format("%d kg", self.currentWeight*5), InputBinding.WEIGHT_ADD);
end;

