ESLimiter455cEvent = {};
ESLimiter455cEvent_mt = Class(ESLimiter455cEvent, Event);

InitEventClass(ESLimiter455cEvent, "ESLimiter455cEvent");

function ESLimiter455cEvent:emptyNew()
    local self = Event:new(ESLimiter455cEvent_mt);
    self.className="ESLimiter455cEvent";
    return self;
end;

function ESLimiter455cEvent:new(vehicle, level, percentage, doRestoreLimit)
    local self = ESLimiter455cEvent:emptyNew()
    self.vehicle = vehicle;
	self.level = level;
	self.percentage = percentage;
	self.doRestoreLimit = doRestoreLimit;
    return self;
end;

function ESLimiter455cEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.level = streamReadInt8(streamId);
	self.percentage = streamReadInt8(streamId);
	self.doRestoreLimit = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ESLimiter455cEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.level);
	streamWriteInt8(streamId, self.percentage);
	streamWriteBool(streamId, self.doRestoreLimit);
end;

function ESLimiter455cEvent:run(connection)
	self.vehicle:setNewLimit(self.level, self.percentage, self.doRestoreLimit, true);
	if not connection:getIsServer() then
		--g_server:broadcastEvent(ESLimiter455cEvent:new(self.vehicle, self.level, self.percentage, self.doRestoreLimit), nil, connection, self.object);
	end;
end;

function ESLimiter455cEvent.sendEvent(vehicle, level, percentage, doRestoreLimit, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			-- no need to broadcast the event: only the server need the information
			--g_server:broadcastEvent(ESLimiter455cEvent:new(vehicle, level, percentage, doRestoreLimit), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ESLimiter455cEvent:new(vehicle, level, percentage, doRestoreLimit));
		end;
	end;
end;