--
-- ESLimiter455c
-- Specialization for ESLimiter455c
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		05/11/10
-- @version:	v2.1
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 and some bugfixes
--				v2.1 - Network-Fixes
--

ESLimiter455c = {};

function ESLimiter455c.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ESLimiter455c:load(xmlFile)

	self.setNewLimit = SpecializationUtil.callSpecializationsFunction("setNewLimit");

	self.ESLimiter455c = {};
	self.ESLimiter455c.xPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter455c#posX"), 0.7543);
	self.ESLimiter455c.yPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter455c#posY"), 0.1715);
	self.ESLimiter455c.maxRPM = {};
	self.ESLimiter455c.percentage = {};
	for k,v in pairs(self.motor.maxRpm) do
		self.ESLimiter455c.maxRPM[k] = self.motor.maxRpm[3];
		local percentage = string.format("%d",(self.motor.maxRpm[k]* 100 / self.motor.maxRpm[3]));
		self.ESLimiter455c.percentage[k] = tonumber(percentage); -- percentage
	end;

	self.eslOverlay = Overlay:new("hudESLOverlay", Utils.getFilename("Texture/ESLimiter455c_hud.png", self.baseDirectory), self.ESLimiter455c.xPos, self.ESLimiter455c.yPos, 0.2371, 0.039525);
	self.lastButtonDown = nil;
	self.isLimiterActive = false;
end;

function ESLimiter455c:delete()
end;

function ESLimiter455c:readStream(streamId, connection)
	for level,_ in pairs(self.ESLimiter455c.percentage) do
		local percentage = streamReadInt8(streamId);
		self:setNewLimit(level, percentage, false, true);
	end;
end;

function ESLimiter455c:writeStream(streamId, connection)
	for _,percentage in pairs(self.ESLimiter455c.percentage) do
		streamWriteInt8(streamId, percentage);
	end;
end;

function ESLimiter455c:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ESLimiter455c:keyEvent(unicode, sym, modifier, isDown)
end;

function ESLimiter455c:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			local currentLevel = self.motor.speedLevel;
			if self.movingDirection < 0 then
				currentLevel = 1;
			end;

			if currentLevel ~= 0 then
				local percentage = self.ESLimiter455c.percentage;
				if InputBinding.isPressed(InputBinding.ESLimiter455c_PLUS) and percentage[currentLevel] < 100 then
					self.lastButtonDown = InputBinding.ESLimiter455c_PLUS;
					percentage[currentLevel] = percentage[currentLevel] + 1;
					-- don't send event to other players
					self:setNewLimit(currentLevel, percentage[currentLevel], false, true);
				elseif InputBinding.isPressed(InputBinding.ESLimiter455c_MINUS) and percentage[currentLevel] > 10 then
					percentage[currentLevel] = percentage[currentLevel] - 1;
					self.lastButtonDown = InputBinding.ESLimiter455c_MINUS;
					-- don't send event to other players
					self:setNewLimit(currentLevel, percentage[currentLevel], false, true);
				else
					if self.lastButtonDown ~= nil then
						-- only send event to other players if key was released -> performance issue
						self:setNewLimit(currentLevel, percentage[currentLevel], false);
						self.lastButtonDown = nil;
					end;	
				end;
				self.isLimiterActive = true;
			else
				if self.isLimiterActive then
					self:setNewLimit(3, 100, true);
					self.isLimiterActive = false;
				end;
				self.motor.maxRpm[3] = self.ESLimiter455c.maxRPM[3];
			end;
		end;
	end;
end;

function ESLimiter455c:draw()
	local currentLevel = self.motor.speedLevel;
	local text = "Deaktiviert";
	if self.movingDirection < 0 then
		currentLevel = 1;
	end;
	if currentLevel ~= 0 then
		local percentage = tonumber(string.format("%d", self.ESLimiter455c.percentage[currentLevel]));
		if percentage < 100 then
			percentage = " " .. percentage;
		end;
		text = g_i18n:getText("ESLimiter455c_level") .. currentLevel .. ":" .. percentage .. "% ";	
	end;
	self.eslOverlay:render();
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_LEFT);
	renderText(self.ESLimiter455c.xPos + 0.13, self.ESLimiter455c.yPos + 0.0085, 0.02, text);
	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("ESLimiter455c_controls"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ESLimiter455c_PLUS) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ESLimiter455c_MINUS));
end;

function ESLimiter455c:setNewLimit(level, percentage, doRestoreLimit, noEventSend)	
	ESLimiter455cEvent.sendEvent(self, level, percentage, doRestoreLimit, noEventSend);	
	local currentRPM = self.ESLimiter455c.maxRPM;
	if not doRestoreLimit then
		self.ESLimiter455c.percentage[level] = percentage;
		if self.movingDirection > 0 then
			self.motor.maxRpm[level] = tonumber(string.format("%d",(percentage * currentRPM[level] / 100)));
		else
			self.motor.maxRpm[3] = tonumber(string.format("%d",(percentage * currentRPM[level] / 100)));
		end;
	else
		self.motor.maxRpm[3] = self.ESLimiter455c.maxRPM[3];
	end;
end;


function ESLimiter455c:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueStr = getXMLString(xmlFile, key.."#limiterValues");		
		if valueStr ~= nil then
			local found = string.find(valueStr, ";");
			local index = 1;
			while found ~= nil do
				local value = string.sub(valueStr, 0, found-1);
				valueStr = string.sub(valueStr, found+1);
				found = string.find(valueStr, ";");
				self.ESLimiter455c.percentage[index] = tonumber(value);
				if found == nil then
					self.ESLimiter455c.percentage[index+1] = tonumber(valueStr);
				end;
				index = index + 1;	
			end;
		end;
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function ESLimiter455c:getSaveAttributesAndNodes(nodeIdent)
	local values = "";	
	for k,v in pairs(self.ESLimiter455c.percentage) do
		if k ~= 1 then
			values = values .. ";";
		end;
		values = values .. string.format("%d", v);
	end;
	
    local attributes = 'limiterValues="'.. values .. '"';
    return attributes, nil;
end;