--
-- BlomenroehrLowBedTrailer
-- Specialization for Blomenroehr low bed trailer
--
-- @author    PES 4ever
-- @date      06/08/11
-- @version   1.0
--
-- For support and documentation visit www.modding-society.de
-- Copyright (C) PES 4ever, All Rights Reserved.
--

BlomenroehrLowBedTrailer = {};

function BlomenroehrLowBedTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function BlomenroehrLowBedTrailer:load(xmlFile)

	-- Wheel chocks
	self.wheelChocks = {};
	self.wheelChocks.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheelChocks#index"));
	self.wheelChocks.placed = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheelChocks#placed"));
	setVisibility(self.wheelChocks.node, false);
	setVisibility(self.wheelChocks.placed, true);
	
	-- Threaded spindle crank
	local node =  Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.threadedSpindle#crank"));
	if node ~= nil then
		self.crank = {};
		self.crank.node = node;
		self.crank.rotScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threadedSpindle#rotScale"), 1);
	end;
	
	-- Joint search for updating vehicle
	self.doJointSearch = false;
	
end;

function BlomenroehrLowBedTrailer:delete()
end;

function BlomenroehrLowBedTrailer:readStream(streamId, connection)
end;

function BlomenroehrLowBedTrailer:writeStream(streamId, connection)
end;

function BlomenroehrLowBedTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BlomenroehrLowBedTrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function BlomenroehrLowBedTrailer:update(dt)
end;

function BlomenroehrLowBedTrailer:updateTick(dt)
	
	if self:getIsActive() then
	
		if self.isClient then		
			-- Check moving tool 1 for updates
			local rotDiff = 0; -- rotation difference
			local tool = self.movingTools[1];
			if tool ~= nil then
				if tool.rotSpeed ~= nil then
					local curRot = tool.curRot[tool.rotationAxis];
					if tool.savedLastRot == nil then
						tool.savedLastRot = curRot;
					end;
					rotDiff = curRot - tool.savedLastRot;
					tool.savedLastRot = curRot;
				end;
			end;
			
			-- Rotate threaded spindle crank
			if self.crank ~= nil then
				if rotDiff ~= 0 then
					local dx = rotDiff * self.crank.rotScale;
					rotate(self.crank.node, dx, 0, 0);
				end;
			end;			
		end;		
		
		if self.isServer then
			-- Set joint rotation limit of ramp
			local animTime = self:getAnimationTime("moveRamp");
			local startTime = 0.3;
			if animTime > startTime and animTime < 1 then
				local limit = (animTime - startTime) / (1 - startTime) * math.rad(30);
				setJointRotationLimit(self.componentJoints[1].jointIndex, 0, true, -limit, limit);
			end;
			
			-- Search vehicle attacher joint
			if self.doJointSearch then
				if self.attacherVehicle ~= nil then
					for _, v in pairs(self.attacherVehicle.attachedImplements) do
						if v.object == self then
							local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
							self.vehicleJoint = joint;
							self.doJointSearch = false;
							break;
						end;
					end;
				end;
			end;				
			
			-- Update vehicle attacher joint    
			if self.vehicleJoint ~= nil	then
				if rotDiff ~= 0 then
					setJointFrame(self.vehicleJoint.jointIndex, 1, self.attacherJoint.node);
				end;
			end;
		end;		

	end;
	
end;

function BlomenroehrLowBedTrailer:draw()
end;

function BlomenroehrLowBedTrailer:onAttach(attacherVehicle)
	
	-- Do joint search
	self.doJointSearch = true;
	
	-- Set wheel chocks visibility
	setVisibility(self.wheelChocks.node, true);
	setVisibility(self.wheelChocks.placed, false);
	
end;

function BlomenroehrLowBedTrailer:onDetach()

	-- Set wheel chocks visibility
	setVisibility(self.wheelChocks.node, false);
	setVisibility(self.wheelChocks.placed, true);
	
end;