--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    pda_farmshop = Utils.getFilename("map01/pdapics/pda_farmshop.png", self.baseDirectory);
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));

    -- load Mission Glass Containers
    self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
    -- load Mission Bottles
    self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));

    -- PDA Hotspots
	
    self.missionPDA:createMapHotspot("Watermill", "dataS2/missions/hud_pda_spot_watermill.png", 756, 908, 0.03, 0.03, false, false, 0);
    self.missionPDA:createMapHotspot("Dairy", "dataS2/missions/hud_pda_spot_dairy.png", 1720, 736, 0.03, 0.03, false, false, 0);
    self.missionPDA:createMapHotspot("Brewery", "dataS2/missions/hud_pda_spot_brewery.png", 1610, 1138, 0.02, 0.02, false, false, 0);
    self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1166, 214, 0.026, 0.026, false, false, 0);
    self.missionPDA:createMapHotspot("pda_farmshop", pda_farmshop , 1768, 650, 0.02, 0.02, false, false, 0);
    
    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
