--
--   FsIX - Farming Shop Inventory Fixer
--
-- @author  Decker    (ls-uk.info, Decker_MMIV)
-- @date    2011-08-24
-- 
-- @comment Found problems or bugs? Please post them in the www.ls-uk.info support-thread for this mod. Thank you.
--          This mod is placed in the section 'Other', which at time of writing is; http://www.ls-uk.info/downloads/6
--
-- @history v0.01     - Experimental test, based upon little info found on
--                      http://gdn.giants-software.com/thread.php?categoryId=3&threadId=735
--          v0.02     - Added some GUI, where the mouse unfortunatly only works when player is in a vehicle. 
--                      Being ONFOOT does not work.
--          v0.03     - ALT+R is the default key to activate the 'laptop'. Hopefully it will not conflict too much 
--                      with other mods, or refueling/filling.
--                    - Added 'Auto-load when starting map', and other debug/developer-only switches.
--          v0.9      - Public release on www.ls-uk.info
--          v0.91     - ProFarm uses quote-characters in some of its mods, and that is not good when HTML-entities are not encoded,
--                      so the saveInventory() function is now completely recoded, using some proper engine functions.
--                    - Fixed mouse-cursor not being hidden, when pressing the "back" button.
--                    - Added some pcall() functionality, "protected call", in hope of catching "exceptions"/errors when loading/saving.
--                    - Second release on www.ls-uk.info
--

-- split function found at http://lua-users.org/wiki/SplitJoin
function string:split(sep)
    local sep, fields = sep or ":", {}
    local pattern = string.format("([^%s]+)", sep)
    self:gsub(pattern, function(c) fields[#fields+1] = c end)
    return fields
end
-- DOH!
-- Utils.splitString(<delimiter>, <string>);


-- Constants
FsIX = {};
FsIX.scriptName = "FarmingShopInventoryFix";
FsIX.version = 1;
FsIX.modDir = g_currentModDirectory;
FsIX.inventoryFilename = getUserProfileAppPath() .. "/".. FsIX.scriptName ..".xml";
--
FsIX.scale = 0.65;
FsIX.offsetX = 0.030;
FsIX.offsetY = 0.300;
--[[
FsIX.scale = 1.0;
FsIX.offsetX = 0.0;
FsIX.offsetY = 0.0;
]]--
--
FsIX.MouseButton_Left          = 0x01;
FsIX.MouseButton_Right         = 0x02;
FsIX.MouseButton_Middle        = 0x04;
FsIX.MouseButton_ScrollUp      = 0x08;
FsIX.MouseButton_ScrollDown    = 0x10;
FsIX.MouseButton_Scroll        = bitOR(FsIX.MouseButton_ScrollUp, FsIX.MouseButton_ScrollDown);


-- Scale
function s(z)
    return z * FsIX.scale;
end;
-- Scale & Offset X
function sox(x)
    return s(x)+FsIX.offsetX;
end;
-- Scale & Offset Y
function soy(y)
    return s(y)+FsIX.offsetY;
end;    
--
function renderTextWithShade(x,y, textSize, text)
    setTextColor(0.0, 0.0, 0.0, 1.0);   -- black
    renderText(x, y - (textSize/10), textSize, text);
    setTextColor(1.0, 1.0, 1.0, 1.0);   -- white
    renderText(x, y, textSize, text);
end;

function FsIX:loadMap(name)
    -- Only initialize once, and not at every .I3D file loaded.
    if (self.initialized) then
        return;
    end;

    print("FsIX:loadMap("..name.."). modDir="..Utils.getNoNil(FsIX.modDir, "nil"));
    
    -- [2011-08-20 Decker] I just found out (probably just as the CoursePlay authors may have), 
    -- that this "gui" when active completely disables any overlay-rendering. So it seems
    -- useless, until Giants will document more of their XML; <GUI><GuiElement/></GUI>.
    -- -- http://gdn.giants-software.com/thread.php?categoryId=3&threadId=790
    -- self.guiName = FsIX.scriptName.."_emptyGui";
    -- g_gui:loadGui(FsIX.modDir.."emptyGui.xml", self.guiName);
    
    --
    self.overlayButtons = {};
    self.overlayDesktop = Overlay:new("laptopDesktop", "dataS2/menu/shop_background.png",   sox(0.000),soy(0.000), s(1.000),s(1.000));
    -- Item scroller buttons/hotspots
    self:addButton(nil, "dataS2/menu/button_up_normal.png",     FsIX.onScroll,         -1, sox(0.030),soy(0.770), s(0.170),s(0.060));
    self:addButton(nil, "dataS2/menu/button_down_normal.png",   FsIX.onScroll,          1, sox(0.030),soy(0.350), s(0.170),s(0.060));
    self:addHotspot(nil,                                        FsIX.onScroll,         -1, sox(0.000),soy(0.350), s(0.200),s(0.500), FsIX.MouseButton_ScrollUp);
    self:addHotspot(nil,                                        FsIX.onScroll,          1, sox(0.000),soy(0.350), s(0.200),s(0.500), FsIX.MouseButton_ScrollDown);
    self:addHotspot(nil,                                        FsIX.onScroll,         -1, sox(0.000),soy(0.600), s(1.000),s(0.250), FsIX.MouseButton_ScrollUp);
    self:addHotspot(nil,                                        FsIX.onScroll,          1, sox(0.000),soy(0.600), s(1.000),s(0.250), FsIX.MouseButton_ScrollDown);
    -- Section prev/next buttons
    self:addButton(nil, "dataS2/menu/button_left_normal.png",   FsIX.onSectionModify,  -1, sox(0.350),soy(0.530), s(0.170),s(0.060));
    self:addButton(nil, "dataS2/menu/button_right_normal.png",  FsIX.onSectionModify,   1, sox(0.750),soy(0.530), s(0.170),s(0.060));
    --
    self.chkAutoLoad = self:addChkBox("dataS2/menu/checkbox_un.png", "dataS2/menu/checkbox_cn.png", FsIX.onChkBox, nil, sox(0.050),soy(0.240), s(0.170),s(0.060));
    --
                      self:addButton(g_i18n:getText("Load"),   "dataS2/menu/button_normal.png",   FsIX.onLoad, nil, sox(0.630),soy(0.130), s(0.170),s(0.060));
    self.saveButton = self:addButton(g_i18n:getText("Save"),   "dataS2/menu/button_normal.png",   FsIX.onSave, nil, sox(0.800),soy(0.130), s(0.170),s(0.060));
                      self:addButton(g_i18n:getText("Back"),   "dataS2/menu/button_normal.png",   FsIX.onBack, nil, sox(0.800),soy(0.050), s(0.170),s(0.060));
    -- Price arrow buttons/hotspots
    self.digits = {};
    self.digits.offsetW = 0.035;
    self.digits.offsetH = 0.035;
    self.digits.x = 0.8;
    self.digits.y = 0.45;
    self.digits.textSize = 0.04;
    self:addButton(nil, "dataS2/menu/text_input_bg_normal.png",  nil, nil, sox(self.digits.x-0.340+(self.digits.offsetW*1.25)),soy(self.digits.y-0.01), s(0.340),s(0.060));
    local digitArrows = Utils.getFilename("DigitArrows.png", FsIX.modDir);
    for idx=0,6 do
        local power = math.pow(10,idx);
        self:addHotspot(digitArrows, self.onPriceModify,  power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y - (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH*3), FsIX.MouseButton_ScrollUp);
        self:addHotspot(nil,         self.onPriceModify, -power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y - (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH*3), FsIX.MouseButton_ScrollDown);
        self:addButton(nil, nil, FsIX.onPriceModify,  power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y + (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH));
        self:addButton(nil, nil, FsIX.onPriceModify, -power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y - (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH));
    end;
    
    --
    self.laptopOn = false;
    self:setIsDirty(false);
    self.itemIndex = 1;
    self.overlayIcon = nil;
    self:onScroll(0);
    self:setInfo("");
    self.firstTime = true;
    self.autoLoadAtMapStart = false;
    --
    self.initialized = true;
end;

function FsIX:deleteMap()
    print("FsIX:deleteMap()");
    -- Clean up resources
    delete(self.overlayIcon);    self.overlayIcon = nil;
    delete(self.overlayDesktop); self.overlayDesktop = nil;
    for _,b in pairs(self.overlayButtons) do
        if (b.overlayUnchecked ~= nil) then
            delete(b.overlayUnchecked);
            delete(b.overlayChecked);
        else
            if (b.overlay ~= nil) then
                delete(b.overlay);
            end;
        end;
    end;
    self.overlayButtons = {};
    --
    self.initialized = false;
end;

function FsIX:load(xmlFile)
    print("FsIX:load("..xmlFile..")");
end

function FsIX:addHotspot(imgFilename, callback, callbackData, x,y, width,height, mouseButtons)
    local overlay = nil;
    if (imgFilename ~= nil) then
        overlay = Overlay:new(nil, imgFilename, x,y, width,height);
    end;
    local button = {visible=(overlay ~= nil), enabled=true, buttonText=nil, overlay=overlay, rect={x,y, x+width,y+height}, onClick=callback, callbackData=callbackData, mouseButtons=mouseButtons};
    table.insert(self.overlayButtons, button);
end;

function FsIX:addButton(buttonText, imgFilename, callback, callbackData, x,y, width,height, mouseButtons)
    if (mouseButtons == nil) then mouseButtons = FsIX.MouseButton_Left; end;
    local overlay = nil;
    if (imgFilename ~= nil) then
        overlay = Overlay:new(buttonText, imgFilename, x,y, width,height);
    end;
    local button = {visible=(overlay ~= nil), enabled=true, buttonText=buttonText, overlay=overlay, rect={x,y, x+width,y+height}, onClick=callback, callbackData=callbackData, mouseButtons=mouseButtons};
    table.insert(self.overlayButtons, button);
    return button;
end;

function FsIX:addChkBox(imgUnchecked, imgChecked, callback, callbackData, x,y, width,height, mouseButtons)
    if (mouseButtons == nil) then mouseButtons = FsIX.MouseButton_Left; end;
    local olyUnchk = Overlay:new(nil, imgUnchecked, x,y, width,height);
    local olyChked = Overlay:new(nil, imgChecked, x,y, width,height);
    local button = {visible=(olyUnchk ~= nil), enabled=true, buttonText=nil, overlay=olyUnchk, overlayUnchecked=olyUnchk, overlayChecked=olyChked, rect={x,y, x+width,y+height}, onClick=callback, callbackData=callbackData, mouseButtons=mouseButtons};
    table.insert(self.overlayButtons, button);
    return button;
end;

function FsIX:renderButtons()
    setTextAlignment(RenderText.ALIGN_LEFT);
    setTextBold(true);

    for _,button in pairs(self.overlayButtons) do
        if (button.visible) then
            -- TODO - Normal, Focus, Pressed
            if (button.overlay ~= nil) then
                button.overlay:render();
            end;
            if (button.buttonText ~= nil) then
                if (button.enabled) then
                    setTextColor(0.0, 0.0, 0.0, 1.0);   -- black
                    renderText(button.rect[1]+s(0.042), button.rect[2]+s(0.013), s(0.028), button.buttonText);
                    setTextColor(1.0, 1.0, 1.0, 1.0);   -- white
                else
                    setTextColor(1.0, 1.0, 1.0, 0.3);   -- gray'ish
                end;
                renderText(button.rect[1]+s(0.042), button.rect[2]+s(0.017), s(0.028), button.buttonText);
            end;
        end;
    end;
end;

function FsIX:mouseEvent(posX, posY, isDown, isUp, button)
    if (self.laptopOn) then
--DEBUG.start
--      if (posX < 0.2 and posY < 0.2) then
--          print(string.format("X/Y=%.3f/%.3f, down/up=%s/%s, but=%2d", posX,posY, tostring(isDown),tostring(isUp), button));
--      end;
--DEBUG.end
        if (isDown) then
            -- Convert mouse-button to other value, so it can be AND-masked.
            if      (button == 1) then button = FsIX.MouseButton_Left; 
            elseif  (button == 2) then button = FsIX.MouseButton_Right;
            elseif  (button == 3) then button = FsIX.MouseButton_Middle;
            elseif  (button == 4) then button = FsIX.MouseButton_ScrollUp;
            elseif  (button == 5) then button = FsIX.MouseButton_ScrollDown;
            end;
            --
            for _,overlayButton in pairs(self.overlayButtons) do
                if (overlayButton.enabled) then
                    if (overlayButton.rect[1] <= posX and posX <= overlayButton.rect[3] and overlayButton.rect[2] <= posY and posY <= overlayButton.rect[4]) then
                        if (bitAND(overlayButton.mouseButtons, button) > 0 and overlayButton.onClick ~= nil) then
                            overlayButton.onClick(self, overlayButton.callbackData);
                            break;
                        end;
                    end;
                end;
            end;
        end;
    end;
end;

function FsIX:keyEvent(unicode, sym, modifier, isDown)
end;

function FsIX:update(dt)
    --
    if (self.displayTimer > 0) then
        self.displayTimer = self.displayTimer - dt;
    end;

    -- Handle "autoload at map-start"
    if (self.firstTime) then
        self.firstTime = false; -- Set to false, _before_ executing load, so if something fails here on after, we do not go into an endless-fail-loop.
        self:loadInventory(false);
        self:onChkBox(self.autoLoadAtMapStart);
    end;
    
    --
    if (not g_currentMission.player.isEntered) then 
        if (InputBinding.hasEvent(InputBinding.FsIX_TOGGLELAPTOP) and Input.isKeyPressed(Input.KEY_lalt)) then
            self:setLaptopOn(not self.laptopOn);
            InputBinding.setShowMouseCursor(self.laptopOn);
        end;
    end;    

    --      
    if (self.laptopOn) then
        -- If player activates some GUI screen.
        if (g_gui.currentGuiName ~= "" and g_gui.currentGuiName ~= nil) then
            self:setLaptopOn(false);
            -- Do not disable mousecursor here, due to the player might enter the real Farming Shop (Key P), and expects the mousecursor to be visible.
        end;
    end;
end;

function FsIX:draw()
    if (g_currentMission.player.isEntered) then -- ONFOOT?
        return;
    end;
    
    if (not self.laptopOn) then
        -- Only add help-texts when the help-box is visible. If not, the array 'g_currentMission.helpButtonTexts' will just grow-and-grow-and...(bad allocation?)
        -- Also this should reduce (for this mod) the "big helpbox huge-to-less flashing", when turning the helpbox on again with key F1.
        if g_currentMission.showHelpText then
            g_currentMission:addHelpButtonText(g_i18n:getText("FsIX_TOGGLELAPTOP"), InputBinding.FsIX_TOGGLELAPTOP);
        end;
    else
        InputBinding.setShowMouseCursor(self.laptopOn); -- Test. Will this stop movement of camera, if its called at every draw()?
                                                        -- Yeah, it did... Weird. Though still no luck when ONFOOT.
    
        self.overlayDesktop:render();
        self.overlayIcon:render();
        FsIX:renderButtons();
        --
        setTextAlignment(RenderText.ALIGN_CENTER);
        renderTextWithShade(sox(0.500),soy(0.85), s(0.06), "Administration Terminal");
        if (self.displayTimer > 0) then
            renderText(sox(0.500),soy(0.080), s(0.04), self.displayMsg);
        end;
        setTextAlignment(RenderText.ALIGN_LEFT);
        
        setTextColor(1.0,0.0,0.0, 0.8);
        renderText(sox(0.230), soy(0.89), s(0.03), "Unofficial!");
        
        local shopItem = StoreItemsUtil.storeItems[self.itemIndex];
        
        -- Index
        renderTextWithShade(sox(0.210),soy(0.760), s(0.03), string.format(g_i18n:getText("ItemNum"), self.itemIndex));
        
        -- Name
        renderTextWithShade(sox(0.210),soy(0.700), s(0.04), shopItem.name);
        
        -- Section
        renderTextWithShade(sox(0.100),soy(0.540), s(0.03), g_i18n:getText("ChangeSection"));
        setTextAlignment(RenderText.ALIGN_CENTER);
        renderTextWithShade(sox(0.590),soy(0.540), s(0.04), g_i18n:getText(shopItem.section));
        setTextAlignment(RenderText.ALIGN_LEFT);
        
        -- Price
        renderTextWithShade(sox(0.100),soy(self.digits.y), s(0.03), g_i18n:getText("ChangePrice"));
        local priceTxt = string.format("%10d", shopItem.price);
        for idx=0,6 do
            renderText(sox(self.digits.x - (self.digits.offsetW*idx)), soy(self.digits.y), s(self.digits.textSize), string.sub(priceTxt, 10-idx, 10-idx));
        end;
        
        -- AutoLoad at Start Map
        renderTextWithShade(sox(0.160),soy(0.250), s(0.03), g_i18n:getText("AutoLoad"));
    end;
end;

function FsIX:setLaptopOn(yesno)
    self.laptopOn = yesno;
    g_mouseControlsHelp.active = not self.laptopOn;
    --InputBinding.setShowMouseCursor(self.laptopOn);
    -- if (self.laptopOn) then
        -- g_gui:showGui(self.guiName);
    -- else
        -- g_gui:showGui("");
    -- end;
end;
function FsIX:setIsDirty(isDirty)
    self.dirty = isDirty;
    --self.saveButton.visible = self.dirty;
    self.saveButton.enabled = self.dirty;
end;

function FsIX:onScroll(direction)
    --print("onScroll(".. direction ..")");
    self.itemIndex = self.itemIndex + direction;
    if (self.itemIndex <= 0) then
        self.itemIndex = table.getn(StoreItemsUtil.storeItems);
    end;
    if (self.itemIndex > table.getn(StoreItemsUtil.storeItems)) then
        self.itemIndex = 1;
    end;
    
    delete(self.overlayIcon);
    self.overlayIcon = nil;
    -- TODO - Figure out how to calculate aspect-ratio of the 256x256 image, on to the player's screen.
    self.overlayIcon = Overlay:new(nil, StoreItemsUtil.storeItems[self.itemIndex].imageActive, sox(0.060),soy(0.600), s(0.130),s(0.150));
end;

function digOutSectionList(elem)
    if (elem["target"] ~= nil) then
        if (elem["target"]["sectionList"] ~= nil) then
            return elem["target"]["sectionList"];
        end;
    elseif (elem["elements"] ~= nil) then
        for k,v in pairs(elem["elements"]) do
            res = digOutSectionList(v);
            if (res ~= nil) then
                return res;
            end;
        end;
    end;
    return nil;
end;

function FsIX:onSectionModify(direction)
    --print("onSectionModify(".. direction ..")");
    local curSection = StoreItemsUtil.storeItems[self.itemIndex].section;
    --
    local sectionList = digOutSectionList(g_gui.guis["ShopScreen"]);
    if (sectionList == nil) then
        print("FsIX Failed to dig out 'sectionList' from inside g_gui.guis['ShopScreen'].");
        self:setWarning("LUA-script problem!");
        return;
    end;
    local curSectionIdx = 0;
    for i,v in pairs(sectionList) do
        if (v == curSection) then
            curSectionIdx = i;
            break;
        end;
    end;
    curSectionIdx = curSectionIdx + direction;
    if (curSectionIdx <= 0) then curSectionIdx = table.getn(sectionList); end;
    if (curSectionIdx > table.getn(sectionList)) then curSectionIdx = 1; end;
    --
    StoreItemsUtil.storeItems[self.itemIndex].section = sectionList[curSectionIdx]; -- Apparently this works.
    self:setIsDirty(true);
end;

function FsIX:onPriceModify(power)
    --print("onPriceModify(".. Utils.getNoNil(power,"nil") ..")");
    local price = StoreItemsUtil.storeItems[self.itemIndex].price;
    --
    if (power < 0 and price < math.abs(power)) then power = 0; end; -- If subtracting, do not subtract more than needed.
    price = price+power;
    if (price > 9999999) then price = 9999999; end; -- Nine million nine hundred ninety nine thousand nine hundred ninety nine... must be enough (or?)
    if (price < 1) then price = 1; end; -- Zero or Negative prices are not allowed!
    --
    StoreItemsUtil.storeItems[self.itemIndex].price = price;
    self:setIsDirty(true);
end;

function FsIX:onChkBox(data)
    --print("onChkBox()");
    if (data ~= nil) then
        self.autoLoadAtMapStart = data;
    else
        self.autoLoadAtMapStart = not self.autoLoadAtMapStart;
        self:setIsDirty(true);
    end;
    --
    if (self.autoLoadAtMapStart) then
        self.chkAutoLoad.overlay = self.chkAutoLoad.overlayChecked;
    else
        self.chkAutoLoad.overlay = self.chkAutoLoad.overlayUnchecked;
    end;
end;

function FsIX:onSave(data)
    --print("onSave()");
    self:setIsDirty(not self:saveInventory());
end;
function FsIX:onLoad(data)
    --print("onLoad()");
    self:setIsDirty(not self:loadInventory(true));
    FsIX:onChkBox(self.autoLoadAtMapStart);
end;
function FsIX:onBack(data)
    --print("onBack()");
    self:setLaptopOn(false);
    InputBinding.setShowMouseCursor(self.laptopOn);
end;

function FsIX:setInfo(msg)
    self.displayMsg = msg;
    self.displayTimer = 5000;
end;
function FsIX:setWarning(msg, timer)
    self.displayMsg = msg;
    if (timer == nil) then
        timer = 5000;
    end;
    self.displayTimer = timer;
end;

function FsIX:saveInventory()
    -- http://www.lua.org/pil/8.4.html "Error Handling and Exceptions"
    -- http://stackoverflow.com/questions/732607/whats-with-pcall-or-is-wowwiki-wrong
    -- http://www.wowwiki.com/API_pcall
    local retOK, ret1, ret2 = pcall(FsIX.saveInventory2, self);
    if retOK then
        if ret1 then
            self:setInfo(g_i18n:getText("SaveSuccess"));
        else
            self:setWarning(g_i18n:getText("SaveFailed"));
        end;
        return ret1;
    else
        print("FsIX saveInventory2() failed: "..ret1);
        self:setWarning(g_i18n:getText("SaveFailed"));
        return false;
    end;
end;

function FsIX:saveInventory2()
    -- http://gdn.giants-software.com/documentation_scripting.php#runtime_function_reference_XML
    local xmlFile = createXMLFile("FsIX", FsIX.inventoryFilename, FsIX.scriptName);
    --
    setXMLInt( xmlFile, FsIX.scriptName.."#version", FsIX.version);
    setXMLBool(xmlFile, FsIX.scriptName..".config#autoLoadAtMapStart", self.autoLoadAtMapStart);
    --
    local i=0;
    for _,v in pairs(StoreItemsUtil.storeItems) do
        local fields = string.split(v.xmlFilename, "/");
        -- Process only StoreItems that have a filename consisting of two or more fields (i.e. skip the "Cow")
        if (#fields >= 2) then
            local tag = string.format("%s.items.item(%d)", FsIX.scriptName, i);
            --
            setXMLBool(  xmlFile, tag.."#canModify", true);
            setXMLString(xmlFile, tag.."#modFile", fields[#fields - 1]);
            setXMLString(xmlFile, tag.."#subItem", fields[#fields - 0]);
            --
            tag = tag..".params";
            setXMLInt(   xmlFile, tag.."#price", v.price);
            setXMLString(xmlFile, tag.."#section", v.section);
            setXMLInt(   xmlFile, tag.."#rotation", v.rotation);    -- TODO: Maybe have individual rotation values per map-name.
            setXMLString(xmlFile, tag.."#name", v.name);    -- Just for reference in the .XML file. 
                                                            -- TODO: Figure out how to get HTML-entity names (for '&', '<' and '>')
                                                            -- FIXED: Now HTML-entities are correctly encoded, when using the correct engine functions.
            setXMLString(xmlFile, tag.."#specs", v.specs);  -- TODO: How about storing what kind of fruit/fill trailers can contain?
            --
            i=i+1;
        end;
    end;
    --
    saveXMLFile(xmlFile);   -- TODO - How to determine if the file was saved or not?
    delete(xmlFile);
    --
    return true; -- Uhm. Well. Maybe later I will figure out how saveXMLFile() fails.
end;

function FsIX:loadInventory(forceLoad)
    -- http://www.lua.org/pil/8.4.html "Error Handling and Exceptions"
    -- http://stackoverflow.com/questions/732607/whats-with-pcall-or-is-wowwiki-wrong
    -- http://www.wowwiki.com/API_pcall
    local retOK, ret1, ret2 = pcall(FsIX.loadInventory2, self, forceLoad);
    if retOK then
        return ret1;
    else
        print("FsIX loadInventory2() failed: "..ret1);
        self:setWarning(g_i18n:getText("LoadFailed"));
        return false;
    end;
end;

function FsIX:loadInventory2(forceLoad)
    local rb = false;
    local existFile = io.open(FsIX.inventoryFilename, "r");
    if (existFile == nil) then
        print("FsIX File does not exist; '".. FsIX.inventoryFilename .."'.");
        self:setWarning(g_i18n:getText("LoadFileNotFound"));
        return rb;
    end;
    io.close(existFile); -- Clean up the resource.
    --
	local xmlFile = loadXMLFile(FsIX.scriptName.."XML", FsIX.inventoryFilename);
    if (xmlFile ~= nil) then
        local version = getXMLInt(xmlFile, FsIX.scriptName.."#version");
        if (version <= FsIX.version) then
            self.autoLoadAtMapStart = Utils.getNoNil(getXMLBool(xmlFile, FsIX.scriptName..".config#autoLoadAtMapStart"), false);
            --
            local changePrice       = Utils.getNoNil(getXMLBool(xmlFile, FsIX.scriptName..".config#changePrice"), true);
            local changeSection     = Utils.getNoNil(getXMLBool(xmlFile, FsIX.scriptName..".config#changeSection"), true);
            local changeRotation    = Utils.getNoNil(getXMLBool(xmlFile, FsIX.scriptName..".config#changeRotation"), false);
            local changeName        = Utils.getNoNil(getXMLBool(xmlFile, FsIX.scriptName..".config#changeName"), false);
            local changeSpecs       = Utils.getNoNil(getXMLBool(xmlFile, FsIX.scriptName..".config#changeSpecs"), false);
            --
            if (forceLoad or self.autoLoadAtMapStart) then
                local i = 0;
                while true do
                    local itemTag = string.format(FsIX.scriptName..".items.item(%d)", i);
                    local canModify = Utils.getNoNil(getXMLBool(xmlFile, itemTag.."#canModify"), true);
                    local modFile = getXMLString(xmlFile, itemTag.."#modFile");
                    local subItem = getXMLString(xmlFile, itemTag.."#subItem");
                    if (modFile == nil or subItem == nil) then
                        -- No more items (or corrupt file)
                        break;
                    end;
                    itemTag = itemTag .. ".params";
                    local price     = getXMLFloat( xmlFile, itemTag.."#price");
                    local section   = getXMLString(xmlFile, itemTag.."#section");
                    local rotation  = getXMLFloat( xmlFile, itemTag.."#rotation");
                    local name      = getXMLString(xmlFile, itemTag.."#name");
                    local specs     = getXMLString(xmlFile, itemTag.."#specs");
                    
                    -- Sanity check. Make sure that section-name have a corresponding i18n string. If not found, set it to nil.
                    if (section ~= nil and (not g_i18n:hasText(section))) then section = nil; end;
                    
                    --
                    if (canModify) then
                        for _,v in pairs(StoreItemsUtil.storeItems) do
                            local fields = string.split(v.xmlFilename, "/");                
                            if (#fields >= 2) then
                                -- Not exactly the best way of identifying the items, but it looks almost unique enough.
                                if (modFile == fields[#fields - 1] and subItem == fields[#fields - 0]) then
                                    --
                                    price     = Utils.getNoNil(price, v.price);
                                    section   = Utils.getNoNil(section, v.section);
                                    rotation  = Utils.getNoNil(rotation, v.rotation);
                                    name      = Utils.getNoNil(name, v.name);
                                    specs     = Utils.getNoNil(specs, v.specs);
                                    --
                                    local msg = "";
                                    if (changePrice and v.price ~= price) then
                                        msg = msg .. string.format("price(%d) ", price);
                                        v.price = price;
                                    end;
                                    if (changeSection and v.section ~= section) then
                                        msg = msg .. string.format("section(%s) ", section);
                                        v.section = section;
                                    end;
                                    if (changeRotation and v.rotation ~= rotation) then
                                        msg = msg .. string.format("rotation(%d) ", rotation);
                                        v.rotation = rotation;
                                    end;
                                    if (changeName and v.name ~= name) then
                                        msg = msg .. string.format("name(%s) ", name);
                                        v.name = name;
                                    end;
                                    if (changeSpecs and v.specs ~= specs) then
                                        msg = msg .. string.format("specs(%s) ", specs);
                                        v.specs = specs;
                                    end;
                                    --
                                    if (msg ~= "") then
                                        print("FsIX modified "..modFile.."/"..subItem.."; "..msg);
                                    end;
                                    break;
                                end;
                            end;
                        end;
                    end;

                    i=i+1;
                end;
                self:setInfo(g_i18n:getText("LoadSuccess"));
                rb = true;
            end;
        else
            print("FsIX Failed to load '".. FsIX.inventoryFilename .."', version='".. Utils.getNoNil(version, "nil") .."'. Expected '".. FsIX.version .."'.");
            self:setWarning(g_i18n:getText("LoadFailed"));
        end;
        
        delete(xmlFile);
    else
        print("FsIX Failed to load '".. FsIX.inventoryFilename .."' xmlFile=nil.");
        self:setWarning(g_i18n:getText("LoadFailed"));
    end;
    return rb;
end;    

--
addModEventListener(FsIX);

---
--[[
-- I can not get these console-commands/variables to work. :-(

function DckSetScale(args)
    if (args ~= nil) then
        FsIX.scale = Utils.getNoNil(tonumber(args), FsIX.scale);
    end;
    return "Scale: ".. FsIX.scale;
end;
function DckSetOffX(args)
    if (args ~= nil) then
        FsIX.offsetX = Utils.getNoNil(tonumber(args), FsIX.offsetX);
    end;
    return "OffsetX: ".. FsIX.offsetX;
end;
function DckSetOffY(arg1, arg2)
    print("arg1=".. arg1 ..", arg2=".. arg2);
    if (arg2 ~= nil) then
        FsIX.offsetY = Utils.getNoNil(tonumber(arg2), FsIX.offsetY);
    end;
    return "OffsetY: ".. FsIX.offsetY;
end;

addConsoleCommand("DckSetScale", "Set scale",   "DckSetScale", nil);
addConsoleCommand("DckSetOffX", "Set offset-X", "DckSetOffX", nil);
addConsoleCommand("DckSetOffY", "Set offset-Y", "DckSetOffY", "smurf!");
]]--
