--
-- RadioMod
--
-- (c) by Wagenheber
-- > 26.02.2011 < --
--

print ("  RadioMod loaded");

RadioMod = {};
RadioMod.modDirectory = g_currentModDirectory;
RadioMod.musicPath = getUserProfileAppPath() .. "mods/";

function RadioMod:loadMap(name)

	-- Overlay erstellen
	self.HUD = createImageOverlay(RadioMod.modDirectory .. "image/HUD.png");
	self.smallHUD = createImageOverlay(RadioMod.modDirectory .. "image/smallHUD.png");
	self.volumeMinus = createImageOverlay(RadioMod.modDirectory .. "image/Volume_minus.png");
	self.volumePlus = createImageOverlay(RadioMod.modDirectory .. "image/Volume_plus.png");
	self.nextSong = createImageOverlay(RadioMod.modDirectory .. "image/next.png");
	self.lastSong = createImageOverlay(RadioMod.modDirectory .. "image/last.png");
	self.playSong = createImageOverlay(RadioMod.modDirectory .. "image/play.png");
	self.pauseSong = createImageOverlay(RadioMod.modDirectory .. "image/pause.png");
	self.repeatAll = createImageOverlay(RadioMod.modDirectory .. "image/repeat_all.png");
	self.repeatOne = createImageOverlay(RadioMod.modDirectory .. "image/repeat_one.png");
	self.repeatRandom = createImageOverlay(RadioMod.modDirectory .. "image/repeat_random.png");
	self.repeatIcon = createImageOverlay(RadioMod.modDirectory .. "image/repeat_icon.png");
	self.volumeOverlay0 = createImageOverlay(RadioMod.modDirectory .. "image/volume0.png");
	self.volumeOverlay1 = createImageOverlay(RadioMod.modDirectory .. "image/volume1.png");
	self.volumeOverlay2 = createImageOverlay(RadioMod.modDirectory .. "image/volume2.png");
	self.volumeOverlay3 = createImageOverlay(RadioMod.modDirectory .. "image/volume3.png");
	self.volumeOverlay4 = createImageOverlay(RadioMod.modDirectory .. "image/volume4.png");
	self.volumeOverlay5 = createImageOverlay(RadioMod.modDirectory .. "image/volume5.png");
	
	-- Radio - Variablen deklarieren
	self.volume = 10;																-- Lautstrke
	self.active = false;															-- Radio ein / aus
	self.smallHUDactive = false;													-- Zusatz HUD ein / aus
	self.radioName = "Agrar FM"														-- legt Radionamen fest
	self.fileNumber = 0																-- legt gesamte Dateizahl fest
	self.SongRepeat = "all"															-- Einzelsongwiederholung
	self.SongPaused = false															-- Wiedergabepause
	self.usefulFiles = false														-- WAV oder OGG Dateien vorhanden
	self.hideHUD = false															-- zeigt / versteckt HUD (keine Auswirkung auf Funktion)
	
	-- Song - Variablen anlegen
	self.SongFile = {};			-- Dateinamen
	self.SongName = {};			-- Titelnamen
	self.SongDuration = {};		-- Dauer
	self.Song = {};				-- Shell fr Create Funktion
	songI = 0;					-- ID fr Tables
	
	-- Song - Variablen fllen
	getFiles(RadioMod.musicPath, "getWavAndOgg", self);

	-- Tastenbelegung abfragen
	self.key_switch = "Strg + " .. RadioMod:getShortKeyName(InputBinding.RADIO_switch);
	self.key_nextSong = "Strg + " .. RadioMod:getShortKeyName(InputBinding.RADIO_nextSong);
	self.key_lastSong = "Strg + " .. RadioMod:getShortKeyName(InputBinding.RADIO_lastSong);
	self.key_Volume_plus = "Strg + " .. RadioMod:getShortKeyName(InputBinding.RADIO_Volume_plus);
	self.key_Volume_minus = "Strg + " .. RadioMod:getShortKeyName(InputBinding.RADIO_Volume_minus);
	self.key_play_or_pause = "Strg + " .. RadioMod:getShortKeyName(InputBinding.RADIO_play_or_pause);
	self.key_repeat = "Strg + " .. RadioMod:getShortKeyName(InputBinding.RADIO_repeat);
		
end;

function RadioMod:getWavAndOgg(fileName, Ordner) 

	if Ordner == false and (string.find(fileName, ".wav") ~= nil or string.find(fileName, ".ogg") ~= nil) then
		songI = songI + 1;
		self.fileNumber = self.fileNumber + 1;	
		self.SongFile[songI] = fileName;
		
		fileName = string.gsub(fileName, "", g_i18n:getText("ae"));
		fileName = string.gsub(fileName, "", g_i18n:getText("oe"));
		fileName = string.gsub(fileName, "", g_i18n:getText("ue"));
		fileName = string.gsub(fileName, "", g_i18n:getText("Ae"));
		fileName = string.gsub(fileName, "", g_i18n:getText("Oe"));
		fileName = string.gsub(fileName, "", g_i18n:getText("Ue"));
		fileName = string.gsub(fileName, "", g_i18n:getText("ss"));	
		
		self.SongName[songI] = fileName;
		self.usefulFiles = true;
	end;

end;

function RadioMod:getShortSongName(SongName)

	if string.len(SongName) > 18 then
		SongName = string.sub(SongName, 1, 18) .. "...";
	end;
	return SongName;

end;

function RadioMod:deleteMap()

	if self.SongFile[1] ~= nil then
		stopSample(self.Song[songI]);
	end;
	
end;

function RadioMod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RadioMod:keyEvent(unicode, sym, modifier, isDown)

	-- Lautstrke erhhen
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_Volume_plus) then
		if self.volume <= 8 then
			self.volume = self.volume + 2;
			setSampleVolume(self.Song[songI], self.volume/10);
		end;
	end;
	
	-- Wdh. Modus
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_repeat) then
		if self.SongRepeat == "all" then
			self.SongRepeat = "one";
		elseif self.SongRepeat == "one" then
			self.SongRepeat = "random";
		elseif self.SongRepeat == "random" then
			self.SongRepeat = "all";
		end;
	end;
	
	-- Lautstrke verringern
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_Volume_minus) then
		if self.volume >= 2 then
			self.volume = self.volume - 2;
			setSampleVolume(self.Song[songI], self.volume/10);
		end;
	end;
	
	-- Radio ein / aus
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_switch) then
		stopSample(self.Song[songI]);
		songI = 1
		self.active = not self.active;
		if self.active == true then
			RadioMod:loadSong(songI);			
			playSample(self.Song[songI], 1, self.volume/10, 0);
		else
			stopSample(self.Song[songI]);
			RadioMod:unloadSong(songI);
		end;
		self.SongOffset = 0;
		self.SongPaused = false
	end;
	
	-- Kleine HUD ein / aus
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_smallHUD) then
		self.smallHUDactive = not self.smallHUDactive;
	end;
	
	-- Pause
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_play_or_pause) then
		self.SongPaused = not self.SongPaused
		if self.SongPaused == true then
			stopSample(self.Song[songI]);
		else
			playSample(self.Song[songI], 1, self.volume/10, self.SongOffset);
		end;
	end;
	
	-- Nchster Song
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_nextSong) then
		stopSample(self.Song[songI]);
		RadioMod:unloadSong(songI);
		if songI < self.fileNumber then
			songI = songI + 1;
		else
			songI = 1
		end;
		self.SongOffset = 0;
		self.SongPaused = false
		RadioMod:loadSong(songI);
		playSample(self.Song[songI], 1, self.volume/10, 0);
	end;
	
	-- Vorheriger Song
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.RADIO_lastSong) then
		stopSample(self.Song[songI]);
		RadioMod:unloadSong(songI);
		if songI > 1 then
			songI = songI - 1;
		else
			songI = self.fileNumber
		end;
		self.SongOffset = 0;
		self.SongPaused = false
		RadioMod:loadSong(songI);
		playSample(self.Song[songI], 1, self.volume/10, 0);
	end;

end;

function RadioMod:remainingSeconds(offset, duration)

	minutes = math.floor(((duration - offset) / 60) / 1000);
	seconds = math.floor(((duration - offset) / 1000) - (minutes * 60));

	if seconds < 10 then
		seconds = "0" .. seconds;
	end;
	
	return seconds;
	
end;

function RadioMod:remainingMinutes(offset, duration)

	minutes = math.floor(((duration - offset) / 60) / 1000);
	return minutes;
	
end;

function RadioMod:unloadSong(songI)

	if self.usefulFiles == true then
		delete(self.Song[songI]);
		self.Song[songI] = nil;
	end;
end;

function RadioMod:loadSong(songI)

	if self.usefulFiles == true then
		self.Song[songI] = createSample("Song" .. songI);
		loadSample(self.Song[songI], RadioMod.musicPath .. self.SongFile[songI], false);
		self.SongDuration[songI] = getSampleDuration(self.Song[songI]);
	end;
	
end;

function RadioMod:update(dt)

		-- Songs nacheinander abspielen
		if self.active == true and self.usefulFiles == true then	

			if self.SongPaused == false then
				self.SongOffset = self.SongOffset + dt;
			end;
			
			if self.SongDuration[songI] <= self.SongOffset then
				if self.SongRepeat == "all" then
					stopSample(self.Song[songI]);
					RadioMod:unloadSong(songI);
					if songI < self.fileNumber then
						songI = songI + 1;
					else
						songI = 1
					end;
					self.SongOffset = 0;
					RadioMod:loadSong(songI);
					playSample(self.Song[songI], 1, self.volume/10, 0);
				elseif self.SongRepeat == "one" then
					stopSample(self.Song[songI]);
					self.SongOffset = 0;
					playSample(self.Song[songI], 1, self.volume/10, 0);
				elseif self.SongRepeat == "random" then
					songI = math.random(1, self.fileNumber);
					self.SongOffset = 0;
					RadioMod:loadSong(songI);
					playSample(self.Song[songI], 1, self.volume/10, 0);
				end;
			end;	
		elseif self.usefulFiles == false and FirstStart.FirstTimeRun == false then
			g_currentMission:addWarning(g_i18n:getText("ERROR"));
		end;
		
end;
	
function RadioMod:getShortKeyName(key)

	keyName = InputBinding.getKeyNamesOfDigitalAction(key);
	keyName = string.gsub(keyName, g_i18n:getText("key"), "");
	keyName = string.sub(keyName, 2);
	keyName = string.gsub(keyName, "NUMPAD", "NUM");
	return keyName;
	
end;

function RadioMod:draw()

		if self.active == true and self.usefulFiles == true and self.hideHUD == false then	
		
			-- HUDs
			renderOverlay(self.HUD, 0.0, 0.0, 1, 1);
			setTextColor(0, 0, 0, 1);		
			renderText(0.510, 0.925, 0.03, self.radioName);		
			renderText(0.655, 0.94, 0.015, songI .. "/" .. self.fileNumber);
			renderText(0.515, 0.91, 0.015, RadioMod:getShortSongName(self.SongName[songI]) .. " (" .. RadioMod:remainingMinutes(self.SongOffset, self.SongDuration[songI]) .. ":" .. RadioMod:remainingSeconds(self.SongOffset, self.SongDuration[songI]) .. ")");		
			
			if self.smallHUDactive == true then
				renderText(0.4, 0.85, 0.015, "Tastenbelegung:");
				renderOverlay(self.smallHUD, 0.0, 0.0, 1, 1);
				-- Erste Spalte
				renderOverlay(self.pauseSong, 0.39, 0.83, 0.015, 0.015);
				renderText(0.41, 0.83, 0.015, self.key_play_or_pause);
				renderOverlay(self.playSong, 0.39, 0.81, 0.015, 0.015);
				renderText(0.41, 0.81, 0.015, self.key_play_or_pause);
				-- Zweite Spalte
				renderOverlay(self.nextSong, 0.48, 0.83, 0.015, 0.015);
				renderText(0.5, 0.83, 0.015, self.key_nextSong);
				renderOverlay(self.lastSong, 0.48, 0.81, 0.015, 0.015);
				renderText(0.5, 0.81, 0.015, self.key_lastSong);
				-- Erste Zeile
				renderOverlay(self.volumePlus, 0.39, 0.79, 0.015, 0.015);
				renderText(0.41, 0.79, 0.015, self.key_Volume_plus);
				renderOverlay(self.volumeMinus, 0.48, 0.79, 0.015, 0.015);
				renderText(0.5, 0.79, 0.015, self.key_Volume_minus);
				-- Zweite Zeile
				renderOverlay(self.repeatIcon, 0.39, 0.77, 0.015, 0.015);
				renderText(0.41, 0.77, 0.015, self.key_repeat);	
			end;
			
			-- Lautstrke / Pause
			if self.SongPaused == false then
				if self.volume == 10 then
					renderOverlay(self.volumeOverlay5, 0.47, 0.9125, 0.05, 0.05);
				elseif self.volume == 8 then
					renderOverlay(self.volumeOverlay4, 0.47, 0.9125, 0.05, 0.05);
				elseif self.volume == 6 then
					renderOverlay(self.volumeOverlay3, 0.47, 0.9125, 0.05, 0.05);
				elseif self.volume == 4 then
					renderOverlay(self.volumeOverlay2, 0.47, 0.9125, 0.05, 0.05);
				elseif self.volume == 2 then
					renderOverlay(self.volumeOverlay1, 0.47, 0.9125, 0.05, 0.05);
				end;
			else
				renderOverlay(self.pauseSong, 0.465, 0.91, 0.04, 0.04);
			end;
			
			-- Wdh. Modus
			if self.SongRepeat == "all" then
				renderOverlay(self.repeatAll, 0.61, 0.93, 0.04, 0.04);
			elseif self.SongRepeat == "one" then
				renderOverlay(self.repeatOne, 0.61, 0.93, 0.04, 0.04);
			elseif self.SongRepeat == "random" then
				renderOverlay(self.repeatRandom, 0.61, 0.93, 0.04, 0.04);
			end;
		end;
		
end;

-- Console Commands --

function RadioMod:setName(name)

	if name ~= nil then
	
		name = string.gsub(name, "_", " ");
		name = string.gsub(name, ":ae:", g_i18n:getText("ae"));
		name = string.gsub(name, ":oe:", g_i18n:getText("oe"));
		name = string.gsub(name, ":ue:", g_i18n:getText("ue"));
		name = string.gsub(name, ":Ae:", g_i18n:getText("Ae"));
		name = string.gsub(name, ":Oe:", g_i18n:getText("Oe"));
		name = string.gsub(name, ":Ue:", g_i18n:getText("Ue"));
		name = string.gsub(name, ":ss:", g_i18n:getText("ss"));	
		
		self.radioName = name;
		return "Changed name to " .. name;
	else
		return "Error: No argument specified. Usage: RadioSetName newName";
	end;
	
end;

function RadioMod:closeHUD()

	self.hideHUD = not self.hideHUD;
	if self.hideHUD == true then
		return "The radio is visible now!"
	else
		return "The radio is not visible now!"
	end;
	
end;

function RadioMod:showTrackName()

	if self.active == true and self.usefulFiles == true then
		return self.SongName[songI];
	else
		return "The radio is not active!"
	end;
	
end;

function RadioMod:goToSong(songNumber)

	if tonumber(songNumber) ~= nil and tonumber(songNumber) >= 1 and tonumber(songNumber) <= self.fileNumber and self.usefulFiles == true then
		stopSample(self.Song[songI]);
		RadioMod:unloadSong(songI);
		songI = tonumber(songNumber);
		self.SongOffset = 0;
		RadioMod:loadSong(songI);
		playSample(self.Song[songI], 1, self.volume/10, 0);
		return "Jumped to song no. " .. tostring(songNumber);
	else
		return "Error: No or invalid argument specified. Usage: RadioGoToSong songNumber";
	end;
	
end;

function RadioMod:showAllTrackNames()
	
	if self.usefulFiles == true then
		print(" ");
		print("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
		for i = 1, self.fileNumber, 1 do
			print(i .. ": " .. self.SongName[i]);
		end;
		print("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
		print("Move with PICTURE UP / PICTURE DOWN")
		print("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
		return " ";
	else
		return "The radio is not active!";
	end;
	
end;

addConsoleCommand("RadioSetName", "Changes the name of the radio", "setName", RadioMod);
addConsoleCommand("RadioCloseHUD", "Hides the HUD of the radio", "closeHUD", RadioMod);
addConsoleCommand("RadioShowTrackName", "Shows the current trackname of the radio", "showTrackName", RadioMod);
addConsoleCommand("RadioGoToSong", "Jumps to the specified song of the radio", "goToSong", RadioMod);
addConsoleCommand("RadioShowAllTrackNames", "Lists all songs of the radio", "showAllTrackNames", RadioMod);

addModEventListener(RadioMod);