--
-- HeaderSpecialization.lua
-- Specialization for Headers - Fixes the inability of The Forage Harvesters to reset fruittype.
--
-- @author  Ellinor Strm
-- @date  10/10/27
--

HeaderSpecialization = {};

function HeaderSpecialization.prerequisitesPresent(specializations)
    return true;
end;

function HeaderSpecialization:load(xmlFile)
	self.av = {};
	self.resetFruit = false;
end;

function HeaderSpecialization:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HeaderSpecialization:keyEvent(unicode, sym, modifier, isDown)
end;

function HeaderSpecialization:update(dt)
	if self.av.isThreshing then
		if self.resetFruit == false then
			self.resetFruit = true;
		end;
	else
		if self.resetFruit == true then
			self.av.currentGrainTankFruitType = 0;
			self.resetFruit = false;
		end;
	end;
end;

function HeaderSpecialization:draw()
end;

function HeaderSpecialization:onAttach(attacherVehicle)
	attacherVehicle.currentGrainTankFruitType = 0;
	self.av = attacherVehicle;
end;

function HeaderSpecialization:onDetach()
	self.av.currentGrainTankFruitType = 0;
end;

function HeaderSpecialization:delete()
end;