--
-- Ford 8340 Extra Weights
--
-- author  Mythos
-- date  23/01/2012
-- www.Virtual-Farmers.gr
-- Copyright (C) ARM Team, All Rights Reserved.

extraWeights = {};

function extraWeights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:load(xmlFile)

	self.MpEvent= SpecializationUtil.callSpecializationsFunction("MpEvent");

	self.extraWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraWeights#count"), 0);
	self.weights = {};
    for i=1, self.extraWeights do
        local weightnamei = string.format("vehicle.extraWeights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	self.singleWeight = 0;
	
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 40);
	self.singleWeight = (self.maxWeight / self.extraWeights);
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:delete()
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:keyEvent(unicode, sym, modifier, isDown)
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:update(dt)
	
	if self:getIsActiveForInput() and self:getIsActive() then
	
		if InputBinding.hasEvent(InputBinding.WEIGHT_F4S) then
			self:MpEvent(2);
		end;
		
		
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:updateTick(dt)
	if self:getIsActive() then
		
		if self.weights ~= nil then
		    if self.currentWeight ~= self.controlWeight then
		        self.controlWeight = self.currentWeight;
			
			    if self.currentWeight > 0 then
		            self:MpEvent(1, true);
				else
					self:MpEvent(1, false);
			    end;
		    end;

			if self.emptyMass == nil then
				self.emptyMass = getMass(self.components[1].node);
				self.currentMass = self.emptyMass;
			end;
			local newMass = self.emptyMass + self.currentWeight;
			if newMass ~= self.currentMass then
				setMass(self.components[1].node, newMass);
				self.currentMass = newMass;
				for k,v in pairs(self.components) do
					if v.node == self.components[1].node then
						if v.centerOfMass ~= nil then
							setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
						end;
						break;
					end;
				end;
			end;
		end;
	
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:MpEvent(mode, state, noEventSend)
	extraWeightsEvent.sendEvent(self, mode, state, noEventSend);
	
	if mode == 1 then
		if state then
			for i = 1, self.extraWeights do
				if i * self.singleWeight <= self.currentWeight then
					setVisibility(self.weights[i], true);
				end;
			end;
		else
			for i = 1, self.extraWeights do
				setVisibility(self.weights[i], false);
			end;
		end;
	elseif mode == 2 then
		if self.currentWeight >= self.maxWeight then
			self.currentWeight = 0;
		else
			self.currentWeight = self.currentWeight + self.singleWeight;
		end;
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.currentWeight = Utils.getNoNil(getXMLInt(xmlFile, key.."#curW"),0);
		if self.currentWeight > 0 then
            self:MpEvent(1, true);
		else
			self:MpEvent(1, false);
	    end;
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'curW="'..tostring(self.currentWeight)..'"';
	local nodes = nil;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:draw()
	g_currentMission:addHelpButtonText("Counterweight: " ..string.format("%d kg", self.currentWeight*10), InputBinding.WEIGHT_F4S);
end;

