--
-- self
-- Class for all self
--
-- @author  Jack
-- @date  01/04/09
--
-- Copyright (C) Jack

AgroX720 = {};

function AgroX720.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function AgroX720:load(xmlFile)

	local nummarkAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.markAreas#count"), 0);
    self.markAreas = {}
    for i=1, nummarkAreas do
        self.markAreas[i] = {};
        local areanamei = string.format("vehicle.markAreas.markAreas%d", i);
        self.markAreas[i].point = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#pointIndex"));
        self.markAreas[i].width = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#width"), 0.55)
        self.markAreas[i].height = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#height"), 0.25)
    end;
end;

function AgroX720:keyEvent(unicode, sym, modifier, isDown)

end;

function AgroX720:update(dt)

	if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.FIELDMARKER_mark) then
		self.markOn = not self.markOn;
	end;	
	if self.markOn then		
		for k, markAreas in pairs(self.markAreas) do
	        local x,y,z = getWorldTranslation(markAreas.point);
	        local w = markAreas.width;
	        local h = markAreas.height;
			local x1 = x + h/2
			local x2 = x - h/2
			local z1 = z + w/2
			local z2 = z - w/2			
			Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 5, x1, z2, x1, z1, x2, z2);
			Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
			Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
		end;
	end;
	
end;

function AgroX720:draw()

end;

function AgroX720:onEnter()

end;

function AgroX720:onLeave()
	
end;

function AgroX720:delete()

end;

function AgroX720:mouseEvent(posX, posY, isDown, isUp, button)

end;

function key_convert(key)

end;

function AgroX720:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	self.markOn = false;
	local mark = Utils.getNoNil(getXMLString(xmlFile, key.."#mark"),"false");
	if mark == "false" and not resetVehicles then
		self.markOn = false; 
	elseif mark == "true" then
		self.markOn = true;
	end; 
	
    return BaseMission.VEHICLE_LOAD_OK;
end;
