
-- by modelleicher
--

FendtInfoHud = {};

function FendtInfoHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function FendtInfoHud:load(xmlFile)


	-- Fendt Info Hud --
	self.hudFendtInfoPosX = 0.81;
    self.hudFendtInfoWidth = 0.18;
    self.hudFendtInfoPosY = 0.53;
    self.hudFendtInfoHeight = 0.36;

	self.infoPanelFendtInfoPath = Utils.getFilename("Hud.png", self.baseDirectory);
	self.hudFendtInfoOverlay = Overlay:new("hudFendtInfoOverlay", self.infoPanelFendtInfoPath, self.hudFendtInfoPosX, self.hudFendtInfoPosY, self.hudFendtInfoWidth, self.hudFendtInfoHeight);

	self.showHudFendtInfo = false;


end;

function FendtInfoHud:delete()

     	-- Fendt Info Hud --
    if self.hudFendtInfoOverlay ~= nil then
		self.hudFendtInfoOverlay:delete();
	end;

end;

function FendtInfoHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FendtInfoHud:keyEvent(unicode, sym, modifier, isDown)
end;

function FendtInfoHud:update(dt)

    if self:getIsActiveForInput() and self.isEntered then
    

		if InputBinding.hasEvent(InputBinding.HUDINFO) then
		    self.showHudFendtInfo = not self.showHudFendtInfo;
		end;
		


   		

	end;			 

end;

function FendtInfoHud:draw()


  	if self.showHudFendtInfo and self.isEntered then
		self.hudFendtInfoOverlay:render();
	end;

end;

