
-- by modelleicher
--

Fendt614 = {};

function Fendt614.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fendt614:load(xmlFile)


		 self.steeringlocked = false
		 
		 self.Allrad = false
		 
		 
	-- Allradwelle --
	self.GelenkF = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Allradwelle.GelenkF#index"));
    self.Welle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Allradwelle.Welle#index"));    

	self.RotPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Allradwelle.RotPoint#index"));

		 
		 
	-- Hydraulic --	 
	
	self.Hydr_Rot = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Hydraulic.RotPoint#index"));
	self.Hydr_Top = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Hydraulic.Top#index"));
	self.Hydr_Middle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Hydraulic.Middle#index"));
	
	
	-- Allrad Symbol--
	
	self.hudallrad_yesPosX = 0.85;
    self.hudallrad_yesWidth = 0.1;
    self.hudallrad_yesPosY = 0.29;
    self.hudallrad_yesHeight = 0.12;

	self.infoPanelAllradPath = Utils.getFilename("allrad_symb_yes.png", self.baseDirectory);
	self.hudallrad_yesOverlay = Overlay:new("hudallrad_yesOverlay", self.infoPanelAllradPath, self.hudallrad_yesPosX, self.hudallrad_yesPosY, self.hudallrad_yesWidth, self.hudallrad_yesHeight);

	self.showHudallrad_yes = false;

				 
	-- Steeringlocked Symbole--
		 
	self.hudsteerL_yesPosX = 0.85;
    self.hudsteerL_yesWidth = 0.1;
    self.hudsteerL_yesPosY = 0.21;
    self.hudsteerL_yesHeight = 0.12;
	
	self.infoPanelPath = Utils.getFilename("autorot_symb_yes2.png", self.baseDirectory);
	self.hudsteerL_yesOverlay = Overlay:new("hudsteerL_yesOverlay", self.infoPanelPath, self.hudsteerL_yesPosX, self.hudsteerL_yesPosY, self.hudsteerL_yesWidth, self.hudsteerL_yesHeight);
	
	self.showHudsteerL_yes = false;	 
	
	self.hudsteerL_noPosX = 0.85;
    self.hudsteerL_noWidth = 0.1;
    self.hudsteerL_noPosY = 0.21;
    self.hudsteerL_noHeight = 0.12;
	
	self.infoPanelTwoPath = Utils.getFilename("autorot_symb_yes.png", self.baseDirectory);
	self.hudsteerL_noOverlay = Overlay:new("hudsteerL_noOverlay", self.infoPanelTwoPath, self.hudsteerL_noPosX, self.hudsteerL_noPosY, self.hudsteerL_noWidth, self.hudsteerL_noHeight);
	

	self.showHudsteerL_no = false;	 
			
end;

function Fendt614:delete()

	  -- Allradsymbol --
    if self.hudallradyesOverlay ~= nil then
		self.hudallrad_yesOverlay:delete();
	end;
	  -- Steeringsymbole --
    if self.hudsteerL_yesOverlay ~= nil then
		self.hudsteerL_yesOverlay:delete();
	end;
	if self.hudsteerL_noOverlay ~= nil then
		self.hudsteerL_noOverlay:delete();
	end;
end;

function Fendt614:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fendt614:keyEvent(unicode, sym, modifier, isDown)
end;

function Fendt614:update(dt)

    if self:getIsActiveForInput() and self.isEntered then
    

		if InputBinding.hasEvent(InputBinding.STEERINGLOCKED) then
		   	if self.steeringlocked == false then
		   	   self.steeringlocked = true
		   	else
		   		self.steeringlocked = false
		   	end;
		end;
		
		if InputBinding.hasEvent(InputBinding.ALLRAD) then
		   	if self.Allrad == false then
		   	   self.Allrad = true
		   	else
		   		self.Allrad = false
		   	end;
		end;

		
   		-- Allrad Symbol Status --
   		if self.Allrad == true then
					self.showHudallrad_yes = true
					else
					self.showHudallrad_yes = false
		end;
   		
		
		-- Steeringlocked Symbole Status --
		if self.steeringlocked == true then
		   			self.showHudsteerL_yes = false
		   			self.showHudsteerL_no = true
		else
					self.showHudsteerL_yes = true
		   			self.showHudsteerL_no = false					
		end;

		-- autoRotateBackSpeed -- Automatisches Zurckdrehen ausschalten --
		if self.steeringlocked == false then
		   self.autoRotateBackSpeed	= 2.5
		end;
		
		if self.steeringlocked == true then
		   self.autoRotateBackSpeed = 0.0
		end;

		-- Allrad -- driveMode 2 = Allrad , driveMode 0 = kein Antrieb --
		if self.Allrad == true then
		 	self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2
		else
		 	self.wheels[1].driveMode =0
		 	self.wheels[2].driveMode =0
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2
		end;
		
	   -- Allradwelle --
	   if self.Allrad == true then
	   self.PointRot = getRotation(self.RotPoint)

       setRotation(self.GelenkF,0 ,0 ,self.PointRot);
       setRotation(self.Welle,0 ,0 ,self.PointRot);
	   end;
	   
	   -- Hydraulic --
	   self.Hydr_Rotation = getRotation(self.Hydr_Rot)			 	

       setRotation(self.Hydr_Top,self.Hydr_Rotation ,0 ,0);		
       setRotation(self.Hydr_Middle,-(self.Hydr_Rotation /1.38) ,0 ,0);
				
	end;			 

end;

function Fendt614:draw()

	if self.showHudsteerL_yes and self.isEntered then
		self.hudsteerL_yesOverlay:render();
	end;
	if self.showHudsteerL_no and self.isEntered then
		self.hudsteerL_noOverlay:render();
	end;
		
  	if self.showHudallrad_yes and self.isEntered then
		self.hudallrad_yesOverlay:render();
	end;

end;

