--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.25, 0.02, "Taste Numpad 0: Info Einschalten");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.25, 0.02, "Taste Numpad 0: Info Abschalten");
		renderText(0.72, 0.88, 0.025, "- Fendt 936 Vario Info -");
		renderText(0.72, 0.85, 0.02, "Taste 7 : wheel weights");			
		renderText(0.72, 0.83, 0.02, "Taste l : 4x4");
		renderText(0.72, 0.81, 0.02, "Taste 8 : Turbo");
		renderText(0.72, 0.79, 0.02, "Taste Home : Lighthouses");		
		renderText(0.72, 0.77, 0.02, "Taste Space : Dual wheels");
		renderText(0.72, 0.75, 0.02, "Taste Numpad 7: Attacher");
		renderText(0.72, 0.73, 0.02, "Taste Numpad 4: Attacher");	
		renderText(0.72, 0.71, 0.02, "Taste Numpad 8: Door");
		renderText(0.72, 0.69, 0.02, "Taste Numpad 9: Window");
		renderText(0.72, 0.67, 0.02, "Taste Numpad 6: Working lights rear");
		renderText(0.72, 0.65, 0.02, "Taste Numpad 5: Working lights front");
		renderText(0.72, 0.63, 0.02, "Taste Numpad 1: Left blinker");
		renderText(0.72, 0.61, 0.02, "Taste Numpad 2: Warning lights");
		renderText(0.72, 0.59, 0.02, "Taste Numpad 3: Right blinker");
		renderText(0.72, 0.57, 0.02, "Taste Numpad ENTER: ignition");
        renderText(0.72, 0.55, 0.02, "by Vex90");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




