

Tractor_Rul = {};

function Tractor_Rul.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Tractor_Rul:load(xmlFile)
    
     self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	

    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.worklightsActive = false;

end;

function Tractor_Rul:delete()
end;

function Tractor_Rul:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Tractor_Rul:keyEvent(unicode, sym, modifier, isDown)
	--JD_8530:superClass().keyEvent(self, unicode, sym, modifier, isDown);

	if isDown and sym == Input.KEY_l then
		self.worklightsActive = not self.worklightsActive;
	end;
	
    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;
end;

function Tractor_Rul:update(dt)

	if self.isEntered then
		if self.rundumleuchtenAn == true then
		setVisibility(self.rullight, true);
	else
		setVisibility(self.rullight, false);
	    end;
    	end;
		
	if self.isEntered then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
   end;
   
   if self.isEntered then
   if self.worklightsActive then
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
end;


function Tractor_Rul:onLeave()
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
	Steerable.onLeave(self);
	end;
	
	self.worklightsActive = false;

end;


function Tractor_Rul:draw()
  if self.isEntered then
    if self.rundumleuchtenKey ~= nil then
      if self.rundumleuchtenAn then
        g_currentMission:addExtraPrintText("Taste "..string.upper(string.char(Input[self.rundumleuchtenKey]))..": Rundumleuchte aus");
      else
        g_currentMission:addExtraPrintText("Taste "..string.upper(string.char(Input[self.rundumleuchtenKey]))..": Rundumleuchte ein");
      end;
    end;
  end;

if self.isEntered then
    if self.worklightsActive then
        g_currentMission:addExtraPrintText("Taste L: Arbeitslicht ausschalten");
   else
        g_currentMission:addExtraPrintText("Taste L: Arbeitslicht anschalten");
   end;
end;
end;