--
-- Gear
-- Specialization class for Gears
--
-- @author  MySQly
-- @date  10/06/09
--
-- Copyright (C) MySQly, All Rights Reserved.

Gear = {};

function Gear.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Gear:load(xmlFile)
    self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
    self.brakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.brakelight#index"));
	self.reverselight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reverselight#index"));
	
	
	self.controlpath = Utils.getFilename("Textures/FendtHud.png", self.baseDirectory);
    self.hudjohndeereWidth = 0.200;
    self.hudjohndeereHeight = 0.300;
	self.hudjohndeerePoxX = 0.63;
    self.hudjohndeerePoxY = 1-1.22;
    self.hudjohndeereOverlay = Overlay:new("hudjohndeereControl", self.controlpath, self.hudjohndeerePoxX, self.hudjohndeerePoxY, self.hudjohndeereWidth, self.hudjohndeereHeight);
	self.isAutomatic = false;
	self.gang0 = true;
	self.handbrake = true;
	self.cos = 20000;
	self.druckLevel = 0;

	handbrakeSoundFile = Utils.getFilename("Sound/handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakeSoundFile = Utils.getFilename("Sound/brake2.wav", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("Sound/brake.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    self.brakereleasePlaying = false;
	
	fuelwarningSoundFile = Utils.getFilename("Sound/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	compressorSoundFile = Utils.getFilename("Sound/compressor.wav", self.baseDirectory);
    self.compressorSoundId = createSample("compressorSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	compressorstopSoundFile = Utils.getFilename("Sound/compressorstop.wav", self.baseDirectory);
    self.compressorstopSoundId = createSample("compressorstopSound");
    loadSample(self.compressorstopSoundId, compressorstopSoundFile, false);
    self.compressorstopPlaying = false;
end;

function Gear:delete()

end;

function Gear:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Gear:keyEvent(unicode, sym, modifier, isDown)
	if self.isAutomatic then
		if isDown and sym == Input.KEY_KP_9 then
			if self.reverseGear then
				self.neutral = true;
				self.reverseGear = false;
			elseif self.neutral then
				self.forward = true;
				self.neutral = false;
				self.gang1 = true;
			end;
		end;
		if isDown and sym == Input.KEY_KP_3 then
			if self.forward then
				self.neutral = true;
				self.forward = false;
			elseif self.neutral then
				self.reverseGear = true;
				self.neutral = false;
				self.gang01 = true;
			end;
		end;
	end;
	
	if isDown and sym == Input.KEY_return then
		self.isAutomatic = not self.isAutomatic;
		self.neutral = true;
		self.reverseGear = false;
		self.forward = false;
	end;
	
	if not self.isAutomatic then
		if isDown and sym == Input.KEY_KP_9 then
			if self.gang02 == true then
				self.gang01 = true;
				self.gang02 = false;
			elseif self.gang01 == true then
				self.gang0 = true;
				self.gang01 = false;
			elseif self.gang0 == true then
				self.reverse = false;
				self.gang1 = true;
				self.gang0 = false;
			elseif self.gang1 == true then
				self.gang2 = true;
				self.gang1 = false;
			elseif self.gang2 == true then
				self.gang3 = true;
				self.gang2 = false;
			elseif self.gang3 == true then
				self.gang4 = true;
				self.gang3 = false;
			elseif self.gang4 == true then
				self.gang5 = true;
				self.gang4 = false;
			elseif self.gang5 == true then
				self.gang6 = true;
				self.gang5 = false;
			end;
		end;
	
		if isDown and sym == Input.KEY_KP_3 then
			if self.gang6 == true then
				self.gang5 = true;
				self.gang6 = false;
			elseif self.gang5 == true then
				self.gang4 = true;
				self.gang5 = false;
			elseif self.gang4 == true then
				self.gang3 = true;
				self.gang4 = false;
			elseif self.gang3 == true then
				self.gang2 = true;
				self.gang3 = false;
			elseif self.gang2 == true then
				self.gang1 = true;
				self.gang2 = false;
			elseif self.gang1 == true then
				self.gang0 = true;
				self.gang1 = false;
			elseif self.gang0 == true then
				self.gang01 = true;
				self.reverse = true;
				self.gang0 = false;
			elseif self.gang01 == true then
				self.gang02 = true;
				self.reverse = true;
				self.gang01 = false;
			end;
		end;
	end;
	
	if isDown and sym == Input.KEY_space then
		self.handbrake = not self.handbrake;
		if self.handbrake then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
	end;


end;

function Gear:update(dt)
    if self.isEntered then

        local acceleration = 0;
		local brakeTorque;
        if g_currentMission.allowSteerableMoving and not self.playMotorSound then
           
			if self.reverse then
				if self.gang01 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = -0.06;
					end;
				elseif self.gang02 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = -0.2;
					end;
				end;
			else
				if self.gang0 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0;
					end;
				elseif self.gang1 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.05;
					end;
				elseif self.gang2 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.1;
					end;
				elseif self.gang3 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.2;
					end;
				elseif self.gang4 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.3;
					end;
				elseif self.gang5 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						if self.motor.lastMotorRpm < 1100 then
							acceleration = 0.35;
						elseif self.motor.lastMotorRpm > 1100 then
							acceleration = 0.55;
						end;
					end;
				elseif self.gang6 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						if self.motor.lastMotorRpm < 1100 then
							acceleration = 0.68;
						elseif self.motor.lastMotorRpm > 1100 then
							acceleration = 1.0;
						end;
					end;
				end;
			end;
			
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0, true)
			end;
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0,true)
			end;
			
        if self.fuelFillLevel == 0 then
            acceleration = 0;
        end;
			
		if self.isAutomatic then
			if self.forward then
				self.reverse = false;
				if self.gang6 then
					if self.motor.lastMotorRpm < 1000 then
						self.gang5 = true;
						self.gang6 = false;
					end;
				elseif self.gang5 then
					if self.motor.lastMotorRpm < 950 then
						self.gang4 = true;
						self.gang5 = false;
					elseif self.motor.lastMotorRpm > 1785 then
						self.gang6 = true;
						self.gang5 = false;
					end;
				elseif self.gang4 then
					if self.motor.lastMotorRpm < 950 then
						self.gang3 = true;
						self.gang4 = false;
					elseif self.motor.lastMotorRpm > 1750 then
						self.gang5 = true;
						self.gang4 = false;
					end;
				elseif self.gang3 then
					if self.motor.lastMotorRpm < 950 then
						self.gang2 = true;
						self.gang3 = false;
					elseif self.motor.lastMotorRpm > 1700 then
						self.gang4 = true;
						self.gang3 = false;
					end;
				elseif self.gang2 then
					if self.motor.lastMotorRpm < 950 then
						self.gang1 = true;
						self.gang2 = false;
					elseif self.motor.lastMotorRpm > 1700 then
						self.gang3 = true;
						self.gang2 = false;
					end;
				elseif self.gang1 then
					if self.motor.lastMotorRpm > 1700 then
						self.gang2 = true;
						self.gang1 = false;
					end;
				end;
				self.gang0 = false;			
			end;
			if self.neutral then
				self.gang0 = true;
				self.gang01 = false;
				self.gang02 = false;
				self.gang1 = false;
				self.gang2 = false;
				self.gang3 = false;
				self.gang4 = false;
				self.gang5 = false;
				self.gang6 = false;
				self.reverse = false;
			end;
			if self.reverseGear then
				self.reverse = true;
				if self.gang02 then
					if self.motor.lastMotorRpm < 600 then
						self.gang01 = true;
						self.gang02 = false;
					end;
				elseif self.gang01 then
					if self.motor.lastMotorRpm > 1750 then
						self.gang02 = true;
						self.gang01 = false;
					end;
				end;
				self.gang0 = false;
			end;
		end;
			
			
        end;
		if not self.handbrake then
			brakeTorque = 0.00001;
			self.motor.brakeForce = brakeTorque;
			setVisibility(self.handbrakelight, false);
		else
			if not Input.isKeyPressed(Input.KEY_s) then
				brakeTorque = 50;
				self.motor.brakeForce = brakeTorque;
				acceleration = 0;
				setVisibility(self.handbrakelight, true);
			end;
		end;		
		if Input.isKeyPressed(Input.KEY_s) then
			if not self.druckWarning then
				if not self.braking then
					if self.attachedTrailer then
						self.druckLevel = self.druckLevel -350;
					else
						self.druckLevel = self.druckLevel -250;
					end;
					self.braking = true;
				end;
				brakeTorque = 20;
				setVisibility(self.brakelight, true);
				self.motor.brakeForce = brakeTorque;
				acceleration = 0;
				if not self.brakePlaying then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;		
			end;
		else
			self.brakePlaying = false;
			setVisibility(self.brakelight, false);
			self.braking = false;
			if not self.handbrake then
				brakeTorque = 0.00001;
				self.motor.brakeForce = brakeTorque;
			end;
			if not self.brakereleasePlaying then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;

        if self.firstTimeRun then
            WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
        end;
		
		if self.fuelFillLevel < 50 then
			self.cos = self.cos - dt;
			if self.cos <= 0 then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.cos = 20000;
			end;
		else
			self.cos = 20000;
		end;
		
		local ratio = 0;
		local rpmRange = 0;
		if self.gang02 then
			ratio = 6.5;
			rpmRange = 150;
			setVisibility(self.reverselight, true);
		elseif self.gang01 then
			ratio = 14;
			rpmRange = 300;
			setVisibility(self.reverselight, true);
		elseif self.gang0 then
			ratio = 0;
			setVisibility(self.reverselight, false);
		elseif self.gang1 then
			ratio = 15;
			rpmRange = 250;
			setVisibility(self.reverselight, false);
		elseif self.gang2 then
			ratio = 10;
			rpmRange = 200;
			setVisibility(self.reverselight, false);
		elseif self.gang3 then
			ratio = 7.5;
			rpmRange = 200;
			setVisibility(self.reverselight, false);
		elseif self.gang4 then
			ratio = 5.5;
			rpmRange = 200;
			setVisibility(self.reverselight, false);
		elseif self.gang5 then
			ratio = 4.0;
			rpmRange = 150;
			setVisibility(self.reverselight, false);
		elseif self.gang6 then
			ratio = 2.7;
			rpmRange = 1;
			setVisibility(self.reverselight, false);
		end;
		self.motor.backwardGearRatio = ratio;
		self.motor.forwardGearRatios = {ratio/2,ratio/1.5,ratio};
		self.motor.rpmFadeOutRange = rpmRange;
		
		
		if self.druckLevel >= -1 and self.druckLevel <= 6100 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning then
				playSample(self.compressorSoundId, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorstopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
		if self.compressorStart == false then
			stopSample(self.compressorSoundId, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorstopSoundRunning then
				playSample(self.compressorStopSoundId, 1, 1, 0);
				self.compressorstopSoundRunning = true;
			end;
			if self.druckLevel >= 6099 then
				self.druckLevel = self.druckLevel -(dt/40);
			end;
		end;
		if self.druckLevel <= 6000 then
			self.druckWarning = true;
			self.drucklightActive = true;
		else
			self.druckWarning = false;
			self.drucklightActive = false;
		end;
	end;
end;

function Gear:draw()

	if self.isEntered then
		if self.hudjohndeereOverlay ~= nil then
			self.hudjohndeereOverlay:render();
		end;
		if self.handbrake then
			setTextBold(true);
			setTextColor(1,0,0,1);
			if Input.isKeyPressed(Input.KEY_w) then
				setTextBold(true);
				setTextColor(1,0,0,1);
				renderText(0.3, 0.3, 0.05, "!! Achtung Handbremse fest !!");
			end;
			renderText(0.69, 0.02, 0.015, "(!) Handbremse (!)");
			setTextColor(0,1,0,1); --gruen--
			renderText(0.66, 0.11, 0.02, "Automatik = Enter");
			renderText(0.66, 0.095, 0.02, "Schaltung = NP 9 / 3");
			renderText(0.66, 0.08, 0.02, "Leertaste = Handbremse");
			setTextBold(true);
		end;
		setTextColor(0.83,0.443,0.0549,1); -- orange Rahmen--
		setTextBold(true);
		renderText(0.688, 0.048, 0.015, "Fendt Gangschaltung");
		setTextBold(true);
		if not self.isAutomatic then
			if self.gang02 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.775, 0.03, 0.02, "R2");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.775,0.03, 0.02, "R2");
			end;
			if self.gang01 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.758, 0.03, 0.02, "R1");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.758, 0.03, 0.02, "R1");
			end;
			if self.gang0 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.745, 0.03, 0.02, "N");
			else
				setTextColor(0,0.5,0,1);
				renderText(0.745, 0.03, 0.02, "N");
			end;
			if self.gang1 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.735, 0.03, 0.02, "1");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.735, 0.03, 0.02, "1");
			end;
			if self.gang2 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.725, 0.03, 0.02, "2");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.725, 0.03, 0.02, "2");
			end;
			if self.gang3 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.715, 0.03, 0.02, "3");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.715, 0.03, 0.02, "3");
			end;
			if self.gang4 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.705, 0.03, 0.02, "4");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.705, 0.03, 0.02, "4");
			end;
			if self.gang5 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.695, 0.03, 0.02, "5");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.695, 0.03, 0.02, "5");
			end;
			if self.gang6 then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.685, 0.03, 0.02, "6");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.685, 0.03, 0.02, "6");
			end;
		end;
		if self.isAutomatic then
		    setTextColor(0,0.5,0.5,1);
			renderText(0.684, 0.032, 0.02, "Automatik");
			if self.forward then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.759, 0.032, 0.02, "V");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau--
				renderText(0.759, 0.032, 0.02, "V");
			end;
			if self.neutral then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.774, 0.032, 0.02, "N");
			else
				setTextColor(0,0.5,0,1); --dunkel grn--
				renderText(0.774, 0.032, 0.02, "N");
			end;
			if self.reverseGear then
				setTextColor(1,0.647,0,1); --orange--
				renderText(0.789, 0.032, 0.02, "R");
			else
				setTextColor(0.188,0.188,0.188,1); --braun/grau-- 
				renderText(0.789, 0.032, 0.02, "R");
			end;
		end;
		if self.druckWarning then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.6, 0.03, "Brzdny tlak neni dostatecny!");
		end;
	end;
end;

function Gear:onEnter()
	
end;

function Gear:onLeave()
	self.gang0 = true;
	self.neutral = true;
	self.isAutomatic = false;
	self.gang02 = false;
	self.gang01 = false;
	self.gang1 = false;
	self.gang2 = false;
	self.gang3 = false;
	self.gang4 = false;
	self.gang5 = false;
	self.gang6 = false;
	self.forward = false;
	self.reverseGear = false;
	self.handbrake = true;
	stopSample(self.compressorSoundId, 0, 1, 0);
end;

function Gear:drawGrainLevel(level, capacity, warnPercent)

end;
