--
-- Arbeislicht
-- Specialization for Arbeislicht.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

Arbeislicht = {};

function Arbeislicht.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Arbeislicht:load(xmlFile)
	local numArbeislicht = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Arbeislicht#count"), 0);
    self.Arbeislicht = {};
    for i=1, numArbeislicht do
        local worklightnamei = string.format("vehicle.Arbeislicht.workLight%d", i);
        self.Arbeislicht[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.Arbeislicht[i], false);
    end;
	self.ArbeislichtActive = false;
end;

function Arbeislicht:delete()
	for k, worklight in pairs(self.Arbeislicht) do
		setVisibility(worklight, false);
	end;
	self.ArbeislichtActive = false;
end;

function Arbeislicht:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Arbeislicht:keyEvent(unicode, sym, modifier, isDown)
end;

function Arbeislicht:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.ARBEISLICHT) then
			self.ArbeislichtActive = not self.ArbeislichtActive;
		end;
	
		for k, worklight in pairs(self.Arbeislicht) do
			setVisibility(worklight, self.ArbeislichtActive);
		end;
	end;
end;

function Arbeislicht:onLeave()
	for k, worklight in pairs(self.Arbeislicht) do
		setVisibility(worklight, false);
	end;
	self.ArbeislichtActive = false;
end;

function Arbeislicht:draw()
end;

