--
-- 
-- 
--
-- @author Boembchen big thanks to Sven77b 
-- @date  09/04/09
--
-- Copyright (C) by Boembchen

Fendt614LsaFL = {};

function Fendt614LsaFL.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fendt614LsaFL:load(xmlFile)

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    

    self.mirrors = {};
    self.mirrors[1] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrors.mirror1#index"));
    self.mirrors[2] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrors.mirror2#index"));

    self.drawMirror = getVisibility(self.mirrors[1])
    self.revLimit = 100;
    self.maxRpm3 = self.motor.maxRpm[3];
    self.activeTAJ = 0;

end;

function Fendt614LsaFL:keyEvent(unicode, sym, modifier, isDown)

end;


function Fendt614LsaFL:update(dt)
    if self.isEntered then      



end;

end;

function Fendt614LsaFL:draw()

end;

function Fendt614LsaFL:onEnter()
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function Fendt614LsaFL:onLeave()

end;

function Fendt614LsaFL:delete()
end;


function Fendt614LsaFL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;



