--
-- Beleuchtung v2.7
-- Specialization for additional lights
-- Spezialisierung fr Zusatzbeleuchtung
-- @author  Sven777b
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.
--
-- Hinweis: das kopieren von Sourcecode ist strafbar nach UrhG 2.1


LICHTADDON = {};

function LICHTADDON.prerequisitesPresent(specializations)
		print("specialization beleuchtung v2.7 by Sven777b");
    return true;
end;

function LICHTADDON:load(xmlFile)
		self.IClicht = {};
		self.L = {};
--Rundumleuchten
		self.IClicht["RUNDUMLEUCHTE"] = false;
		local i = 0;
		self.L.rundumleuchten = {};
    self.L.rundumleuchtenAn = false;
    self.L.rundumleuchtenprefix = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rundumleuchten#prefix"),"");
    self.L.rundumleuchtenStayOn = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.rundumleuchten#stayOn"),false);
    self.L.rundumleuchtenFillLevelOn = getXMLInt(xmlFile,"vehicle.rundumleuchten#anFillLevel");
    self.L.rundumleuchtenFillLevelOff = getXMLInt(xmlFile,"vehicle.rundumleuchten#ausFillLevel");
    if self.L.rundumleuchtenFillLevelOn ~= nil and self.L.rundumleuchtenFillLevelOff == nil then
    	self.L.rundumleuchtenFillLevelOff = self.L.rundumleuchtenFillLevelOn;
    end;
		while true do
			local rul = {};
			local objname = string.format("vehicle.rundumleuchten.licht(%d)",i);
      local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
      if rotnode == nil then break; end;
      rul = {};
      rul.rotNode = Utils.indexToObject(self.components, rotnode);
      rul.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
      if(rul.rotNode == nil or rul.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
      else
	      rul.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	      rul.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	      if (rul.source == nil) then
	      	rul.emit = false;
	      else
      		rul.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not rul.emit then
      			setVisibility(rul.source, false);
      		end;
      	end;
      	table.insert(self.L.rundumleuchten, rul);
      end;
      i=i+1;
    end;
    self.L.rundumleuchtenAnz = table.getn(self.L.rundumleuchten);
    self.L.rundumleuchtenFLAlert = false;
--Arbeitslichter
    local i = 0;
    self.L.zusatzlampen = {};
    self.L.zusatzlampenprefix = Utils.getNoNil(getXMLString(xmlFile, "vehicle.zusatzlichter#prefix"),"");
    while true do
    	local objname = string.format("vehicle.zusatzlichter.licht(%d)",i);
    	local index = getXMLString(xmlFile, objname .. "#index");
    	if index == nil then break;	end;
    	local licht = {};
    	licht.index = Utils.indexToObject(self.components,index);
    	if licht.index == nil then
    		print("Error: Index ("..index..") zum Zusatzlicht "..i.." nicht gefunden");
    	else
    		licht.istAn = false;
    		setVisibility(licht.index, false);
    		licht.id = Utils.getNoNil(getXMLString(xmlFile, objname.."#id"),i);
    		licht.stayOn = Utils.getNoNil(getXMLString(xmlFile, objname.."#stayOn"),false);
    		licht.autoOff = Utils.getNoNil(getXMLFloat(xmlFile, objname.."#autoOff"),0)*1000;
    		licht.timer = 0;
    		table.insert(self.L.zusatzlampen, licht);
    		self.IClicht["ZUSATZLICHT"..licht.id] = false;
    	end;
    	i = i + 1;
    end;
    self.L.zusatzlampenAnz = table.getn(self.L.zusatzlampen);
--Positionslichter
		local i=0;
		self.L.poslichter = {};
		self.L.posstrobes = {};
		self.L.posdays = {};
		self.L.poslichterprefix = Utils.getNoNil(getXMLString(xmlFile, "vehicle.positionslichter#prefix"),"");
		self.L.poslichterAn = false;
		self.L.posdaysAn = false;
		while true do
			local objname = string.format("vehicle.positionslichter.licht(%d)",i);
			local index = getXMLString(xmlFile, objname.."#index");
			if index == nil then break; end;
			local licht = {};
			licht.index = Utils.indexToObject(self.components,index);
    	if licht.index == nil then
    		print("Error: Index ("..index..") zum Positionslicht "..i.." nicht gefunden");
    	else
    		setVisibility(licht.index, false);
    		licht.typ = Utils.getNoNil(getXMLString(xmlFile,objname.."#typ"),"perma");
    		if licht.typ == "strobe" then
    			licht.sequences = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, objname.."#sequenz"),"1"))};
    			table.insert(self.L.posstrobes,licht);
    		elseif licht.typ == "daylight" then
    			table.insert(self.L.posdays,licht);
    		else
    			table.insert(self.L.poslichter,licht);
    		end;
    	end;
    	i=i+1;
    end;
    self.L.poslichterAnz = table.getn(self.L.poslichter);
    self.L.posstrobesAnz = table.getn(self.L.posstrobes);
    self.L.posdaysAnz = table.getn(self.L.posdays);
--Verstellungen
		local i=0;
		self.L.verstell = {};
		while true do
			local objname = string.format("vehicle.verstellungen.licht(%d)",i);
			local index = getXMLString(xmlFile, objname.."#index");
			if index == nil then break; end;
			local obj = {};
			obj.index = Utils.indexToObject(self.components,index);
			if obj.index == nil then
				print("Error: Index ("..index..") zum Licht "..i.." nicht gefunden");
			else
				obj.key1 = Input[getXMLString(xmlFile, objname.."#taste1")];
				if obj.key1 == nil then
					print("Error: taste1 fuer Verstellung "..i.." nicht gefunden"); break;
				end;
				obj.key2 = Input[getXMLString(xmlFile, objname.."#taste2")];
				if obj.key2 == nil then
					print("Error: taste2 fuer Verstellung "..i.." nicht gefunden"); break;
				end;
				obj.min = Utils.getNoNil(getXMLFloat(xmlFile, objname.."#min"),0);
				obj.max = Utils.getNoNil(getXMLFloat(xmlFile, objname.."#max"),0);
				obj.step = Utils.getNoNil(getXMLFloat(xmlFile, objname.."#step"),0.1);
				obj.axis = Utils.getNoNil(getXMLInt(xmlFile, objname.."#axis"),1);
				table.insert(self.L.verstell,obj);
			end;
			i=i+1;
		end;
		self.L.verstellAnz = table.getn(self.L.verstell);
--Fernlichschaltung
		local IndexAuf = getXMLString(xmlFile, "vehicle.fernlicht#aufblend");
		local IndexAb  = getXMLString(xmlFile, "vehicle.fernlicht#abblend");
		if IndexAuf ~= nil and IndexAb ~= nil then
			self.L.fernlicht = {};
			self.L.fernlicht.aufblend = Utils.indexToObject(self.components,IndexAuf);
			self.L.fernlicht.abblend  = Utils.indexToObject(self.components,IndexAb );
			self.L.fernlicht.state = 0;
			self.IClicht["LICHT"] = false;
		end;
--Blinker
		local blinkerL = getXMLString(xmlFile, "vehicle.blinker#links");
		local blinkerR = getXMLString(xmlFile, "vehicle.blinker#rechts");
		if blinkerL ~= nil and blinkerR ~= nil then
			self.L.blinker = {};
			self.L.blinker.L = Utils.indexToObject(self.components, blinkerL);
			self.L.blinker.R = Utils.indexToObject(self.components, blinkerR);
			self.L.blinker.prefix = Utils.getNoNil(getXMLString(xmlFile,"vehicle.blinker#prefix"),"");
			self.L.blinker.stayOn = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.blinker#stayOn"),false);
			self.L.blinker.autoOff = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.blinker#autoOff"),false);
			self.L.blinker.dauer = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.blinker#dauer"),750);
			self.L.blinker.lastRT = 0;
			self.L.blinker.state = 0;
			self.L.blinker.timer = 0;
			self.IClicht["BLINKER_L"] = false;
			self.IClicht["BLINKER_R"] = false;
			self.IClicht["BLINKER_W"] = false;

			local blinkSound = getXMLString(xmlFile, "vehicle.blinkSound#file");
			if blinkSound ~= nil and blinkSound ~= "" then
			    blinkSound = Utils.getFilename(blinkSound, self.baseDirectory);
			    self.L.blinker.sound = createSample("blinkSound");
			    self.L.blinker.volume = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.blinkSound#volume"),1.0);
			    self.L.blinker.slow = Utils.getNoNil(getXMLBool(xmlFile,"vehicle.blinkSound#slow"),false);
			    self.L.blinker.phase = true;
			    self.L.blinker.sndEnabled = false;
			    loadSample(self.L.blinker.sound, blinkSound, false);
			end;
		end;

--Bremslicht
		local bremslicht = getXMLString(xmlFile, "vehicle.bremslicht#index");
		if bremslicht ~= nil then
			self.L.bremslicht = Utils.indexToObject(self.components, bremslicht);
			self.L.bremslichtAn = false;
			self.L.bremst = false;
		end;
--Rckfahr
		local revlicht = getXMLString(xmlFile, "vehicle.rueckfahrlicht#index");
		if revlicht ~= nil then
			self.L.revlicht = Utils.indexToObject(self.components, revlicht);
			self.L.revlichtAn = false;
		end;
		
--Helferlicht
		self.L.helferLichter = {};
		i=0;
		while true do
			local licht = {};
			local objname = string.format("vehicle.helfermodus.licht(%d)",i);
			local index = getXMLString(xmlFile, objname.."#index");
			if index == nil then break; end;
			licht.index = Utils.indexToObject(self.components, index);
			licht.state = Utils.getNoNil(getXMLBool(xmlFile, objname.."#ein"),false);
			table.insert(self.L.helferLichter,licht);
			i=i+1;
		end;
		self.L.nachtlicht = Utils.getNoNil(getXMLBool(xmlFile,"vehicle.helfermodus#nachtlicht"),false);
		self.L.nachtlichtAn = false;
		self.L.lichtStayOn = Utils.getNoNil(getXMLBool(xmlFile,"vehicle.lights#stayOn"),false);
		
--IC
		if SpecializationUtil.hasSpecialization(InteractiveButtons, self.specializations) then
			Button.doActionOrig = Button.doAction;
			Button.doAction = function(self,dt)
				self.vehicle.IClicht[self.event] = true;
				Button.doActionOrig(self,dt);
			end;
		end;

end;

function LICHTADDON:delete()
	if self.L.rundumleuchtenAnz > 0 then
		self.L.rundumleuchtenAn = false;
		for i=1,self.L.rundumleuchtenAnz do
			setVisibility(self.L.rundumleuchten[i].light, false);
		end;
	end;
	if self.L.zusatzlampenAnz > 0 then
		for i=1,self.L.zusatzlampenAnz do
			self.L.zusatzlampen[i].istAn = false;
			setVisibility(self.L.zusatzlampen[i].index , false);
		end;
	end;
	if self.L.blinker then
		if self.L.blinker.state > 0 then
			self.L.blinker.state = 0;
			setVisibility(self.L.blinker.L , false);
			setVisibility(self.L.blinker.R , false);
			if self.L.blinker.sndEnabled then
				stopSample(self.L.blinker.sound);
			end;
		end;
	end;
	if self.L.fernlicht then
		if self.L.fernlicht.state > 0 and not self.lightsActive then
			self.L.fernlicht.state = 0;
			setVisibility(self.L.fernlicht.aufblend , false);
			setVisibility(self.L.fernlicht.abblend  , false);
		end;
	end;
end;

function LICHTADDON:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LICHTADDON:keyEvent(unicode, sym, modifier, isDown)
end;

function LICHTADDON:update(dt)
	if self:getIsActiveForInput() then
		--Rundumleuchten
		if self.L.rundumleuchtenAnz > 0 then
	    if InputBinding.hasEvent(InputBinding[self.L.rundumleuchtenprefix..'RUNDUMLEUCHTE']) or self.IClicht['RUNDUMLEUCHTE'] then
	    	self.L.rundumleuchtenAn = not self.L.rundumleuchtenAn;
	    	self.IClicht['RUNDUMLEUCHTE'] = false;
	    	-- syncronisieren mit Zugfahrzeug
	    	if self.attacherVehicle then
	    		if self.attacherVehicle.rundumleuchtenAnz ~= nil then
	    			self.L.rundumleuchtenAn = self.attacherVehicle.rundumleuchtenAn;
	    		end;
	    	end;
	      for i=1, self.L.rundumleuchtenAnz do
	        setVisibility(self.L.rundumleuchten[i].light, self.L.rundumleuchtenAn);
	      end;
	    end;
	  end;
	  
	  --Zusatzlichter
	  if self.L.zusatzlampenAnz > 0 then
	  	for i=1, self.L.zusatzlampenAnz do
	  		local licht = self.L.zusatzlampen[i];
	  		if InputBinding.hasEvent(InputBinding[self.L.zusatzlampenprefix..'ZUSATZLICHT'..licht.id]) or self.IClicht['ZUSATZLICHT'..licht.id] then
	  			self.IClicht['ZUSATZLICHT'..licht.id] = false;
	  			licht.istAn = not licht.istAn;
	  			setVisibility(licht.index, licht.istAn);
	  		end;
	  		if licht.autoOff > 0 then
	  			if licht.istAn then
	  				licht.timer = licht.timer + dt;
	  				if licht.timer > licht.autoOff then
	  					licht.timer = 0;
	  					licht.istAn = false;
	  					setVisibility(licht.index, licht.istAn);
	  				end;
	  			elseif licht.timer > 0 then 
	  				licht.timer = 0;
	  			end;
	  		end;
	  	end;
	  end;
	  
	  --Positionslichter
	  if not self.L.poslichterAn then
	  	self.L.poslichterAn = true;
	  	if self.L.poslichterAnz > 0 then
				for i=1,self.L.poslichterAnz do
					setVisibility(self.L.poslichter[i].index,true);
				end;
			end;
		end;
		if self.lightsActive == self.L.posdaysAn then
			self.L.posdaysAn = not self.lightsActive;
			if self.L.posdaysAnz > 0 then
				for i=1,self.L.posdaysAnz do
					setVisibility(self.L.posdays[i].index, self.L.posdaysAn);
				end;
			end;
		end;
		--Verstellung
		if self.L.verstellAnz > 0 then
			for i=1,self.L.verstellAnz do 
				local v = self.L.verstell[i];
				local m = 0;
				if Input.isKeyPressed(v.key1) then
					m = math.rad(dt/1000*v.step);
				elseif Input.isKeyPressed(v.key2) then
					m = math.rad(-dt/1000*v.step);
				end;
				if m ~= 0 then
					local rot = {getRotation(v.index)};
					if (rot[v.axis]+m < math.rad(v.max)) and (rot[v.axis]+m > math.rad(v.min)) then
						local nrot = {0,0,0};
						nrot[v.axis] = m;
						rotate(v.index,unpack(nrot));
					end;
				end;
			end;
		end;
		--Fernlichtschaltung
		if self.L.fernlicht then
			if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) or self.IClicht['LICHT'] then
				self.IClicht['LICHT'] = false;
				self.L.fernlicht.state = self.L.fernlicht.state + 1;
				if self.L.fernlicht.state > 2 then self.L.fernlicht.state = 0; end;
				if self.L.fernlicht.state == 1 then
					self.lightsActive = true;
					self:setLightsVisibility(true);
					setVisibility(self.L.fernlicht.aufblend,false);
					setVisibility(self.L.fernlicht.abblend ,true);
				elseif self.L.fernlicht.state == 2 then
					self.lightsActive = true;
					self:setLightsVisibility(true);
					setVisibility(self.L.fernlicht.aufblend,true);
					setVisibility(self.L.fernlicht.abblend ,false);
				else
					self.lightsActive = false;
					self:setLightsVisibility(false);
					setVisibility(self.L.fernlicht.aufblend,false);
					setVisibility(self.L.fernlicht.abblend ,false);
				end;
			end;
		end;
		--Blinker schaltung
		if self.L.blinker then
			if InputBinding.hasEvent(InputBinding[self.L.blinker.prefix..'BLINKER_L']) or self.IClicht['BLINKER_L'] then
				setVisibility(self.L.blinker.L, false); setVisibility(self.L.blinker.R, false);
				if self.L.blinker.sndEnabled then stopSample(self.L.blinker.sound); self.L.blinker.sndEnabled=false; end;
				self.IClicht['BLINKER_L'] = false;
				self.L.blinker.phase = true;
				if self.L.blinker.state == 1 then self.L.blinker.state = 0; else self.L.blinker.state = 1; end;
			end;
			if InputBinding.hasEvent(InputBinding[self.L.blinker.prefix..'BLINKER_R']) or self.IClicht['BLINKER_R'] then
				setVisibility(self.L.blinker.L, false); setVisibility(self.L.blinker.R, false);
				if self.L.blinker.sndEnabled then stopSample(self.L.blinker.sound); self.L.blinker.sndEnabled=false; end;
				self.IClicht['BLINKER_R'] = false;
				self.L.blinker.phase = true;
				if self.L.blinker.state == 2 then self.L.blinker.state = 0; else self.L.blinker.state = 2; end;
			end;
			if InputBinding.hasEvent(InputBinding[self.L.blinker.prefix..'BLINKER_W']) or self.IClicht['BLINKER_W'] then
				setVisibility(self.L.blinker.L, false); setVisibility(self.L.blinker.R, false);
				if self.L.blinker.sndEnabled then stopSample(self.L.blinker.sound); self.L.blinker.sndEnabled=false; end;
				self.IClicht['BLINKER_W'] = false;
				self.L.blinker.phase = true;
				if self.L.blinker.state == 3 then self.L.blinker.state = 0; else self.L.blinker.state = 3; end;
			end;
			if g_currentMission.currentVehicle == self and self.L.blinker.autoOff then
				if self.L.blinker.state == 1 or self.L.blinker.state == 2 then
					if math.abs(self.rotatedTime) > math.abs(self.maxRotTime/10) and self.L.blinker.lastRT == 0 then 
						self.L.blinker.lastRT = math.abs(self.rotatedTime); 
					end;
					if math.abs(self.rotatedTime) < self.L.blinker.lastRT and self.L.blinker.lastRT ~= 0 then
						self.L.blinker.lastRT = 0;
						self.L.blinker.state = 0;
					end;
				end;
			end;
			
			-- syncronisieren mit Zugfahrzeug
			if self.attacherVehicle then
				if self.attacherVehicle.blinker then
					self.L.blinker.state = self.attacherVehicle.blinker.state;
				end;
			end;
		end;
		--Bremslicht
		if self.L.bremslicht ~= nil then
			local acceleration = 0;
      acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
      if InputBinding.isAxisZero(acceleration) then
          acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
      end;
      if acceleration * self.movingDirection < 0 then
      	self.L.bremst = true;
      else
      	self.L.bremst = false;
      end;
    end;
	end;

  if self:getIsActive() then
		--Strobes
		if self.L.posstrobesAnz > 0 then
			for i=1,self.L.posstrobesAnz do
				local licht = self.L.posstrobes[i];
				if licht.nextseq == nil then licht.nextseq = 1; end;
				if licht.seqtimer == nil then licht.seqtimer = 0; end;
				if licht.seqtimer > licht.sequences[licht.nextseq] then
					local status = getVisibility(licht.index);
					setVisibility(licht.index , not status);
					licht.seqtimer = 0;
					licht.nextseq = licht.nextseq+1;
					if licht.nextseq > table.getn(licht.sequences) then
						licht.nextseq = 1;
					end;
				else
					licht.seqtimer = licht.seqtimer + (dt/1000);
				end;
			end;
		end;

		--AI
		if self.isAITractorActivated then
			if self.L.nachtlicht then
		    if self.L.nachtlichtAn ~= g_currentMission.environment.isSunOn then
						self.lightsActive = self.L.nachtlichtAn;
						self:setLightsVisibility(self.L.nachtlichtAn);
		        self.L.nachtlichtAn = g_currentMission.environment.isSunOn;
		    end;
		  end;
			
			if self.turnStage == 1 then
				if not self.L.bremst then 
					self.L.bremst = true;
					if self.L.blinker then self.L.blinker.state = 3; end;
				end;
			else
				if self.L.bremst then
					self.L.bremst = false;
				end;
			end;
			if self.turnStage == 0 then
				if self.L.blinker then
					if self.L.blinker.state == 3 then
						self.L.blinker.state = 0;
					end;
				end;
			end;
		end;

		--Bremslicht
		if self.L.bremslicht then
			if self.L.bremst ~= self.L.bremslichtAn then
				setVisibility(self.L.bremslicht, self.L.bremst);
				self.L.bremslichtAn = self.L.bremst;
			end;
		end;

    --Rckfahrlicht
    if self.L.revlicht then
    	if self.movingDirection < 0 then
    		if not self.L.revlichtAn then
	    		setVisibility(self.L.revlicht, true);
	    		self.L.revlichtAn = true;
	    	end;
	    else
	    	if self.L.revlichtAn then
	    		setVisibility(self.L.revlicht, false);
	    		self.L.revlichtAn = false;
	    	end;
	    end;
	  end;
	end;

--perma an
	if self.L.rundumleuchtenFillLevelOn and (self.capacity or self.grainTankCapacity or self:getAttachedTrailersFillLevelAndCapacity() ~= nil) then
		local percent = 0;
		if self.capacity then
			percent = self.fillLevel*100/self.capacity;
		elseif self.grainTankCapacity then
			percent = self.grainTankFillLevel*100/self.grainTankCapacity;
		else
			local l,c = self:getAttachedTrailersFillLevelAndCapacity();
			percent = l*100/c;
		end;
		if percent > self.L.rundumleuchtenFillLevelOn and not self.L.rundumleuchtenAn then
			self.L.rundumleuchtenAn = true;
			self.L.rundumleuchtenFLAlert = true;
      for i=1, self.L.rundumleuchtenAnz do
        setVisibility(self.L.rundumleuchten[i].light, self.L.rundumleuchtenAn);
      end;
    end;
    if percent < self.L.rundumleuchtenFillLevelOff and self.L.rundumleuchtenFLAlert then
			self.L.rundumleuchtenAn = false;
			self.L.rundumleuchtenFLAlert = false;
      for i=1, self.L.rundumleuchtenAnz do
        setVisibility(self.L.rundumleuchten[i].light, self.L.rundumleuchtenAn);
      end;
    end;
  end;
	
  if self.L.rundumleuchtenAn then
    for i=1, self.L.rundumleuchtenAnz do
      rotate(self.L.rundumleuchten[i].rotNode, 0, dt*self.L.rundumleuchten[i].speed, 0);
    end;
  end;

	--Blinker
	if self.L.blinker then
		if self.L.blinker.state > 0 then
			self.L.blinker.timer = self.L.blinker.timer + dt;
			if self.L.blinker.timer > self.L.blinker.dauer then
				if self.L.blinker.state == 1 then
					setVisibility(self.L.blinker.L, not getVisibility(self.L.blinker.L));
				elseif self.L.blinker.state == 2 then
					setVisibility(self.L.blinker.R, not getVisibility(self.L.blinker.R));
				else
					local state = not getVisibility(self.L.blinker.L);
					setVisibility(self.L.blinker.L, state);
					setVisibility(self.L.blinker.R, state);
				end;
				if g_currentMission.currentVehicle == self and self.L.blinker.sound then
					if self.L.blinker.phase then
						if self.L.blinker.sndEnabled then stopSample(self.L.blinker.sound); self.L.blinker.sndEnabled=false; end;
						playSample(self.L.blinker.sound,1,self.L.blinker.volume,0);
						self.L.blinker.sndEnabled = true;
					end;
					if self.L.blinker.slow then
						self.L.blinker.phase = not self.L.blinker.phase;
					end;
				end;
				self.L.blinker.timer = 0.1;
			end;
		elseif self.L.blinker.timer ~= 0 then
			setVisibility(self.L.blinker.L, false);
			setVisibility(self.L.blinker.R, false);
			self.L.blinker.timer = 0;
			self.L.blinker.phase = true;
			if self.L.blinker.sndEnabled then stopSample(self.L.blinker.sound); self.L.blinker.sndEnabled=false; end;
		end;
	end;
end;

function LICHTADDON:draw()
    if self.L.rundumleuchtenAnz > 0 and self:getIsActive() then
    	if string.sub(g_i18n:getText(self.L.rundumleuchtenprefix.."rundumleuchte"),0,7) ~= "Missing" then
    		g_currentMission:addHelpButtonText(g_i18n:getText(self.L.rundumleuchtenprefix.."rundumleuchte"), InputBinding[self.L.rundumleuchtenprefix..'RUNDUMLEUCHTE']);
    	end;
    end;
    if self.L.zusatzlampenAnz > 0 and self:getIsActive() then
    		for i=1, self.L.zusatzlampenAnz do
    			if string.sub(g_i18n:getText(self.L.zusatzlampenprefix.."zusatzlicht"..self.L.zusatzlampen[i].id),0,7) ~= "Missing" then
    				g_currentMission:addHelpButtonText(g_i18n:getText(self.L.zusatzlampenprefix.."zusatzlicht"..self.L.zusatzlampen[i].id), InputBinding[self.L.zusatzlampenprefix..'ZUSATZLICHT'..self.L.zusatzlampen[i].id]);
    			end;
    		end;
    end;

end;

function LICHTADDON:onLeave()
	if self.L.rundumleuchtenAnz > 0 then
		if not self.L.rundumleuchtenStayOn then
			self.L.rundumleuchtenAn = false;
			for i=1,self.L.rundumleuchtenAnz do
				setVisibility(self.L.rundumleuchten[i].light, false);
			end;
		end;
	end;
	if self.L.zusatzlampenAnz > 0 then
		for i=1,self.L.zusatzlampenAnz do
			if not self.L.zusatzlampen[i].stayOn then
				self.L.zusatzlampen[i].istAn = false;
				setVisibility(self.L.zusatzlampen[i].index , false);
			end;
		end;
	end;
	if self.L.poslichterAn and self.L.poslichterAnz > 0 then
		self.L.poslichterAn = false;
		for i=1,self.L.poslichterAnz do
			setVisibility(self.L.poslichter[i].index,false);
		end;
	end;
	if self.L.posstrobesAnz > 0 then
		for i=1,self.L.posstrobesAnz do
			self.L.posstrobes[i].seqtimer = 0;
			self.L.posstrobes[i].nextseq = 1;
			setVisibility(self.L.posstrobes[i].index, false);
		end;
	end;
	if self.L.posdaysAn and self.L.posdaysAnz > 0 then
		self.L.posdaysAn = false;
		for i=1,self.L.posdaysAnz do
			setVisibility(self.L.posdays[i].index,false);
		end;
	end;
	for k,v in pairs(self.L.helferLichter) do
		setVisibility(v.index,v.state);
	end;
	if self.L.lichtStayOn then
		if self.L.fernlicht then
			if self.L.fernlicht.state > 0 then
				if self.L.fernlicht.state == 1 then
					self.lightsActive = true;
					self:setLightsVisibility(true);
					setVisibility(self.L.fernlicht.aufblend,false);
				else
					self.lightsActive = true;
					self:setLightsVisibility(true);
					setVisibility(self.L.fernlicht.aufblend,true);
				end;
			else
				self.lightsActive = false;
				self:setLightsVisibility(false);
				setVisibility(self.L.fernlicht.aufblend,false);
			end;
		else
			self.lightsActive = true;
			self:setLightsVisibility(true);
		end;
	end;
end;

function LICHTADDON:startAITractor()
	self.L.nachtlichtAn = not g_currentMission.environment.isSunOn;
end;

function LICHTADDON:onEnter()
	for k,v in pairs(self.L.helferLichter) do
		setVisibility(v.index, not v.state);
	end;
end;

