--
-- Feeder Trailer
-- Class for feed trailer
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Feeder = {};

function Feeder.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Feeder:load(xmlFile)

	self.baleValue = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.bale#value"), 0.0);
	self.triggerCallback = Feeder.triggerCallback;

	local trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bale#trigger"));
	if trigger ~= nil then
		self.trigger = trigger;
		addTrigger(self.trigger, "triggerCallback", self);
	else
		print("Error: Missing bale trigger");
	end;
	
	self.ableCowsEat = true;
	self.eatSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animals#eatSpeed"), 0.0);
end;

function Feeder:delete()
	removeTrigger(self.trigger);
end;

function Feeder:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Feeder:keyEvent(unicode, sym, modifier, isDown)
end;

function Feeder:update(dt)


end;

function Feeder:updateTick(dt)

	if self.isClient then
		local nearestDistance = 5.0;
		local px, py, pz = getWorldTranslation(self.components[1].node);
		for i=1, table.getn(g_currentMission.attachables) do
			local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				local attachable = g_currentMission.attachables[i];		
				if attachable.fruitTypes == self.fruitTypes and attachable.fillLevel ~= nil and attachable ~= self then
					if self.currentFillType ~= attachable.currentFillType and attachable.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
						if self.fillLevel < self.capacity and self.fillLevel > 1 then
							self.currentFillType = attachable.currentFillType;
						end;
					end;
				end;
			end;
		end;
		if self.ableCowsEat then
			local cowsStored = AnimalHusbandry.getNumberOfAnimals();
			if cowsStored > 0 then
				self:setFillLevel(self.fillLevel - (cowsStored / self.eatSpeed), self.currentFillType);
			end;
		end;
	end;

end;

function Feeder:draw()
	if self.isClient then
		if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
			local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
			if fruitType ~= nil then
				g_currentMission:setFruitOverlayFruitType(fruitType);
			end;
		end;
	end;
end;

function Feeder:onAttach(attacherVehicle)
	self.ableCowsEat = false;
end;
 
function Feeder:onDetach()
	self.ableCowsEat = true;
end;

function Feeder:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter or onStay then
		if otherId ~= 0 then
			local object = g_currentMission:getNodeObject(otherId);
			if object ~= nil then
				if object:isa(Bale) then
					if g_currentMission:getIsServer() then
						if (self.fillLevel + self.baleValue) < self.capacity then
							if self.fillLevel > 0 then 
								self:setFillLevel(self.fillLevel + self.baleValue, self.currentFillType);
							else
								self:setFillLevel(self.fillLevel + self.baleValue, Fillable.FILLTYPE_GRASS);
							end;
							object:delete();
						end;
					end;
				end;
			end;
		end;
	end;
end;