--
-- FarmingFunMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

FarmingFunMap = {}

local FarmingFunMap_mt = Class(FarmingFunMap, Mission00);

function FarmingFunMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = FarmingFunMap_mt;
    end;
    local self = FarmingFunMap:superClass():new(baseDirectory, mt);
    return self;
end;

function FarmingFunMap:delete()
    FarmingFunMap:superClass().delete(self);
end;

function FarmingFunMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadowNew.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    FarmingFunMap:superClass().load(self);
end
function FarmingFunMap:loadFinished()
    FarmingFunMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function FarmingFunMap:mouseEvent(posX, posY, isDown, isUp, button)
    FarmingFunMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function FarmingFunMap:keyEvent(unicode, sym, modifier, isDown)
    FarmingFunMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function FarmingFunMap:update(dt)
    FarmingFunMap:superClass().update(self, dt);
end;

function FarmingFunMap:draw()
    FarmingFunMap:superClass().draw(self);
end;
