--
-- FARMET_EP6_BIGBAG
--
-- @author  Fullpowershift & Bayn  - www.TSForum3.com
-- @date  25/09/08
--
--

FARMET_EP6_BIGBAG = {};

function FARMET_EP6_BIGBAG.initSpecialization()
    Vehicle.registerJointType("BIGBAG");
end;

function FARMET_EP6_BIGBAG.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function FARMET_EP6_BIGBAG:load(xmlFile)
  self.FARMET_EP6_BIGBAG = true;
  self.closedNode  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bigbag#closedNode"));
  self.openedNode  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bigbag#openedNode"));
  self.attachedNode  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bigbag#attachedNode"));
  self.decalsNode  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bigbag#decalsNode"));
  self.decalsIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.bigbag#decalIndex"), 1);   
  self.findTrailerRaycastCallback = FARMET_EP6_BIGBAG.findTrailerRaycastCallback;
  self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
  self.pipeParticleSystem = {};
  self.pipeParticleSystemindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipeParticleSystem#index"));
  Utils.loadParticleSystem(xmlFile, self.pipeParticleSystem, "vehicle.pipeParticleSystem", self.pipeParticleSystemindex, false, nil, self.baseDirectory);
  local fillSound = getXMLString(xmlFile, "vehicle.fillSound#file");
  if fillSound ~= nil and fillSound ~= "" then
    self.fillSound = createSample("fillSound");
    loadSample(self.fillSound, fillSound, false);
    self.fillSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSound#pitchOffset"), 1);
    self.fillSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSound#pitchMax"), 2.0);
    self.fillSoundEnabled = false;
  end;
  self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
  self.grainUnloading = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainUnloading"), 10);
  self.pipeParticleActivated = false;
  self.sowingMachineFound = 0;
  self.Farmet_Excelent_Premium_6_Found = 0;
  setShaderParameter(self.decalsNode, "UVDecalOffset", (self.decalsIndex-1), 0, 0, 0, false);
end;

function FARMET_EP6_BIGBAG:delete()
end;

function FARMET_EP6_BIGBAG:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FARMET_EP6_BIGBAG:keyEvent(unicode, sym, modifier, isDown)
end;

function FARMET_EP6_BIGBAG:update(dt)
  if self.isClient and self:getIsActiveForInput() and self.attacherVehicle ~= nil then
    if self.trailerFound ~= 0 or self.sowingMachineFound ~= 0 or self.Farmet_Excelent_Premium_6_Found ~= 0 then
      if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
        self.activeUnloading = not self.activeUnloading;
        self.pipeParticleActivated = not self.pipeParticleActivated;
      end;    
    end;
  end;
  if self.activeUnloading and self.pipeParticleActivated then
    if not self.fillSoundEnabled and self.fillLevel > 0 and self.fillSound ~= nil then
      playSample(self.fillSound, 0, self.fillSoundVolume, 0);
      self.fillSoundEnabled = true; 
    end;
    setVisibility(self.openedNode, true);
    setVisibility(self.closedNode, false);
  else
    setVisibility(self.openedNode, false);
    setVisibility(self.closedNode, (self.attacherVehicle~=nil));
    if self.fillSoundEnabled then
      stopSample(self.fillSound);
      self.fillSoundEnabled = false;   
    end;
  end;
  if not self.attacherVehicle then
    if self.fillLevel == 0 then
      g_currentMission:removeVehicle(self);
      return;
    end;
  end;
  setVisibility(self.attachedNode, (self.attacherVehicle~=nil));
  self.pipeParticleActivated = false;
  self.trailerFound = 0;
  self.sowingMachineFound = 0;
  self.Farmet_Excelent_Premium_6_Found = 0;
  if self.attacherVehicle ~= nil then
    self.pipeParticleActivated = true;
    self.trailerFound = 0;
    local x,y,z = getWorldTranslation(self.trailerPosition);
    raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
    local trailer = nil;
    if self.trailerFound~=0 then
      trailer = g_currentMission.objectToTrailer[self.trailerFound];
    end;
    local sowingMachine = nil;
    local Farmet_Excelent_Premium_6 = nil;
    if self.sowingMachineFound ~= 0 or self.Farmet_Excelent_Premium_6_Found ~= 0 then
      local implements = g_currentMission.attachables;
      for i=0, table.getn(implements) do
        if implements[i] ~= nil then
          if implements[i].fillRootNode == self.Farmet_Excelent_Premium_6_Found then
            Farmet_Excelent_Premium_6 = implements[i];
            break;
          end;
          if implements[i].fillRootNode == self.sowingMachineFound then
            sowingMachine = implements[i];
            break;
          end;
        end;
      end;
    end;
    if (self.trailerFound == 0 or not trailer:allowFillType(self.currentFillType)) and 
       (self.sowingMachineFound == 0 or not sowingMachine:allowFillType(sowingMachine.FILLTYPE_WHEAT)) and
       (self.Farmet_Excelent_Premium_6_Found == 0 or not Farmet_Excelent_Premium_6:allowFillType(self.currentFillType)) then
      self.pipeParticleActivated = false;
      self.activeUnloading = false;
    else
      if self.activeUnloading then
        local deltaLevel = self.grainUnloading;
        if Farmet_Excelent_Premium_6 ~= nil then
          if self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
            deltaLevel = math.min(deltaLevel, Farmet_Excelent_Premium_6.fertilizerCapacity - Farmet_Excelent_Premium_6.fertilizerLevel);
          else
            deltaLevel = math.min(deltaLevel, Farmet_Excelent_Premium_6.capacity - Farmet_Excelent_Premium_6.fillLevel);
          end;
        elseif sowingMachine ~= nil then
          deltaLevel = math.min(deltaLevel, sowingMachine.capacity - sowingMachine.fillLevel);
        elseif trailer ~= nil then
          deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
        else
          deltaLevel = 0;
        end;
        self.fillLevel = self.fillLevel-deltaLevel;
        if self.fillLevel <= 0.0 then
          deltaLevel = deltaLevel+self.fillLevel;
          self.fillLevel = 0.0;
          pipeParticleActivated = false;
        end;
        if deltaLevel == 0 then
          self.pipeParticleActivated = false;
        end;
        self:setFillLevel(self.fillLevel, self.currentFillType);
        if Farmet_Excelent_Premium_6 ~= nil then
          if self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
            Farmet_Excelent_Premium_6:setFillLevel(Farmet_Excelent_Premium_6.fertilizerLevel+deltaLevel, self.currentFillType);
          else          
            Farmet_Excelent_Premium_6:setFillLevel(Farmet_Excelent_Premium_6.fillLevel+deltaLevel, self.currentFillType);
          end;
        elseif sowingMachine ~= nil then
          sowingMachine:setFillLevel(sowingMachine.fillLevel+deltaLevel, sowingMachine.FILLTYPE_WHEAT);
        elseif trailer ~= nil then
          trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
        end;
      else
        self.pipeParticleActivated = false;
      end;
    end;
    if self.fillLevel == 0 then
      self.attacherVehicle:detachImplementByObject(self);
    end;
  else
    self.activeUnloading = false;
  end;

  if self.activeUnloading and self.pipeParticleActivated then
    Utils.setEmittingState(self.pipeParticleSystem, true);
  else
    Utils.setEmittingState(self.pipeParticleSystem, false);
  end;
end;

function FARMET_EP6_BIGBAG:draw()
  if self.attacherVehicle ~= nil then
    if self.trailerFound ~= 0 or self.sowingMachineFound ~= 0 or self.Farmet_Excelent_Premium_6_Found ~= 0 then
      if not self.activeUnloading and not self.pipeParticleActivated and self.fillLevel > 0 then
        g_currentMission:addHelpButtonText(g_i18n:getText("Dump"), InputBinding.ACTIVATE_OBJECT);
      else
        if self.activeUnloading and self.pipeParticleActivated and self.fillLevel > 0 then
          g_currentMission:addHelpButtonText(g_i18n:getText("stop_refill_OBJECT"), InputBinding.ACTIVATE_OBJECT);
        end;
      end;
    end;
  end;
end;


function FARMET_EP6_BIGBAG:setFillLevel(fillLevel, fillType)
  Trailer.setFillLevel(self, fillLevel, fillType);
end;

function FARMET_EP6_BIGBAG:findTrailerRaycastCallback(transformId, x, y, z, distance)
  self.trailerFound = 0;
  self.sowingMachineFound = 0;
  self.Farmet_Excelent_Premium_6_Found = 0;
  
  local vehicle = g_currentMission.nodeToVehicle[transformId];
  if vehicle ~= nil then
    if vehicle.exactFillRootNode == transformId then
      if getUserAttribute(transformId, "Farmet_Excelent_Premium_6") then
        self.Farmet_Excelent_Premium_6_Found = transformId;
      elseif getUserAttribute(transformId, "sowingMachine") then
        self.sowingMachineFound = transformId;
      else
        self.trailerFound = transformId;
      end;
      return false;
    end;
  end;
  return true;
end;

function FARMET_EP6_BIGBAG:onDetach()
end;

function FARMET_EP6_BIGBAG:onAttach()
end;

