--
-- Farmet Excelent Premium 6
--
-- by Defender
--


Farmet_Excelent_Premium_6 = {};

function Farmet_Excelent_Premium_6.prerequisitesPresent(specializations)
    return true;
end;

function Farmet_Excelent_Premium_6:load(xmlFile)
  self.isEntered = false;
  self.allowFillType          = Farmet_Excelent_Premium_6.allowFillType;
  self.oldSetFillLevel        = self.setFillLevel;
  self.setFillLevel           = Farmet_Excelent_Premium_6.setFillLevel;
  self.loadAttacherVehicleHUD = Farmet_Excelent_Premium_6.loadAttacherVehicleHUD;
  self.adjustAttacherJoint    = SpecializationUtil.callSpecializationsFunction("adjustAttacherJoint");
  
  self.onAttach               = SpecializationUtil.callSpecializationsFunction("onAttach");
  self.onDetach               = SpecializationUtil.callSpecializationsFunction("onDetach");
  self.setLeftMarkerState     = SpecializationUtil.callSpecializationsFunction("setLeftMarkerState");
  self.setRightMarkerState    = SpecializationUtil.callSpecializationsFunction("setRightMarkerState");
  self.setFertilizerInstalled = SpecializationUtil.callSpecializationsFunction("setFertilizerInstalled");
  self.setAutoMarker          = SpecializationUtil.callSpecializationsFunction("setAutoMarker");
  self.setSeederIsDown        = SpecializationUtil.callSpecializationsFunction("setSeederIsDown");
  self.setLadderDown          = SpecializationUtil.callSpecializationsFunction("setLadderDown");
  self.setIsTurnedOn          = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
  self.setSailOpen            = SpecializationUtil.callSpecializationsFunction("setSailOpen");
  self.setTankEmptying        = SpecializationUtil.callSpecializationsFunction("setTankEmptying");
  self.setBroken              = SpecializationUtil.callSpecializationsFunction("setBroken");
  self.setWorkLight           = SpecializationUtil.callSpecializationsFunction("setWorkLight");

  self.overAllCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0);
  --<worklight light="0>8|4|0" corona="0>8|4|2" cone="0>8|4|1" />
  self.worklight={}
  local wl_light = getXMLString(xmlFile, "vehicle.worklight#light");
  if wl_light~=nil then
    self.worklight.light = Utils.indexToObject(self.components, wl_light);
    setVisibility(self.worklight.light, false);
  end;
  local wl_corona = getXMLString(xmlFile, "vehicle.worklight#corona");
  if wl_corona~=nil then
    self.worklight.corona = Utils.indexToObject(self.components, wl_corona);
    setVisibility(self.worklight.corona, false);
  end;
  local wl_cone = getXMLString(xmlFile, "vehicle.worklight#cone");
  if wl_cone~=nil then
    self.worklight.cone = Utils.indexToObject(self.components, wl_cone);
    setVisibility(self.worklight.cone, false);
  end;
  self.worklight.on = false;
  self.worklight.realLightsActive = false;
  self.worklight.lightConesActive = false;

  self.speedRotatingParts = {};
  local defaultAxis = Utils.getNoNil(getXMLString(xmlFile, "vehicle.speedRotatingParts#rotateAxis"), "x");
  local i = 0;
  while true do
    local baseName = string.format("vehicle.speedRotatingParts.speedRotatingPart(%d)", i);
    local index = getXMLString(xmlFile, baseName.. "#index");
    if index == nil then
      break;
    end;
    local node = Utils.indexToObject(self.components, index);
    if node ~= nil then
      local entry = {};
      entry.node = node;
      entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
      if entry.rotationSpeedScale == nil then
        entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
      end;
      entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
      entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
      entry.rotateAxis   = Utils.getNoNil(getXMLString(xmlFile, baseName .. "#rotateAxis"), defaultAxis);
      entry.mustBeDown   = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#mustBeDown"), false);
      table.insert(self.speedRotatingParts, entry);
    end;
    i = i + 1;
  end;

  self.seedUsage = {};
  local i = 0;
  while true do
    local baseName = string.format("vehicle.seedUsage.seed(%d)", i);
    local fillType = getXMLString(xmlFile, baseName.. "#type");
    if fillType == nil then
      break;
    end;
    local usage_kg_per_ha  = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#usage_kg_per_ha"), 0.631);
    local weight_per_liter = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#weight_per_liter"), 110);
    self.seedUsage[Fillable.fillTypeNameToInt[fillType]]=(usage_kg_per_ha*(1/weight_per_liter))/10000;
    print(tostring(fillType).."="..tostring(self.seedUsage[Fillable.fillTypeNameToInt[fillType]]));
    i = i + 1;
  end;

  self.attacherJointLimiter = {};
  self.attacherJointLimiter.downPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointLimiter#downPoint"));
  self.attacherJointLimiter.upPoint   = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointLimiter#upPoint"));

  self.ladderAnimation = getXMLString(xmlFile, "vehicle.ladder#animationName");
  self.ladderReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ladder#referenceNode"));
  self.ladderDown = false;
  
  self.sailAnimation = getXMLString(xmlFile, "vehicle.sail#animationName");
  self.sailReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sail#referenceNode"));
  self.sailOpen = false;
  
  self.tankEmptying = {};
  self.tankEmptying.referenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankEmptying#referenceNode"));
  self.tankEmptying.duration = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tankEmptying#duration"), 10.0)*1000;
  self.tankEmptying.seedBagNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankEmptying#seedBagNode"));
  self.tankEmptying.fertilizerBagNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankEmptying#fertilizerBagNode"));
  
  self.lowerSeederAnimation = getXMLString(xmlFile, "vehicle.lowerSeederAnimation#name");

  self.leftMarkerAnimation = getXMLString(xmlFile, "vehicle.leftMarker#animationName");
  self.leftMarkerTriangle = {};
  self.leftMarkerTriangle.A = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#bodA"));
  self.leftMarkerTriangle.B = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#bodB"));
  self.leftMarkerTriangle.C = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#bodC"));
  self.leftMarkerTriangle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#rotationNode"));
  self.leftMarkerTriangle.defRot = {getRotation(self.leftMarkerTriangle.rotNode)};
  self.leftMarkerArea = {};
  self.leftMarkerArea.start  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#areaStart"));
  self.leftMarkerArea.width  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#areaWidth"));
  self.leftMarkerArea.height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#areaHeight"));
  self.leftMarkerArea.test   = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarker#areaTest"));
  self.leftMarkerOpen = false;

  self.rightMarkerAnimation = getXMLString(xmlFile, "vehicle.rightMarker#animationName");
  self.rightMarkerTriangle = {};
  self.rightMarkerTriangle.A = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#bodA"));
  self.rightMarkerTriangle.B = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#bodB"));
  self.rightMarkerTriangle.C = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#bodC"));
  self.rightMarkerTriangle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#rotationNode"));
  self.rightMarkerTriangle.defRot = {getRotation(self.rightMarkerTriangle.rotNode)};

  self.rightMarkerArea = {};
  self.rightMarkerArea.start  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#areaStart"));
  self.rightMarkerArea.width  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#areaWidth"));
  self.rightMarkerArea.height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#areaHeight"));
  self.rightMarkerArea.test   = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarker#areaTest"));
  self.rightMarkerOpen = false;

  self.seedingArea = {};
  self.seedingArea.start  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seedingArea#areaStart"));
  self.seedingArea.width  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seedingArea#areaWidth"));
  self.seedingArea.height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seedingArea#areaHeight"));

  self.cultivatorArea = {};
  self.cultivatorArea.start  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cultivatorArea#areaStart"));
  self.cultivatorArea.width  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cultivatorArea#areaWidth"));
  self.cultivatorArea.height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cultivatorArea#areaHeight"));
  self.cultivatorArea.test   = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cultivatorArea#areaTest"));
  
  self.fillPlaneOffset = {};
  local index = 0;
  while true do
    local key = string.format("vehicle.fillPlaneOffsets.fillPlaneOffset(%d)", index);
    if not hasXMLProperty(xmlFile, key) then
      break;
    end;
    local fillType = getXMLString(xmlFile, key.."#type");
    if fillType~=nil then
      local planeIndex = Utils.getNoNil(getXMLInt(xmlFile, key.."#planeIndex"),1);
      self.fillPlaneOffset[Fillable.fillTypeNameToInt[fillType]] = planeIndex;  
    end;
    index = index + 1; 
  end;
  

  self.fertilizerLevel     = 0;
  self.fertilizerBin       = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fertilizerBin#node")); 
  self.fertilizerCapacity  = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fertilizerBin#capacity"), 0); 
  self.fertilizerInstalled = false;
  self.fertilizerPlaneHide = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fertilizerBin#planeHide"));
  local animKey="vehicle.fertilizerBin.changePlane";
  self.fertilizerChangePlane = {};
  self.fertilizerChangePlane.node = Utils.indexToObject(self.components, getXMLString(xmlFile, animKey.."#node"));
  self.fertilizerChangePlane.time = getXMLFloat(xmlFile, animKey.."#time")
  
  self.fertilizerChangePlane.x,self.fertilizerChangePlane.y,self.fertilizerChangePlane.z = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#translation"));
  if self.fertilizerChangePlane.y == nil then
    self.fertilizerChangePlane.y = getXMLFloat(xmlFile, animKey.."#y");
  end;
  self.fertilizerChangePlane.rx,self.fertilizerChangePlane.ry,self.fertilizerChangePlane.rz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#rotation"));
  self.fertilizerChangePlane.sx,self.fertilizerChangePlane.sy,self.fertilizerChangePlane.sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));

  self.fertilizerPlane = {};
  local fillPlane = {};
  fillPlane.nodes = {};
  local nodeI = 0;
  while true do
    local nodeKey = string.format("vehicle.fertilizerBin.fillPlane.node(%d)", nodeI);
    if not hasXMLProperty(xmlFile, nodeKey) then
      break;
    end;
    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, nodeKey.."#index"));
    if node ~= nil then
      local defaultX, defaultY, defaultZ = getTranslation(node);
      local defaultRX, defaultRY, defaultRZ = getRotation(node);
      setVisibility(node, false);

      local animCurve = AnimCurve:new(linearInterpolatorTransRotScale);
      local keyI = 0;
      while true do
        local animKey = nodeKey..string.format(".key(%d)", keyI);
        local keyTime = getXMLFloat(xmlFile, animKey.."#time");
        local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#translation"));
        if y == nil then
          y = getXMLFloat(xmlFile, animKey.."#y");
        end;
        local rx,ry,rz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#rotation"));
        local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));
        if keyTime == nil then
          break;
        end;
        local x = Utils.getNoNil(x, defaultX);
        local y = Utils.getNoNil(y, defaultY);
        local z = Utils.getNoNil(z, defaultZ);
        local rx = Utils.getNoNil(rx, defaultRX);
        local ry = Utils.getNoNil(ry, defaultRY);
        local rz = Utils.getNoNil(rz, defaultRZ);
        local sx = Utils.getNoNil(sx, 1);
        local sy = Utils.getNoNil(sy, 1);
        local sz = Utils.getNoNil(sz, 1);
        animCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
        keyI = keyI +1;
      end;
      if keyI == 0 then
        local minY, maxY = Utils.getVectorFromString(getXMLString(xmlFile, nodeKey.."#minMaxY"));
        local minY = Utils.getNoNil(minY, defaultY);
        local maxY = Utils.getNoNil(maxY, defaultY);
        animCurve:addKeyframe({x=defaultX, y=minY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 0});
        animCurve:addKeyframe({x=defaultX, y=maxY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 1});
      end;
      table.insert(fillPlane.nodes, {node=node, animCurve = animCurve});
    end;
    nodeI = nodeI +1;
  end;
  if table.getn(fillPlane.nodes) > 0 then
    self.fertilizerPlane = fillPlane;
  end;
  setVisibility(self.fertilizerBin, false);

  self.newGroundParticleSystems = {};
  local i=0;
  while true do
    local baseName = string.format("vehicle.groundParticleSystems.groundParticleSystem(%d)", i);
    if not hasXMLProperty(xmlFile, baseName) then
      break;
    end;
    local entry = {};
    entry.ps = {};
    Utils.loadParticleSystem(xmlFile, entry.ps, baseName, self.components, false, nil, self.baseDirectory);
    if table.getn(entry.ps) > 0 then
      entry.isActive = false;
      table.insert(self.newGroundParticleSystems, entry);
    end;
    i = i+1;
  end;

  self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
  self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;

  if self.isClient then
    local fanSound  = getXMLString(xmlFile, "vehicle.fanSound#file");
    if fanSound  ~= nil and fanSound  ~= "" then
        fanSound  = Utils.getFilename(fanSound, self.baseDirectory);
        self.fanSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#pitchOffset"), 0);
        self.fanSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#radius"), 50);
        self.fanSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#innerRadius"), 10);
        self.fanSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#volume"), 1);
        self.fanSound = createAudioSource("fanSound", fanSound, self.fanSoundRadius, self.fanSoundInnerRadius, self.fanSoundVolume, 0);
        link(self.components[1].node, self.fanSound);
        setVisibility(self.fanSound, false);
    end;
    local sowingSound  = getXMLString(xmlFile, "vehicle.sowingSound#file");
    if sowingSound  ~= nil and sowingSound  ~= "" then
        sowingSound  = Utils.getFilename(sowingSound, self.baseDirectory);
        self.sowingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#pitchOffset"), 0);
        self.sowingSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#radius"), 50);
        self.sowingSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#innerRadius"), 10);
        self.sowingSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#volume"), 1);
        self.sowingSound = createAudioSource("sowingSound", sowingSound, self.sowingSoundRadius, self.sowingSoundInnerRadius, self.sowingSoundVolume, 0);
        link(self.components[1].node, self.sowingSound);
        setVisibility(self.sowingSound, false);
    end;
  end;

  self.hudBasePosX = 0.7543;
  self.hudBasePosY = 0.01238;
  self.hudBaseWidth = 0.2371;
  self.hudBaseHeight = 0.1581;

  self.hudBarWidth = 0.205;
  self.hudBarHeight = 0.02190;
  self.hudBarOffsetX = 0.023571;
  self.hudBarStartOffsetY = 0.0085714;
  self.hudBarOffsetY = 0.0395;

  self.fertilizerBarOverlay = Overlay:new("hudBarGoldOverlay", Utils.getFilename("$dataS2/menu/hud/vehicleHUD_barRed.png", self.baseDirectory), self.hudBasePosX + self.hudBarOffsetX, self.hudBasePosY + self.hudBarStartOffsetY + 1 * self.hudBarOffsetY, self.hudBarWidth, self.hudBarHeight/2.1);
  self.unFolded                 = true;
  self.isTurnedOn               = false;
  self.isTankEmptying           = false;
  
  self.userIsByLadder           = false;
  self.userIsBySail             = false;
  self.userIsBytankEmptyingNode = false;
  self.autoMarker               = false;
  self.lastMarker               = -1;
  
  self.ignoreMyAllowFillType    = false;
  
  self.currentlyAttachedTimer   = 0;
  
  self.isReadyForManualAttacherAdjust = false;

  self.broken = false;
  self.repairPrice = 1000;
  self.repairCount = 0;
  self.repairAgainPrice = 500;
  self.speedViolationMaxTime = 5000;
  self.speedViolationTimer = self.speedViolationMaxTime;

  self.saveAILM = self.aiLeftMarker;

  setUserAttribute(self.components[1].node, "Farmet_Excelent_Premium_6", "Boolean", true);
  self:setSeederIsDown(false, true);
end;

function Farmet_Excelent_Premium_6:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
  local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
  local fillType = getXMLString(xmlFile, key.."#fillType");
  local lowered = getXMLBool(xmlFile, key.."#lowered");
  local fertilizerInstalled = Utils.getNoNil(getXMLBool(xmlFile, key.."#fertilizerInstalled"), false);
  if (lowered~=nil) and (self.seederIsDown~=lowered) then
    self:setSeederIsDown(lowered, true);
  end;
  self:setFertilizerInstalled(fertilizerInstalled);
  if fertilizerInstalled then
    local fertilizerLevel = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fertilizerLevel"), 0.0);
    self.ignoreMyAllowFillType = true;
    self:setFillLevel(fertilizerLevel, Fillable.FILLTYPE_FERTILIZER);
    self.ignoreMyAllowFillType = false;
  end;
  if fillLevel ~= nil and fillType ~= nil then
    local fillTypeInt = Fillable.fillTypeNameToInt[fillType];
    if fillTypeInt ~= nil then
      self.ignoreMyAllowFillType = true;     
      self:setFillLevel(fillLevel, fillTypeInt);
      self.ignoreMyAllowFillType = false;
    end;
  end;
  self.broken = Utils.getNoNil(getXMLBool(xmlFile, key.."#broken"), false);
  self.repairCount = Utils.getNoNil(getXMLInt(xmlFile, key.."#repairCount"), 0);
  return BaseMission.VEHICLE_LOAD_OK;
end;

function Farmet_Excelent_Premium_6:getSaveAttributesAndNodes(nodeIdent)
  local attributes = 'lowered="'..tostring(self.seederIsDown)..'" fertilizerInstalled="'..tostring(self.fertilizerInstalled)..'" fertilizerLevel="'..self.fertilizerLevel..'" broken="'..tostring(self.broken)..'" repairCount="'..tostring(self.repairCount)..'"';
  return attributes, nil;
end;

function Farmet_Excelent_Premium_6:delete()
  for _, v in pairs(self.newGroundParticleSystems) do
    Utils.deleteParticleSystem(v.ps);
  end;
end;

function Farmet_Excelent_Premium_6:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Farmet_Excelent_Premium_6:keyEvent(unicode, sym, modifier, isDown)
end;

function Farmet_Excelent_Premium_6:setLeftMarkerState(state)
  if self.leftMarkerOpen ~= state then
    self.leftMarkerOpen = state;
    if self.leftMarkerOpen then
      self:playAnimation(self.leftMarkerAnimation, 1, nil);
    else
      self:playAnimation(self.leftMarkerAnimation, -1, nil);
    end;
  end;
end;

function Farmet_Excelent_Premium_6:setRightMarkerState(state)
  if self.rightMarkerOpen ~= state then
    self.rightMarkerOpen = state;
    if self.rightMarkerOpen then
      self:playAnimation(self.rightMarkerAnimation, 1, nil);
    else
      self:playAnimation(self.rightMarkerAnimation, -1, nil);
    end;
  end;
end;

function Farmet_Excelent_Premium_6:setAutoMarker(state)
  if self.autoMarker~=state then
    self.autoMarker=state;
  end;
end;

function Farmet_Excelent_Premium_6:setSeederIsDown(state, turbo)
  if self.seederIsDown ~= state then
    self.seederIsDown = state;
    self.isDefaultLowered = state;
    if self.seederIsDown then
      self:playAnimation(self.lowerSeederAnimation, 1, nil);
      if self.autoMarker then
        if self.lastMarket==0 then
          self:setLeftMarkerState(true);
        elseif self.lastMarket==1 then
          self:setRightMarkerState(true);
        end;
      end;
    else
      self:playAnimation(self.lowerSeederAnimation, -1, nil);
      if self.autoMarker then
        if self.leftMarkerOpen then
          self.lastMarket = 1;
          self:setLeftMarkerState(false);
        end;
        if self.rightMarkerOpen then
          self.lastMarket = 0;
          self:setRightMarkerState(false);
        end;
      end;
    end;    
    if turbo then
      AnimatedVehicle.updateAnimations(self, 99999999);
    end;
    if self.attacherVehicle~=nil then
      local implement = self.attacherVehicle:getImplementByObject(self);
      local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
      if jointDesc.allowsLowering then
        self.attacherVehicle:setJointMoveDown(implement.jointDescIndex, self.seederIsDown, false);
      end;
      self.adjustTimer = 2000;
    end;
  end;
end;

function Farmet_Excelent_Premium_6:setLadderDown(state)
  if self.ladderDown ~= state then
    self.ladderDown = state;
    if self.ladderAnimation ~= nil and self.playAnimation ~= nil then
      if self.ladderDown then
        self:playAnimation(self.ladderAnimation, 1, nil);
      else
        self:playAnimation(self.ladderAnimation, -1, nil);
      end;
    end;
  end;
end;

function Farmet_Excelent_Premium_6:setIsTurnedOn(state)
  if self.isTurnedOn ~= state then
    self.isTurnedOn = state;
    if self.isClient then
      setVisibility(self.fanSound, state);
    end;
  end;
end;

function Farmet_Excelent_Premium_6:setTankEmptying(state)
  if self.isTankEmptying ~= state then
    self.isTankEmptying = state;
    if self.isTankEmptying then
      if self.fillLevel>0.0 then
        self.bagWarningTimer = nil;
        self.TankEmptyingSeedDelta = self.capacity/self.tankEmptying.duration;
        self.TankEmptyingSeedBag = getIsBigBagInRange(self.currentFillType, self.tankEmptying.seedBagNode, 3);
        if self.TankEmptyingSeedBag == nil then -- nenasel jsem v okoli vak kam bych mohl plnit, tak si vytvorim novy
          local x,y,z = getWorldTranslation(self.tankEmptying.seedBagNode);
          local rx,ry,rz = getWorldTranslation(self.tankEmptying.seedBagNode);
          local fruit=Fillable.fillTypeIntToName[self.currentFillType];
          fruit=string.upper(string.sub(fruit,1,1))..string.sub(fruit,2);
          self.TankEmptyingSeedBag = g_currentMission:loadVehicle(g_modsDirectory.."/Farmet_Excelent_Premium_BigBags/BigBag"..fruit..".xml", x, 0, z, 0, true);
          self.ignoreMyAllowFillType = true;
          self:setFillLevel(self.fillLevel - 1, self.currentFillType);
          self.ignoreMyAllowFillType = false;
          self.TankEmptyingSeedBag:setFillLevel(1, self.currentFillType);
        end;
      else
        self.isTankEmptying = false;
      end;
      if self.fertilizerInstalled then
        if self.fertilizerLevel>0.0 then
          self.isTankEmptying = true;
          self.TankEmptyingFertilizerDelta = self.fertilizerCapacity/(self.tankEmptying.duration/(self.capacity/self.fertilizerCapacity));
          self.TankEmptyingFertilizerBag = getIsBigBagInRange(Fillable.FILLTYPE_FERTILIZER, self.tankEmptying.fertilizerBagNode, 3);
          if self.TankEmptyingFertilizerBag == nil then
            local x,y,z = getWorldTranslation(self.tankEmptying.fertilizerBagNode);
            local rx,ry,rz = getWorldTranslation(self.tankEmptying.fertilizerBagNode);
            self.TankEmptyingFertilizerBag = g_currentMission:loadVehicle(g_modsDirectory.."/Farmet_Excelent_Premium_BigBags/BigBagFertilizer.xml", x, 0, z, 0, true);
            self.ignoreMyAllowFillType = true;
            self:setFillLevel(self.fertilizerLevel - 1, Fillable.FILLTYPE_FERTILIZER);
            self.ignoreMyAllowFillType = false;
            self.TankEmptyingFertilizerBag:setFillLevel(1, Fillable.FILLTYPE_FERTILIZER);
          end;
        else
          self.isTankEmptying = self.isTankEmptying or false;
        end;
      end;
    end;
  end;
end;

function Farmet_Excelent_Premium_6:setBroken(broken, noEventSend)
  if broken ~= self.broken then
    self.broken = broken;
--[[
    if noEventSend == nil or noEventSend == false then
      if g_server ~= nil then
        g_server:broadcastEvent(Farmet_Excelent_Premium_6setBrokenEvent:new(self, broken), nil, nil, self);
      else
       g_client:getServerConnection():sendEvent(Farmet_Excelent_Premium_6setBrokenEvent:new(self, broken));
      end;
    end;
]]--
    if not self.broken then
      self.repairCount = self.repairCount + 1;
    end;
  end;
end;

function Farmet_Excelent_Premium_6:setWorkLight(state)
  local lstate = self.worklight.on;
  if state~=nil then
    self.worklight.on = state;
  end;
  local realLightsActive = false;
  local lightConesActive = false;
  if self.attacherVehicle then
    if (self.attacherVehicle:getIsActiveForSound()) then
      realLightsActive = self.worklight.on;
    else
      lightConesActive = self.worklight.on;
    end;
  else
    self.worklight.on = false;
  end;
  if self.worklight.on ~= lstate then
    setVisibility(self.worklight.corona, self.worklight.on);
  end;
  if self.worklight.realLightsActive~=realLightsActive then
    self.worklight.realLightsActive = realLightsActive;
    setVisibility(self.worklight.light, realLightsActive);
  end;
  if self.worklight.lightConesActive~=lightConesActive then
    self.worklight.lightConesActive = lightConesActive;
    setVisibility(self.worklight.cone, lightConesActive);
  end;
end;

function Farmet_Excelent_Premium_6:setSailOpen(state)
  if self.sailOpen ~= state then
    self.sailOpen = state;
    if self.sailAnimation ~= nil and self.playAnimation ~= nil then
      if self:getIsAnimationPlaying(self.sailAnimation) then
        if self.sailOpen then
          self:setAnimationSpeed(self.sailAnimation, 1);
        else
          self:setAnimationSpeed(self.sailAnimation, -1);
        end;
      else
        if self.sailOpen then
          self:playAnimation(self.sailAnimation, 1, nil);
        else
          self:playAnimation(self.sailAnimation, -1, nil);
        end;
      end;
    end;
  end;
end;

function Farmet_Excelent_Premium_6:update(dt)
  if self.isClient then
    if self.broken then
      if getUserInRange(self.rootNode, 6) then
        local price = self.repairPrice + (self.repairAgainPrice * self.repairCount);
        g_currentMission:addHelpButtonText(g_i18n:getText("repeair").." ("..tostring(price*g_i18n.currencyFactor).." "..g_i18n:getText("Currency_symbol")..")", InputBinding.IMPLEMENT_EXTRA);
        if g_currentMission.missionStats.money < price then
          g_currentMission:addExtraPrintText(g_i18n:getText("no_money"));
        else
          if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            g_currentMission.missionStats.money=g_currentMission.missionStats.money-price;
            self:setBroken(false);
          end;
        end;
      end;
    end;

    if self:getIsActiveForInput() then
      g_currentMission:addHelpButtonText(g_i18n:getText("FARMET_EP6_WORKLIGHT"), InputBinding.FARMET_EP6_WORKLIGHT);
      if InputBinding.hasEvent(InputBinding.FARMET_EP6_WORKLIGHT) then
        self:setWorkLight(not self.worklight.on);
      end;
    end;
  end;

  if self.isServer then
    if self.attacherVehicle then
      if self.broken then
        self.attacherVehicle:detachImplementByObject(self);
      end;
    end;
  end;
  local lastUF = self.unFolded;
  self.unFolded = (self.foldAnimTime <= 0.001);
  if self.unFolded~=lastUF then
    if self.unFolded then
      self.aiLeftMarker = self.saveAILM;
      if self.attacherVehicle~=nil then
        AITractor.updateToolsInfo(self.attacherVehicle);
      end;
    else
      self.aiLeftMarker = nil;
      if self.attacherVehicle~=nil then
        AITractor.updateToolsInfo(self.attacherVehicle);
      end;
    end;
  end;
  if self.isActive then
    self:setWorkLight();
  end;
  if (self.unFolded) and (self.currentlyAttachedTimer <= 0) then
    self.userIsBySail = getUserInRange(self.sailReferenceNode, 1.25);
    self.userIsByLadder = getUserInRange(self.ladderReferenceNode, 2) and not self.userIsBySail;
    if self.userIsByLadder then
      local s = "down_ladder";
      if self.ladderDown then
        s = "lift_ladder";
      end;
      g_currentMission:addHelpButtonText(g_i18n:getText(s), InputBinding.IMPLEMENT_EXTRA3);
    end;
    if self.userIsBySail then
      local s = "open_sail";
      if self.sailOpen then
        s = "close_sail";
      end;
      g_currentMission:addHelpButtonText(g_i18n:getText(s), InputBinding.IMPLEMENT_EXTRA3);
    end;

    if self.userIsByLadder then
      if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
        self:setLadderDown(not self.ladderDown);
      end;
    end;
    if self.userIsBySail then
      if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
        self:setSailOpen(not self.sailOpen);
      end;
      if self.sailOpen and (self.fillLevel==0) and (self.fertilizerLevel==0) then
        local s="insert_partition";
        if self.fertilizerInstalled then
          s="remove_partition";
        end;
        g_currentMission:addHelpButtonText(g_i18n:getText(s), InputBinding.IMPLEMENT_EXTRA);
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
          self:setFertilizerInstalled(not self.fertilizerInstalled);
        end;
      end;    
    end;

    if self:getIsActiveForInput() then
      local s = g_i18n:getText("lower_OBJECT");
      if self.seederIsDown then
        s = g_i18n:getText("lift_OBJECT");
      end;
      g_currentMission:addHelpButtonText(string.format(s, self.typeDesc), InputBinding.LOWER_IMPLEMENT);
      if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
        self:setSeederIsDown(not self.seederIsDown);
      end;
      local s = "auto_marker_on";
      if self.autoMarker then
        s = "auto_marker_off";
      end;
      g_currentMission:addHelpButtonText(g_i18n:getText(s), InputBinding.FARMET_EP6_znamenak_auto);
      if InputBinding.hasEvent(InputBinding.FARMET_EP6_znamenak_auto) then
        self:setAutoMarker(not self.autoMarker);
      end;
      
      local s = "lower_left_marker";
      if self.leftMarkerOpen then
        s = "lift_left_marker"; 
      end;
      g_currentMission:addHelpButtonText(g_i18n:getText(s), InputBinding.FARMET_EP6_znamenak_levy);
      if InputBinding.hasEvent(InputBinding.FARMET_EP6_znamenak_levy) then
        self:setLeftMarkerState(not self.leftMarkerOpen);
      end;

      local s = "lower_right_marker"; 
      if self.rightMarkerOpen then
        s = "lift_right_marker";
      end;
      g_currentMission:addHelpButtonText(g_i18n:getText(s), InputBinding.FARMET_EP6_znamenak_pravy);
      if InputBinding.hasEvent(InputBinding.FARMET_EP6_znamenak_pravy) then
        self:setRightMarkerState(not self.rightMarkerOpen);
      end;
    end;

    if self.leftMarkerOpen and self.seederIsDown and not self.broken then
      local A_x, A_y, A_z = getWorldTranslation(self.leftMarkerTriangle.A);
      A_y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, A_x, A_y, A_z);
      local B_x, B_y, B_z = getWorldTranslation(self.leftMarkerTriangle.B);
      local C_x, C_y, C_z = getWorldTranslation(self.leftMarkerTriangle.C);
      local a = Utils.vector3Length(B_x-C_x, B_y-C_y, B_z-C_z);
      local b = Utils.vector3Length(C_x-A_x, C_y-A_y, C_z-A_z);
      local c = Utils.vector3Length(B_x-A_x, B_y-A_y, B_z-A_z);
      local beta = math.deg(math.acos(((a*a)+(c*c)-(b*b))/(2*a*c)));
      local uhel = math.deg(self.leftMarkerTriangle.defRot[1])-(beta);
      setRotation(self.leftMarkerTriangle.rotNode, Utils.degToRad(uhel),self.leftMarkerTriangle.defRot[2],self.leftMarkerTriangle.defRot[3]);
      self.leftMarkerTriangle.lastRot = Utils.degToRad(uhel);
      
      if (self:getAnimationTime(self.leftMarkerAnimation)==1) and (self.movingDirection > 0) then
        local cuttingAreasSend = {};
        local limitToField = true;
        local x0,y0,z0 = getWorldTranslation(self.leftMarkerArea.start);
        local x1,y1,z1 = getWorldTranslation(self.leftMarkerArea.width);
        local x2,y2,z2 = getWorldTranslation(self.leftMarkerArea.height);
        local x3,y3,z3 = getWorldTranslation(self.leftMarkerArea.test);
        table.insert(cuttingAreasSend, {x0,z0,x1,z1,x2,z2});

        local cultivator = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x3,z3,x3,z3,x3,z3);
        if cultivator ~= 0 then
          PloughAreaEvent.runLocally(cuttingAreasSend, limitToField);
          g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField));
        else
          CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
          g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField));
        end;
      end;
    end;
  
    if self.rightMarkerOpen and self.seederIsDown and not self.broken then
      local A_x, A_y, A_z = getWorldTranslation(self.rightMarkerTriangle.A);
      A_y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, A_x, A_y, A_z);
      local B_x, B_y, B_z = getWorldTranslation(self.rightMarkerTriangle.B);
      local C_x, C_y, C_z = getWorldTranslation(self.rightMarkerTriangle.C);
      local a = Utils.vector3Length(B_x-C_x, B_y-C_y, B_z-C_z);
      local b = Utils.vector3Length(C_x-A_x, C_y-A_y, C_z-A_z);
      local c = Utils.vector3Length(B_x-A_x, B_y-A_y, B_z-A_z);
      local beta = math.deg(math.acos(((a*a)+(c*c)-(b*b))/(2*a*c)));
      local uhel = math.deg(self.rightMarkerTriangle.defRot[1])-(beta);
      setRotation(self.rightMarkerTriangle.rotNode, Utils.degToRad(uhel),self.rightMarkerTriangle.defRot[2],self.rightMarkerTriangle.defRot[3]);
      self.rightMarkerTriangle.lastRot = Utils.degToRad(uhel);

      if (self:getAnimationTime(self.rightMarkerAnimation)==1) and (self.movingDirection > 0) then
        local cuttingAreasSend = {};
        local limitToField = true;
        local x0,y0,z0 = getWorldTranslation(self.rightMarkerArea.start);
        local x1,y1,z1 = getWorldTranslation(self.rightMarkerArea.width);
        local x2,y2,z2 = getWorldTranslation(self.rightMarkerArea.height);
        local x3,y3,z3 = getWorldTranslation(self.rightMarkerArea.test);
        
        table.insert(cuttingAreasSend, {x0,z0,x1,z1,x2,z2});

        local cultivator = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x3,z3,x3,z3,x3,z3);
        if cultivator ~= 0 then
          PloughAreaEvent.runLocally(cuttingAreasSend, limitToField);
          g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField));
        else
          CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
          g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField));
        end;
      end;
    end;
    local hasSeeds = (self.fillLevel > 0) or (self.fertilizerInstalled and (self.fertilizerLevel>0.0));
    if self:getIsActiveForInput() then
      if hasSeeds then
        if self.isTurnedOn then
          g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
        else
          g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
        end;
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
          self:setIsTurnedOn(not self.isTurnedOn);
        end;
      end;
    end;
    if (self.seederIsDown) then
      if self.isTurnedOn and not hasSeeds then
        self:setIsTurnedOn(false);
        if self:getIsHired() then
          self.attacherVehicle:stopAITractor();
        end;
      end;

      if self.attacherVehicle~=nil and self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed * 3600 > 15 then
        self.speedViolationTimer = self.speedViolationTimer - dt;
        if self.speedViolationTimer < 0 and self.attacherVehicle~=nil then
          self:setBroken(true);
        end;
      else
        self.speedViolationTimer = self.speedViolationMaxTime;
      end;

      if self.isServer and (self.movingDirection > 0) and not self.broken then
        local cuttingAreasSend = {};
        local limitToField = true;
        local x0,y0,z0 = getWorldTranslation(self.cultivatorArea.start);
        local x1,y1,z1 = getWorldTranslation(self.cultivatorArea.width);
        local x2,y2,z2 = getWorldTranslation(self.cultivatorArea.height);
        local x3,y3,z3 = getWorldTranslation(self.cultivatorArea.test);
        table.insert(cuttingAreasSend, {x0,z0,x1,z1,x2,z2});
        self.lastCultivatingArea = cuttingAreasSend;

        local spray  = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sprayChannel, x3,z3,x3,z3,x3,z3);
        local fspray = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sprayChannel, x0,z0,x1,z1,x2,z2);

        CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
        g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField));
        if (spray>0) or (self.fertilizerInstalled and (self.fertilizerLevel>0.0) and self.isTurnedOn) then
          local farea = math.abs((z1-z0)*(x2-x0) - (x1-x0)*(z2-z0));
          SprayerAreaEvent.runLocally(cuttingAreasSend);
          if farea>0 then
            local pixelToSqm = g_currentMission:getTerrainDetailPixelsToSqm(); -- 8192px are mapped to 2048m
            local sqm = farea*pixelToSqm;
            local fusage = (sqm*0.0275)/15; -- 0.0275 je nastaveno u vsech zakladnich plodin
            if (self.fertilizerInstalled and (self.fertilizerLevel>0.0) and self.isTurnedOn) then
              self.ignoreMyAllowFillType = true;
              self:setFillLevel(self.fertilizerLevel - fusage, Fillable.FILLTYPE_FERTILIZER);
              self.ignoreMyAllowFillType = false;
            end;
            g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
          end;
        end;

        if (self.fillLevel>0.0) and self.isTurnedOn then
          local currentSeed = FruitUtil.fillTypeToFruitType[self.currentFillType];
          self.seedingAreasSend = {};
          local x,y,z    = getWorldTranslation(self.seedingArea.start);
          local x1,y1,z1 = getWorldTranslation(self.seedingArea.width);
          local x2,y2,z2 = getWorldTranslation(self.seedingArea.height);

          table.insert(self.seedingAreasSend, {x,z,x1,z1,x2,z2});

          local area = SowingMachineAreaEvent.runLocally(self.seedingAreasSend, currentSeed);
          if area > 0 then
            local pixelToSqm = g_currentMission:getTerrainDetailPixelsToSqm(); -- 8192px are mapped to 2048m
            local sqm = (area*pixelToSqm)/5;
            local ha = sqm/10000;

            self.lastSowingArea = sqm;

            local usage = sqm*self.seedUsage[self.currentFillType];
            g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
            g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

            g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
            g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

            self.ignoreMyAllowFillType = true;
            self:setFillLevel(self.fillLevel - usage, self.currentFillType);
            self.ignoreMyAllowFillType = false;
            g_server:broadcastEvent(SowingMachineAreaEvent:new(self.seedingAreasSend, currentSeed));
          end;
        end;
      end;
    else
      self.speedViolationTimer = self.speedViolationMaxTime;
    end;
  else
    self.speedViolationTimer = self.speedViolationMaxTime;
  end;
  if self:getIsActiveForInput() and self.isReadyForManualAttacherAdjust and (self.attacherVehicle~=nil) then
    local jointDesc = self.lastJointDesc;
    if (jointDesc.maxRot~=nil) and (jointDesc.minRot~=nil) then
      local s = "upper_hinge"; 
      if self.seederIsDown then
        s = "lower_hinge"; 
      end;
      
      g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lift_hinge"), g_i18n:getText(s)), InputBinding.FARMET_EP6_up); 
      g_currentMission:addHelpButtonText(string.format(g_i18n:getText("down_hinge"), g_i18n:getText(s)), InputBinding.FARMET_EP6_down);
      local uhel = 0;
      if InputBinding.isPressed(InputBinding.FARMET_EP6_up) then
        uhel=uhel+(0.0001*dt);
      end;
      if InputBinding.isPressed(InputBinding.FARMET_EP6_down) then
        uhel=uhel-(0.0001*dt);
      end;
      if uhel~=0 then
        if self.seederIsDown then
          jointDesc.maxRot[1] = jointDesc.maxRot[1] + uhel;
        else
          jointDesc.minRot[1] = jointDesc.minRot[1] + uhel;
        end;
      end;
    end;
  end;

  if self.isClient then
    if self.movingDirection~=0 then
      for k,v in pairs(self.speedRotatingParts) do
        if (self.foldAnimTime == nil or (self.foldAnimTime <= v.foldMaxLimit and self.foldAnimTime >= v.foldMinLimit)) and 
           (not v.mustBeDown or (self.seederIsDown)) then
          local x = 0; local y = 0; local z = 0;
          local r = v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt;
          if v.rotateAxis=="x" then
            x = r;
          elseif v.rotateAxis=="y" then
            y = r;
          elseif v.rotateAxis=="z" then
            z = r;
          end;
          rotate(v.node, x, y, z);
        end;
      end;
    end;
    local s_p_Visibility = (self.movingDirection~=0) and self.seederIsDown and (self.unFolded);
    if getVisibility(self.sowingSound)~=s_p_Visibility then
      setVisibility(self.sowingSound, s_p_Visibility);
    end;
    for _, ps in pairs(self.newGroundParticleSystems) do
      if ps.isActive~=s_p_Visibility then
        ps.isActive = s_p_Visibility;
        Utils.setEmittingState(ps.ps, s_p_Visibility);
      end;
    end;
  end;  
  self.userIsBytankEmptyingNode = getUserInRange(self.tankEmptying.referenceNode, 1.25);
  if self.userIsBytankEmptyingNode and self.attacherVehicle~=nil then
    local s1=g_i18n:getText("seed");
    if self.fertilizerInstalled then
      s1=s1.." "..g_i18n:getText("and_fertilizer");
    end;
    local s=string.format(g_i18n:getText("empty_tray"), s1);
    if self.isTankEmptying then
      s=string.format(g_i18n:getText("empty_tray_stop"), s1);
    end;
    g_currentMission:addHelpButtonText(s, InputBinding.ACTIVATE_OBJECT);
    if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
      self:setTankEmptying(not self.isTankEmptying);
    end;
  end;
  if self.isTankEmptying then
    if self.attacherVehicle~=nil then
      local tankEmptyingEnd = false;
      self.ignoreMyAllowFillType = true;
      if (self.fillLevel>0.0) and (self.TankEmptyingSeedBag~=nil) and (self.TankEmptyingSeedBag.fillLevel<self.TankEmptyingSeedBag.capacity) then
        local ft = self.currentFillType;
        self:setFillLevel(self.fillLevel - (self.TankEmptyingSeedDelta*dt), ft);
        self.TankEmptyingSeedBag:setFillLevel(self.TankEmptyingSeedBag.fillLevel+(self.TankEmptyingSeedDelta*dt), ft);
      else
        tankEmptyingEnd = true;
      end;
      if self.fertilizerInstalled then
        if self.fertilizerLevel>0.0 then
          if (self.TankEmptyingFertilizerBag~=nil) and (self.TankEmptyingFertilizerBag.fillLevel<self.TankEmptyingFertilizerBag.capacity) then
            local delta = (self.TankEmptyingFertilizerDelta*dt);
            self:setFillLevel(self.fertilizerLevel - delta, Fillable.FILLTYPE_FERTILIZER);
            self.TankEmptyingFertilizerBag:setFillLevel(self.TankEmptyingFertilizerBag.fillLevel + delta, Fillable.FILLTYPE_FERTILIZER);
            if (self.fillLevel==0) then
              tankEmptyingEnd = false;
            end;
          else
            tankEmptyingEnd = true;
          end;
        end;
      end;
      self.ignoreMyAllowFillType = false;
      if tankEmptyingEnd then
        if (self.TankEmptyingSeedBag~=nil) and (self.TankEmptyingSeedBag.fillLevel==self.TankEmptyingSeedBag.capacity) and (self.fillLevel>0.0) then
          self.bagWarning = "\n"..g_i18n:getText("seed_bag_full").."\n"..g_i18n:getText("continue_emptying");
          self.bagWarningTimer = 5000;
        end;

        if self.fertilizerInstalled and (self.TankEmptyingFertilizerBag~=nil) and (self.TankEmptyingFertilizerBag.fillLevel==self.TankEmptyingFertilizerBag.capacity) and (self.fertilizerLevel>0.0) then
          self.bagWarning = "\n"..g_i18n:getText("fertilizer_bag_full").."\n"..g_i18n:getText("continue_emptying");
          self.bagWarningTimer = 5000;
        end;
        self:setTankEmptying(false);
      end;
    else
      self:setTankEmptying(false);
    end;
  end;
  if not (self.leftMarkerOpen and self.seederIsDown) then
    if self.leftMarkerTriangle.lastRot~=nil then
      local x, y, z = getRotation(self.leftMarkerTriangle.rotNode);
      local newRotX = Utils.getMovedLimitedValues({x}, {self.leftMarkerTriangle.lastRot}, {self.leftMarkerTriangle.defRot[1]}, 1, 1000, dt, true);
      setRotation(self.leftMarkerTriangle.rotNode, newRotX[1], y, z);
      if newRotX[1] == self.leftMarkerTriangle.defRot[1] then
        self.leftMarkerTriangle.lastRot=nil;
      end;
    end;            
  end;
  if not (self.rightMarkerOpen and self.seederIsDown) then
    if self.rightMarkerTriangle.lastRot~=nil then
      local x, y, z = getRotation(self.rightMarkerTriangle.rotNode);
      local newRotX = Utils.getMovedLimitedValues({x}, {self.rightMarkerTriangle.lastRot}, {self.rightMarkerTriangle.defRot[1]}, 1, 1000, dt, true);
      setRotation(self.rightMarkerTriangle.rotNode, newRotX[1], y, z);
      if newRotX[1] == self.rightMarkerTriangle.defRot[1] then
        self.rightMarkerTriangle.lastRot=nil;
      end;
    end;      
  end;  
  self.CanBeFolded = not (self.sailOpen or self.ladderDown or self.seederIsDown or self.leftMarkerOpen or self.rightMarkerOpen or self.isTurnedOn);
  if self.currentlyAttachedTimer > 0 then
    self.currentlyAttachedTimer = self.currentlyAttachedTimer - dt;
  elseif self.currentlyAttachedTimer~=0 then
    self.currentlyAttachedTimer = 0;
    self:adjustAttacherJoint(true);    
  end;
  if self.adjustTimer ~= nil then
    if self.adjustTimer > 0 then
      self.adjustTimer = self.adjustTimer - dt;
    else
      self.adjustTimer=nil;
      self:adjustAttacherJoint(false);
    end;
  end;
  
  if self.bagWarningTimer then
    g_currentMission:addWarning(self.bagWarning, 0.07+0.022, 0.019+0.029);
    self.bagWarningTimer=self.bagWarningTimer-dt;
    if not g_currentMission.showHelpText then
      -- pokud nezobrazuju help, tak odpocitavam 2x rychleji, at moc dlouho neotravuju
      self.bagWarningTimer=self.bagWarningTimer-dt;
    end;
    if self.bagWarningTimer<0 then
      self.bagWarningTimer=nil;
    end;
  end;
end;

function Farmet_Excelent_Premium_6:adjustAttacherJoint(saveOriginal)
  if (self.attacherVehicle~=nil) then
    local implement = self.attacherVehicle:getImplementByObject(self);
    local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
    if (jointDesc.maxRot~=nil) and (jointDesc.minRot~=nil) then
      if saveOriginal then
        self.lastJointDesc = jointDesc;
        self.attacherJointLimiter.originalMaxRot = {};
        self.attacherJointLimiter.originalMaxRot[1]=jointDesc.maxRot[1];
        self.attacherJointLimiter.originalMaxRot[2]=jointDesc.maxRot[2];
        self.attacherJointLimiter.originalMaxRot[3]=jointDesc.maxRot[3];
        self.attacherJointLimiter.originalMinRot = {};
        self.attacherJointLimiter.originalMinRot[1]=jointDesc.minRot[1];
        self.attacherJointLimiter.originalMinRot[2]=jointDesc.minRot[2];
        self.attacherJointLimiter.originalMinRot[3]=jointDesc.minRot[3];
      else
        if self.attacherJointLimiter.originalMaxRot[1]~=jointDesc.maxRot[1] and self.attacherJointLimiter.originalMinRot[1]~=jointDesc.minRot[1] then
          return;
        end;
      end;
      local A_x, A_y, A_z = getWorldTranslation(jointDesc.rotationNode);
      local B_x, B_y, B_z = getWorldTranslation(self.attacherJointLimiter.upPoint);
      if self.seederIsDown then
        B_x, B_y, B_z = getWorldTranslation(self.attacherJointLimiter.downPoint);
      end;
      --local C_x, C_y, C_z = getWorldTranslation(jointDesc.jointTransform);
      local C_x, C_y, C_z = getWorldTranslation(self.attacherJoint.node);
      local a = Utils.vector3Length(B_x-C_x, B_y-C_y, B_z-C_z);
      local b = Utils.vector3Length(C_x-A_x, C_y-A_y, C_z-A_z);
      local c = Utils.vector3Length(B_x-A_x, B_y-A_y, B_z-A_z);
      local alfa1 = math.deg(math.acos(((b*b)+(c*c)-(a*a))/(2*b*c)));
      --[[self.A = {A_x, A_y, A_z};
      self.B = {B_x, B_y, B_z};
      self.C = {C_x, C_y, C_z};]]--
      B_y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, B_x, B_y, B_z);
      --self.B1= {B_x, B_y, B_z};
      a = Utils.vector3Length(B_x-C_x, B_y-C_y, B_z-C_z);
      b = Utils.vector3Length(C_x-A_x, C_y-A_y, C_z-A_z);
      c = Utils.vector3Length(B_x-A_x, B_y-A_y, B_z-A_z);
      local rot = jointDesc.minRot;
      local rx = self.attacherJointLimiter.originalMinRot[1];
      if self.seederIsDown then
        rot = jointDesc.maxRot;
        rx  = self.attacherJointLimiter.originalMaxRot[1];
      end;
      local alfa2 = math.deg(math.acos(((b*b)+(c*c)-(a*a))/(2*b*c)));
      local uhel = math.deg(rx)+(alfa1-alfa2);
      --[[
      print("rx   ="..tostring(math.deg(rx)));
      print("alfa1="..tostring(alfa1));
      print("alfa2="..tostring(alfa2));
      print("uhel ="..tostring(uhel));]]--
      rot[1]=Utils.degToRad(uhel);
      self.isReadyForManualAttacherAdjust = true;
    end;
  end;
end;
function Farmet_Excelent_Premium_6:draw()
  if self.fertilizerInstalled then
    local percent = 0;
    local capacity = self.fertilizerCapacity;
    local level = self.fertilizerLevel;
    if capacity > 0 then -- skip if there's no capacity
      percent = level / capacity * 100;
      self.fertilizerBarOverlay.width = self.hudBarWidth * (level / capacity); -- TODO: check for division by zero!
      setOverlayUVs(self.fertilizerBarOverlay.overlayId, 0, 0.05, 0, 1, level / capacity, 0.05, level / capacity, 1);
      self.fertilizerBarOverlay:render();
    end;
    if self.lastAttacherVehicle ~= nil then
      self.lastAttacherVehicle.hudFramesOverlay:render();
    end;
  end;
  if self.isClient then
    if (self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN) and (self.fillLevel>0) then
      local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
      if fruitType ~= nil then
        g_currentMission:setFruitOverlayFruitType(fruitType);
      end;
    end;
  end;
  --[[if self.A ~= nil then
    setTextAlignment(RenderText.ALIGN_CENTER);
    local x, y, z = project(self.A[1], self.A[2], self.A[3]);    
    renderText(x, y, 0.02,"A");	    
    x, y, z = project(self.B[1], self.B[2], self.B[3]);    
    renderText(x, y, 0.02,"B");
    x, y, z = project(self.B1[1], self.B1[2], self.B1[3]);    
    renderText(x, y, 0.02,"B1");
    x, y, z = project(self.C[1], self.C[2], self.C[3]);    
    renderText(x, y, 0.02,"C");
    setTextAlignment(RenderText.ALIGN_LEFT);        
  end;]]--
  if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
    g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL1)), 0.092, 0.048)
  end
end;


function Farmet_Excelent_Premium_6:allowFillType(fillType, allowEmptying)
  if self.sailOpen or self.ignoreMyAllowFillType then
    if fillType == Fillable.FILLTYPE_FERTILIZER then
     return self.fertilizerInstalled; 
    else
      return Fillable.allowFillType(self, fillType, allowEmptying);
    end;
  else
    return false;
  end;
end;

function Farmet_Excelent_Premium_6:setFertilizerInstalled(fertilizerInstalled, noEventSend)
  if fertilizerInstalled~=self.fertilizerInstalled then
    self.fertilizerInstalled = fertilizerInstalled;
    setVisibility(self.fertilizerBin, self.fertilizerInstalled);
    setVisibility(self.fertilizerPlaneHide, not self.fertilizerInstalled);
    if self.fertilizerInstalled then
      self.capacity=self.overAllCapacity-self.fertilizerCapacity;
      for _, fillPlane in pairs(self.fillPlanes) do
        for __, node in ipairs(fillPlane.nodes) do
          if node.node == self.fertilizerChangePlane.node then
            for ___, keyFrame in pairs(node.animCurve.keyframes) do
              if keyFrame.time == self.fertilizerChangePlane.time then
                self.fertilizerChangePlane.original = {};
                self.fertilizerChangePlane.original.x = keyFrame.x;
                self.fertilizerChangePlane.original.y = keyFrame.y;
                self.fertilizerChangePlane.original.z = keyFrame.z;
                self.fertilizerChangePlane.original.rx = keyFrame.rx;
                self.fertilizerChangePlane.original.ry = keyFrame.ry;
                self.fertilizerChangePlane.original.rz = keyFrame.rz;
                self.fertilizerChangePlane.original.sx = keyFrame.sx;
                self.fertilizerChangePlane.original.sy = keyFrame.sy;
                self.fertilizerChangePlane.original.sz = keyFrame.sz;

                keyFrame.x = Utils.getNoNil(self.fertilizerChangePlane.x, keyFrame.x);
                keyFrame.y = Utils.getNoNil(self.fertilizerChangePlane.y, keyFrame.y);
                keyFrame.z = Utils.getNoNil(self.fertilizerChangePlane.z, keyFrame.z);

                keyFrame.rx = Utils.getNoNil(self.fertilizerChangePlane.rx, keyFrame.rx);
                keyFrame.ry = Utils.getNoNil(self.fertilizerChangePlane.ry, keyFrame.ry);
                keyFrame.rz = Utils.getNoNil(self.fertilizerChangePlane.yz, keyFrame.rz);

                keyFrame.sx = Utils.getNoNil(self.fertilizerChangePlane.sx, keyFrame.sx);
                keyFrame.sy = Utils.getNoNil(self.fertilizerChangePlane.sy, keyFrame.sy);
                keyFrame.sz = Utils.getNoNil(self.fertilizerChangePlane.sz, keyFrame.sz);
              end;
            end;
          end;
        end;
      end;
    else
      self.capacity=self.overAllCapacity;
      for _, fillPlane in pairs(self.fillPlanes) do
        for __, node in ipairs(fillPlane.nodes) do
          if node.node == self.fertilizerChangePlane.node then
            for ___, keyFrame in pairs(node.animCurve.keyframes) do
              if keyFrame.time == self.fertilizerChangePlane.time then

                keyFrame.x  = self.fertilizerChangePlane.original.x;
                keyFrame.y  = self.fertilizerChangePlane.original.y;
                keyFrame.z  = self.fertilizerChangePlane.original.z;
                keyFrame.rx = self.fertilizerChangePlane.original.rx;
                keyFrame.ry = self.fertilizerChangePlane.original.ry;
                keyFrame.rz = self.fertilizerChangePlane.original.rz;
                keyFrame.sx = self.fertilizerChangePlane.original.sx;
                keyFrame.sy = self.fertilizerChangePlane.original.sy;
                keyFrame.sz = self.fertilizerChangePlane.original.sz;

                self.fertilizerChangePlane.original = nil;
              end;
            end;
          end;
        end;
      end;
    end;
    self:loadAttacherVehicleHUD();
  end;
end;

function Farmet_Excelent_Premium_6:setFillLevel(fillLevel, fillType, force)
  if (fillType == Fillable.FILLTYPE_FERTILIZER) and self.fertilizerInstalled then
    if (force == nil or force == false) and not self:allowFillType(fillType, false) then
        return
    end;
    self.fertilizerLevel = fillLevel;
    if self.fertilizerLevel > self.fertilizerCapacity then
        self.fertilizerLevel = self.fertilizerCapacity;
    end;
    if self.fertilizerLevel < 0 then
        self.fertilizerLevel = 0;        
    end;
    if self.isClient then
        if self.fertilizerPlane ~= nil then
            local fillPlane = self.fertilizerPlane;
            local t = self.fertilizerLevel/self.fertilizerCapacity;
            for _, node in ipairs(fillPlane.nodes) do
                local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);

                setTranslation(node.node, x, y, z);
                setRotation(node.node, rx, ry, rz);
                setScale(node.node, sx, sy, sz);
                setVisibility(node.node, self.fertilizerLevel > 0);
            end;
        end;
    end;
  else
    self.oldSetFillLevel(self, fillLevel, fillType, force);
    if self.isClient then
      local fillPlane = self.defaultFillPlane;      
      for _, node in ipairs(fillPlane.nodes) do
        setVisibility(node.node, self.fillLevel > 0);
        setShaderParameter(node.node, "UVPlaneOffset", (self.fillPlaneOffset[fillType]), 4, 0, 0, false);
      end;
      self.currentFillPlane = fillPlane;
    end;        
  end; 
end;

function Farmet_Excelent_Premium_6:loadAttacherVehicleHUD(detach)
  local s=self.lastAttacherVehicle;
  local b=self.fertilizerInstalled;
  if detach~=nil and detach then
    b = false;
  end;
  if s ~= nil then
    if s.hudBarGoldOverlay then
      s.hudBarGoldOverlay:delete();
    end;
    if b then
      s.hudBarGoldOverlay = Overlay:new("hudBarGoldOverlay", Utils.getFilename("$dataS2/menu/hud/vehicleHUD_barGold.png", self.baseDirectory), s.hudBasePosX + s.hudBarOffsetX, s.hudBasePosY + s.hudBarStartOffsetY + 1 * s.hudBarOffsetY + s.hudBarHeight/2, s.hudBarWidth, s.hudBarHeight/2);
    else
      s.hudBarGoldOverlay = Overlay:new("hudBarGoldOverlay", Utils.getFilename("$dataS2/menu/hud/vehicleHUD_barGold.png", self.baseDirectory), s.hudBasePosX + s.hudBarOffsetX, s.hudBasePosY + s.hudBarStartOffsetY + 1 * s.hudBarOffsetY, s.hudBarWidth, s.hudBarHeight);
    end;
  end;
end;

function Farmet_Excelent_Premium_6:onAttach(attacherVehicle)
  self:setWorkLight(false);
  self.currentlyAttachedTimer = 1000;
  self.isReadyForManualAttacherAdjust = false;
  self.lastAttacherVehicle=attacherVehicle;
  self:loadAttacherVehicleHUD();
end;

function Farmet_Excelent_Premium_6:onDetach()
  self:setWorkLight(false);
  self:setIsTurnedOn(false);
  self:loadAttacherVehicleHUD(true);
  self.lastAttacherVehicle=nil;
  if self.lastJointDesc~=nil then
    self.lastJointDesc.maxRot[1]=self.attacherJointLimiter.originalMaxRot[1];
    self.lastJointDesc.maxRot[2]=self.attacherJointLimiter.originalMaxRot[2];
    self.lastJointDesc.maxRot[3]=self.attacherJointLimiter.originalMaxRot[3];
    self.attacherJointLimiter.originalMaxRot = nil;
    self.lastJointDesc.minRot[1]=self.attacherJointLimiter.originalMinRot[1];
    self.lastJointDesc.minRot[2]=self.attacherJointLimiter.originalMinRot[2];
    self.lastJointDesc.minRot[3]=self.attacherJointLimiter.originalMinRot[3];
    self.attacherJointLimiter.originalMinRot = nil;
    self.lastJointDesc=nil
  end;  
  self.isDefaultLowered = self.seederIsDown;
end;

function Farmet_Excelent_Premium_6:aiTurnOn()
  self:setIsTurnedOn(true);
  self:setSeederIsDown(true);
end;

function Farmet_Excelent_Premium_6:aiLower()
  self.lastCultivatingArea = nil;
  self:setSeederIsDown(true);
end;

function Farmet_Excelent_Premium_6:aiRaise()
  if self.lastCultivatingArea~=nil and self.fillLevel>0 then
    local currentSeed = FruitUtil.fillTypeToFruitType[self.currentFillType];
    local area = SowingMachineAreaEvent.runLocally(self.lastCultivatingArea, currentSeed)
    if area > 0 then
      local pixelToSqm = g_currentMission:getTerrainDetailPixelsToSqm(); -- 8192px are mapped to 2048m
      local sqm = (area*pixelToSqm)/5;
      local ha = sqm/10000;

      self.lastSowingArea = sqm;

      local usage = sqm*self.seedUsage[self.currentFillType];
      g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
      g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

      g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
      g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

      self.ignoreMyAllowFillType = true;
      self:setFillLevel(self.fillLevel - usage, self.currentFillType);
      self.ignoreMyAllowFillType = false;
      g_server:broadcastEvent(SowingMachineAreaEvent:new(self.lastCultivatingArea, currentSeed));
    end;
  end;
  self:setSeederIsDown(false);
end;

function getUserInRange(node, minDistance)
  local result = false; 
  local px, py, pz = getWorldTranslation(node);
  if g_currentMission.player.isEntered then
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
    if distance < minDistance then		
      result = true;
    end;
  end;
  return result;
end;

function getIsBigBagInRange(fillType, node, minDistance)
  local result = nil;
  local px, py, pz = getWorldTranslation(node);
  for _, trailer in pairs(g_currentMission.objectToTrailer) do
    if (trailer.FARMET_EP6_BIGBAG) and (trailer.currentFillType==fillType) then
      local vx, vy, vz = getWorldTranslation(trailer.fillRootNode);
      local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
      if distance < minDistance then
        result = trailer;
        minDistance = distance;
      end;
    end;
  end;
  return result;
end;
