﻿--
-- BGAControl
--
-- (c) by Wagenheber
-- > 28.04.2011 < --
--
-- Edit by Webalizer
-- > 10.02.2012 < --
--
-- Edit by Wagenheber
-- > 18.02.2012 < --

BGAControl = {};
BGAControl.modDirectory = g_currentModDirectory;
BGAControl.modDirectoryList = getUserProfileAppPath() .. "mods/"

function BGAControl:loadMap(name)

	self.BGAHUD = createImageOverlay(BGAControl.modDirectory .. "SMARTHUD.png");
	self.BGACount = 1;
	self.SiloCount = 1;
	self.textB = 0.019;
	self.textS = 0.015;
	self.textXS = 0.012;
	BGAControl:getAllBGACount();
	BGAControl:getAllSiloCount();
	self.BGAControlStatus = false;
	self.confirmedWarning = false;
	
	-- Festlegen der Position
	self.siloXPos = 0.151;
	
	-- Texte
	self.bgalevels = g_i18n:getText("BGAControl_bgalevels");
	self.bgasilos = g_i18n:getText("BGAControl_bgasilos");
	self.unit = g_i18n:getText("BGAControl_unit");
	self.level = g_i18n:getText("BGAControl_level");
	self.compaction = g_i18n:getText("BGAControl_compaction");
	self.actual = g_i18n:getText("BGAControl_actual");
	self.yesterday = g_i18n:getText("BGAControl_yesterday");
	self.price = g_i18n:getText("BGAControl_price");
	self.warning = g_i18n:getText("BGAControl_warning");
	self.notSpecified = g_i18n:getText("BGAControl_notSpecified");
	self.confirmInfo = g_i18n:getText("BGAControl_confirmInfo");
		
	
end;

-- Prüft Vorhandensein der MapBGA und der MapBGASilo
function BGAControl:getZIP(fileName, Ordner) 

	if Ordner == false then
	
		if fileName == "MapBGA.zip" then
			BGAControl.MapBGAExist = true;
		end;
	
		if fileName == "MapBGASilo.zip" then
			BGAControl.MapBGASiloExist = true;
		end;
		
	end;

end;

-- Zählt BGAs
function BGAControl:getAllBGACount()

	self.gesBGA = 1;
	local ready = false
    repeat
        if MapBGA.ModEvent.bunkers[self.gesBGA] ~= nil then
			self.gesBGA = self.gesBGA + 1;
		else
			ready = true;
			self.gesBGA = self.gesBGA - 1;
		end;
    until ready == true;
	
end;

-- Zählt Silos
function BGAControl:getAllSiloCount()

	self.gesSilos = 1;
	local ready = false
    repeat
        if MapBGASilo.ModEvent.silos[self.gesSilos] ~= nil then
			self.gesSilos = self.gesSilos + 1;
		else
			ready = true;
			self.gesSilos = self.gesSilos - 1;
		end;
    until ready == true;
	
end;

function BGAControl:deleteMap()
end;

function BGAControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BGAControl:keyEvent(unicode, sym, modifier, isDown)
	
	-- Ein / Aus
	if InputBinding.isPressed(InputBinding.BGAControl_onoff) then
		if self.BGAControlStatus == false then
			self.pdaLastState = g_currentMission.missionPDA.showPDA;
			if g_currentMission.missionPDA.showPDA == true then
				g_currentMission.missionPDA.showPDA = false;
			end;
			self.BGAControlStatus =  not self.BGAControlStatus;
		else
			self.BGAControlStatus =  not self.BGAControlStatus;
			g_currentMission.missionPDA.showPDA = self.pdaLastState;
		end;
	end;
	
	-- Aus wenn PDA an
	if InputBinding.isPressed(InputBinding.TOGGLE_PDA) then
		self.BGAControlStatus = false;
	end;
	
	-- BGA wechseln
	if InputBinding.isPressed(InputBinding.BGAControl_switchBGA) then
		if self.BGACount < self.gesBGA then 
			self.BGACount = self.BGACount + 1;
		else
			self.BGACount = 1;
		end;
	end;
	
	-- Silo Liste weiterschalten
	if InputBinding.isPressed(InputBinding.BGAControl_switchSilo) then
		if (self.SiloCount + 6) < self.gesSilos then 
			self.SiloCount = self.SiloCount + 1;
		else
			self.SiloCount = 1;
		end;
	end;
	
	-- Alarm bestätigen
	if InputBinding.isPressed(InputBinding.BGAControl_ignore) then
		self.confirmedWarning = true;
	end;
	
end;

function BGAControl:update(dt)
end;

function BGAControl:draw()
	
	
	if MapBGA.ModEvent.bunkers[1] ~= nil then
	
		-- Negative Manure Werte vermeiden
		if MapBGA.ModEvent.bunkers[self.BGACount].manure.fillLevel < 0 then
			self.correctManureFilllevel = 0;
		else
			self.correctManureFilllevel = MapBGA.ModEvent.bunkers[self.BGACount].manure.fillLevel;
		end;
		
		-- Bunkerzahl unter 5% -> Rot
		if (MapBGA.ModEvent.bunkers[self.BGACount].fillLevel/MapBGA.ModEvent.bunkers[self.BGACount].capacity)*100 < 5 then
			self.BunkerColorR = 1.0;
			self.BunkerColorG = 0.1;
			self.BunkerColorB = 0.1;
		else
			self.BunkerColorR = 0.95;
			self.BunkerColorG = 0.95;
			self.BunkerColorB = 0.95;
		end;
		
		-- Güllepott über 95% -> Rot
		if (self.correctManureFilllevel/MapBGA.ModEvent.bunkers[self.BGACount].manure.capacity)*100 > 95 then
			self.ManureColorR = 1.0;
			self.ManureColorG = 0.1;
			self.ManureColorB = 0.1;
		else
			self.ManureColorR = 0.1;
			self.ManureColorG = 0.1;
			self.ManureColorB = 0.1;
		end;
	
		if self.BGAControlStatus == true then
		
			-- HUD anzeigen
			renderOverlay(self.BGAHUD, 0.01, 0.01, 0.68, 0.9);
			
			-- Switch BGA-Taste anzeigen
			setTextBold(false);
			setTextColor(1, 1, 1, 0.7);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.39, 0.2, self.textXS, InputBinding.getKeyNamesOfDigitalAction(InputBinding.BGAControl_switchBGA));
			
			-- Switch Silo-Taste anzeigen
			setTextBold(false);
			setTextColor(1, 1, 1, 0.7);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.39, 0.05, self.textXS, InputBinding.getKeyNamesOfDigitalAction(InputBinding.BGAControl_switchSilo));
			
			-- BGA: Überschrift + Anlagenzahl
			setTextBold(true);
			setTextColor(0.13, 0.45, 0.27, 1);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(0.08, 0.243, self.textB, self.bgalevels);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(0.35, 0.245, self.textS, self.unit .. " " .. tostring(self.BGACount .. " / " .. self.gesBGA));
			
			-- BGA: Füllstände
			setTextColor(self.ManureColorR, self.ManureColorG, self.ManureColorB, 1);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(0.345, 0.188, self.textB, tostring(math.floor(self.correctManureFilllevel)) .. " l");
			setTextBold(false);
			renderText(0.345, 0.174, self.textS, "Max. " .. tostring(MapBGA.ModEvent.bunkers[self.BGACount].manure.capacity) .. " l");
			setTextBold(true);
			setTextColor(self.BunkerColorR, self.BunkerColorG, self.BunkerColorB, 1);
			renderText(0.188, 0.188, self.textB, tostring(math.floor(MapBGA.ModEvent.bunkers[self.BGACount].fillLevel)) .. " l");
			setTextBold(false);
			renderText(0.188, 0.174, self.textS, "Max. " .. tostring(MapBGA.ModEvent.bunkers[self.BGACount].capacity) .. " l");
			
			-- BGA: Geld Überschriften
			setTextColor(0.1, 0.1, 0.1, 1);
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.153, 0.135, self.textXS, self.actual);
			renderText(0.25, 0.135, self.textXS, self.yesterday);
			renderText(0.33, 0.135, self.textXS, self.price);
			-- BGA: Geld Werte
			setTextColor(0.95, 0.95, 0.95, 1);
			setTextBold(true);
			
			-- Falls Server ... sonst ...
			if g_server ~= nil then
				renderText(0.153, 0.115, self.textB, tostring(math.floor(MapBGA.ModEvent.bunkers[self.BGACount].money)));
				renderText(0.25, 0.115, self.textB, tostring(math.floor(MapBGA.ModEvent.bunkers[self.BGACount].yesterDayMoney )));
			else
				renderText(0.153, 0.115, self.textB, self.notSpecified);
				renderText(0.25, 0.115, self.textB, self.notSpecified);
			end;
			
			renderText(0.33, 0.115, self.textB, tostring((math.floor(MapBGA.ModEvent.bunkers[self.BGACount].electricityPrice*100))/100));
			
			-- Silos: Überschrift + Silozahl
			setTextColor(0.13, 0.45, 0.27, 1);
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(0.08, 0.091, self.textB, self.bgasilos);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(0.35, 0.093, self.textS, tostring(self.SiloCount .. " - " .. (self.SiloCount + 6)));
			
			-- Silos: Bezeichnung / Tertium Comparationis
			setTextColor(0.1, 0.1, 0.1, 1);
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(0.135, 0.065, self.textXS, self.level);
			renderText(0.135, 0.045, self.textXS, self.compaction);
			
			-- Silos: Füllstände
			setTextColor(0.13, 0.45, 0.27, 1);
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			
			if self.gesSilos > 6 then
				self.Rest = 6;
			else
				self.Rest = self.gesSilos - 1;
			end;
			
			i = self.SiloCount;
			self.siloTextPos = self.siloXPos;
			while i <= (self.SiloCount + self.Rest) do

				self.Percent = math.floor(100 / MapBGASilo.ModEvent.silos[i].silage.maxFillLevel * math.floor(MapBGASilo.ModEvent.silos[i].silage.fillLevel));
				renderText(self.siloTextPos, 0.065, self.textS, tostring(self.Percent));
				self.siloTextPos = self.siloTextPos + 0.032;
				i = i + 1;
				
			end;
			
			-- Silos: Verdichtung
			j = self.SiloCount;
			self.siloTextPos = self.siloXPos;
			setTextColor(0.35, 0.3, 0, 1);
			
			while j  <= (self.SiloCount + self.Rest) do
				if MapBGASilo.ModEvent.silos[j].silage.fillLevel > 0 and MapBGASilo.ModEvent.silos[j].compFillLevel ~= nil then
					self.Compression = math.floor((MapBGASilo.ModEvent.silos[j].compFillLevel / MapBGASilo.ModEvent.silos[j].silage.fillLevel)*100);
					renderText(self.siloTextPos, 0.045, self.textS, tostring(self.Compression));
				end;
				self.siloTextPos = self.siloTextPos + 0.032;
				j = j + 1;
			end;
			setTextAlignment(RenderText.ALIGN_Left);
		end;
		
		-- Warnung Bunker leer
		if self.lastEmptyBunkers ~= self.emptyBunkers then
			self.confirmedWarning = false;
		end;
		
		self.lastEmptyBunkers = self.emptyBunkers;
		
		self.emptyBunkers = ""
		for i = 1, self.gesBGA, 1 do
			if MapBGA.ModEvent.bunkers[i].fillLevel == 0 then
				self.emptyBunkers = self.emptyBunkers .. "[" .. i .. "] ";
			end;
		end;
		
		if  g_currentMission.missionPDA.showPDA == false and self.BGAControlStatus == false then
			
			if self.emptyBunkers ~= "" and self.confirmedWarning == false then
				setTextColor(0, 0, 0, 1);	
				setTextBold(false);
				setTextAlignment(RenderText.ALIGN_CENTER);
				renderText(0.5, 0.05, 0.03, self.warning .. " " .. self.emptyBunkers);
				renderText(0.5, 0.03, self.textS, self.confirmInfo .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.BGAControl_ignore));
				setTextAlignment(RenderText.ALIGN_Left);
			end;
			
		end;
		
	end;
	
end;

-- Lädt BGA Control nur zusammen mit MapBGA und MapBGASilo
BGAControl.MapBGAExist = false;
BGAControl.MapBGASiloExist = false;

getFiles(BGAControl.modDirectoryList, "getZIP", BGAControl);

if BGAControl.MapBGAExist and BGAControl.MapBGASiloExist then
	print("  BGAControl loaded");
	addModEventListener(BGAControl);
else
	print("  BGAControl failed to load: MapBGA.zip and/or MapBGASilo.zip wasn't found!")
end;