-- SetDoorStateEvent
-- Specialisation to send the current wheelstate
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  03/12/2010

SetDoorStateEvent = {};
SetDoorStateEvent_mt = Class(SetDoorStateEvent, Event);

InitEventClass(SetDoorStateEvent, "SetDoorStateEvent");

function SetDoorStateEvent:emptyNew()
    local self = Event:new(SetDoorStateEvent_mt);
    self.className = "SetDoorStateEvent";
    return self;
end;

function SetDoorStateEvent:new(object, newDoorIsOpened)
    local self = SetDoorStateEvent:emptyNew()
    self.object = object;
	self.doorIsOpened = newDoorIsOpened;
    return self;
end;

function SetDoorStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.doorIsOpened = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetDoorStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.doorIsOpened);
end;

function SetDoorStateEvent:run(connection)
	self.object:setDoorState(self.doorIsOpened, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDoorStateEvent:new(self.object, self.doorIsOpened), nil, connection, self.object);
    end;
end;

function SetDoorStateEvent.sendEvent(object, newDoorIsOpened, noEventSend)
	if object.doorIsOpened ~= newDoorIsOpened then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetDoorStateEvent:new(object, newDoorIsOpened), nil, nil, object);
			else
				g_client:getServerConnection():sendEvent(SetDoorStateEvent:new(object, newDoorIsOpened));
			end;
		end;
	end;
end;

