--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));

	-- load the pda symbol
	
	nordmilchpic = Utils.getFilename("pdasymbols/nordmilch.png", self.baseDirectory);
	baywapic = Utils.getFilename("pdasymbols/baywa.png", self.baseDirectory);  
    	frickepic = Utils.getFilename("pdasymbols/fricke.png", self.baseDirectory);  
	Hofpic = Utils.getFilename("pdasymbols/Hof.png", self.baseDirectory);  
	weidepic = Utils.getFilename("pdasymbols/weide.png", self.baseDirectory); 
    	biogaspic = Utils.getFilename("pdasymbols/biogas.png", self.baseDirectory);  
    	raiffeisenpic = Utils.getFilename("pdasymbols/raiffeisen.png", self.baseDirectory); 	
	billingerpic = Utils.getFilename("pdasymbols/billinger.png", self.baseDirectory);
	
     -- create Map Hotspot
    self.missionPDA:createMapHotspot("baywa", baywapic, 1609, 326, 0.025, 0.025, false, false, 0);
	
	 -- create Map Hotspot
    self.missionPDA:createMapHotspot("nordmilch", nordmilchpic, 1573, 591, 0.025, 0.025, false, false, 0);
	
	 -- create Map Hotspot
    self.missionPDA:createMapHotspot("Hof", Hofpic, 1693, 1203, 0.025, 0.025, false, false, 0);
		
	 -- create Map Hotspot
    self.missionPDA:createMapHotspot("fricke", frickepic, 1507, 964, 0.025, 0.025, false, false, 0);

	 -- create Map Hotspot
    self.missionPDA:createMapHotspot("Biogas", biogaspic, 947, 1676, 0.025, 0.025, false, false, 0);
	
	 -- create Map Hotspot
    self.missionPDA:createMapHotspot("Billinger", billingerpic, 1423, 1100, 0.025, 0.025, false, false, 0);
	
	 -- create Map Hotspot
    self.missionPDA:createMapHotspot("Weide", weidepic, 1200, 267, 0.025, 0.025, false, false, 0);	
	
	 -- create Map Hotspot
    self.missionPDA:createMapHotspot("raiffeisen", raiffeisenpic, 573, 1894, 0.025, 0.025, false, false, 0);
    

    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
